/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.container.Engine;
import com.tongweb.container.Valve;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.valves.RemoteIpValve;
import com.tongweb.container.valves.StuckThreadDetectionValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.StuckThreadDetectionConf;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.bean.TongwebConfig;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.utils.PropertyMapper;
import com.tongweb.starter.utils.StringUtils;

public class EngineConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(EngineConfigHandler.class);
    private ServletContainer tongweb;
    private Engine engine;

    public EngineConfigHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
        this.engine = tongweb.getEngine();
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Engine Config Start.");
        }
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(tongWebProperties.getTongweb().getBackgroundProcessorDelay()).whenNonNull().as(Long::intValue).to(arg_0 -> ((Engine)this.engine).setBackgroundProcessorDelay(arg_0));
        this.customizeRemoteIpValve(tongWebProperties);
        this.customizeStuckThreadDetectionValue(tongWebProperties.getTongweb().getStuckThreadDetection());
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Engine Config End.");
        }
    }

    private void customizeRemoteIpValve(TongWebProperties tongWebProperties) {
        TongwebConfig tongwebBean = tongWebProperties.getTongweb();
        String protocolHeader = tongwebBean.getProtocolHeader();
        String remoteIpHeader = tongwebBean.getRemoteIpHeader();
        if (StringUtils.hasText(protocolHeader) || StringUtils.hasText(remoteIpHeader) || this.getOrDeduceUseForwardHeaders(tongWebProperties)) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength(protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength(remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(tongwebBean.getInternalProxies());
            valve.setHostHeader(tongwebBean.getHostHeader());
            valve.setPortHeader(tongwebBean.getPortHeader());
            valve.setProtocolHeaderHttpsValue(tongwebBean.getProtocolHeaderHttpsValue());
            this.engine.getPipeline().addValve((Valve)valve);
        }
    }

    private void customizeStuckThreadDetectionValue(StuckThreadDetectionConf stuckThreadDetection) {
        if (stuckThreadDetection.getThreshold() != 0) {
            StuckThreadDetectionValve valve = new StuckThreadDetectionValve();
            valve.setThreshold(stuckThreadDetection.getThreshold());
            valve.setInterruptThreadThreshold(stuckThreadDetection.getInterruptThreadThreshold());
            this.engine.getPipeline().addValve((Valve)valve);
        }
    }

    private boolean getOrDeduceUseForwardHeaders(TongWebProperties tongWebProperties) {
        return tongWebProperties.getForwardHeadersStrategy().equals((Object)TongWebProperties.ForwardHeadersStrategy.NATIVE);
    }
}

