/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.container.Host;
import com.tongweb.container.Valve;
import com.tongweb.container.core.StandardHost;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.valves.AbstractAccessLogValve;
import com.tongweb.container.valves.AccessLogValve;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.container.valves.ExtendedAccessLogValve;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.container.valves.RemoteAddrValve;
import com.tongweb.container.valves.RemoteHostValve;
import com.tongweb.container.valves.SemaphoreValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.Accesslog;
import com.tongweb.starter.bean.RemoteFilter;
import com.tongweb.starter.bean.SemaphoreConf;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.utils.PropertyMapper;
import com.tongweb.starter.utils.StringUtils;

public class HostConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(HostConfigHandler.class);
    private ServletContainer tongweb;
    private Host host;

    public HostConfigHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
        this.host = tongweb.getHost();
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Host Config Start.");
        }
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        this.tongweb.getHost().setAutoDeploy(false);
        map.from(tongWebProperties.getTongweb().getAccesslog()).whenNonNull().when(Accesslog::isEnabled).to(this::customizeAccessLog);
        map.from(tongWebProperties.getTongweb().getFilter().getRemote()).whenNonNull().when(RemoteFilter::isEnabled).to(this::customizeRemoteFilter);
        map.from(tongWebProperties.getTongweb().getSemaphore()).when(SemaphoreConf::isEnabled).to(this::customizeSemaphore);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Host Config End.");
        }
    }

    private void customizeAccessLog(Accesslog accessLogConfig) {
        ExtendedAccessLogValve valve;
        PropertyMapper map = PropertyMapper.get();
        if (accessLogConfig.isLogExtend()) {
            valve = new ExtendedAccessLogValve();
            if (accessLogConfig.getPattern().contains("%") || accessLogConfig.getPattern().equalsIgnoreCase("common")) {
                log.warn((Object)"If setting server.tongweb.accesslog.log-extend=true, need change pattern to extended mode pattern.");
                log.warn((Object)"for example:");
                log.warn((Object)"\tserver.tongweb.accesslog.pattern=date time time-taken cs-method cs-uri sc-status");
            }
        } else {
            valve = new AccessLogValve();
        }
        map.from(accessLogConfig.getConditionIf()).to(arg_0 -> ((AccessLogValve)valve).setConditionIf(arg_0));
        map.from(accessLogConfig.isAsciiToNative()).to(AbstractAccessLogValve::setAsciiToNative);
        map.from(accessLogConfig.getConditionUnless()).to(arg_0 -> ((AccessLogValve)valve).setConditionUnless(arg_0));
        map.from(accessLogConfig.getDirectory()).to(arg_0 -> ((AccessLogValve)valve).setDirectory(arg_0));
        map.from(accessLogConfig.getEncoding()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setEncoding(arg_0));
        map.from(accessLogConfig.getPattern()).to(arg_0 -> ((AccessLogValve)valve).setPattern(arg_0));
        map.from(accessLogConfig.getPrefix()).to(arg_0 -> ((AccessLogValve)valve).setPrefix(arg_0));
        map.from(accessLogConfig.getSuffix()).to(arg_0 -> ((AccessLogValve)valve).setSuffix(arg_0));
        map.from(accessLogConfig.getLocale()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setLocale(arg_0));
        map.from(accessLogConfig.isCheckExists()).to(arg_0 -> ((AccessLogValve)valve).setCheckExists(arg_0));
        map.from(accessLogConfig.isRotate()).to(arg_0 -> ((AccessLogValve)valve).setRotatable(arg_0));
        map.from(accessLogConfig.isRenameOnRotate()).to(arg_0 -> ((AccessLogValve)valve).setRenameOnRotate(arg_0));
        map.from(accessLogConfig.getMaxDays()).to(arg_0 -> ((AccessLogValve)valve).setMaxDays(arg_0));
        map.from(accessLogConfig.getFileDateFormat()).to(arg_0 -> ((AccessLogValve)valve).setFileDateFormat(arg_0));
        map.from(accessLogConfig.isIpv6Canonical()).to(arg_0 -> ((AccessLogValve)valve).setIpv6Canonical(arg_0));
        map.from(accessLogConfig.isRequestAttributesEnabled()).to(arg_0 -> ((AccessLogValve)valve).setRequestAttributesEnabled(arg_0));
        map.from(accessLogConfig.isBuffered()).to(arg_0 -> ((AccessLogValve)valve).setBuffered(arg_0));
        map.from(accessLogConfig.getMaxLogMessageBufferSize()).to(arg_0 -> ((AccessLogValve)valve).setMaxLogMessageBufferSize(arg_0));
        this.host.getPipeline().addValve((Valve)valve);
    }

    private void customizeRemoteFilter(RemoteFilter filter) {
        String allowAddr = filter.getAllowAddr();
        String allowHost = filter.getAllowHost();
        String denyAddr = filter.getDenyAddr();
        String denyHost = filter.getDenyHost();
        Integer status = filter.getDenyStatus();
        Valve[] valves = this.host.getPipeline().getValves();
        for (int i = 0; valves != null && i < valves.length; ++i) {
            if (valves[i] instanceof RemoteAddrValve) {
                this.host.getPipeline().removeValve(valves[i]);
            }
            if (!(valves[i] instanceof RemoteHostValve)) continue;
            this.host.getPipeline().removeValve(valves[i]);
        }
        if (allowAddr != null || denyAddr != null) {
            RemoteAddrValve remoteAddrValve = new RemoteAddrValve();
            remoteAddrValve.setDenyStatus(status.intValue());
            if (allowAddr != null) {
                if (allowAddr.equals("*")) {
                    allowAddr = ".*";
                }
                remoteAddrValve.setAllow(allowAddr);
            }
            if (denyAddr != null) {
                if (denyAddr.equals("*")) {
                    denyAddr = ".*";
                }
                remoteAddrValve.setDeny(denyAddr);
            }
            if (remoteAddrValve != null) {
                this.host.getPipeline().addValve((Valve)remoteAddrValve);
            }
        }
        if (!(allowHost == null & denyHost == null)) {
            RemoteHostValve remoteHostValve = new RemoteHostValve();
            remoteHostValve.setDenyStatus(status.intValue());
            if (allowHost != null) {
                if (allowHost.equals("*")) {
                    allowHost = ".*";
                }
                remoteHostValve.setAllow(allowHost);
            }
            if (denyHost != null) {
                if (denyHost.equals("*")) {
                    denyHost = ".*";
                }
                remoteHostValve.setDeny(denyHost);
            }
            if (remoteHostValve != null) {
                this.host.getPipeline().addValve((Valve)remoteHostValve);
            }
        }
    }

    private void customizeSemaphore(SemaphoreConf semaphoreConfig) {
        SemaphoreValve valve = new SemaphoreValve();
        PropertyMapper map = PropertyMapper.get();
        map.from(semaphoreConfig.getConcurrency()).to(arg_0 -> ((SemaphoreValve)valve).setConcurrency(arg_0));
        map.from(semaphoreConfig.isFairness()).to(arg_0 -> ((SemaphoreValve)valve).setFairness(arg_0));
        map.from(semaphoreConfig.isBlock()).to(arg_0 -> ((SemaphoreValve)valve).setBlock(arg_0));
        map.from(semaphoreConfig.isInterruptible()).to(arg_0 -> ((SemaphoreValve)valve).setInterruptible(arg_0));
        this.host.getPipeline().addValve((Valve)valve);
    }

    private void customizeErrorReportValve(TongWebProperties tongWebProperties) {
        block9: {
            boolean jsonErrorReportValveEnabled = tongWebProperties.getTongweb().getJsonErrorReportValve().isEnabled();
            if (jsonErrorReportValveEnabled) {
                String errorValveClassName = "com.tongweb.container.valves.JsonErrorReportValve";
                JsonErrorReportValve valve = new JsonErrorReportValve();
                StandardHost host = (StandardHost)this.tongweb.getHost();
                host.setErrorReportValveClass(errorValveClassName);
                host.getPipeline().addValve((Valve)valve);
            } else if (tongWebProperties.getTongweb().getErrorReportValve().isEnabled()) {
                boolean errorReportValveShowReport = tongWebProperties.getTongweb().getErrorReportValve().isShowReport();
                boolean errorReportValveShowServerInfo = tongWebProperties.getTongweb().getErrorReportValve().isShowServerInfo();
                this.generateErrorReportValve(errorReportValveShowReport, errorReportValveShowServerInfo);
            } else if (!StringUtils.isEmpty(tongWebProperties.getTongweb().getCustomizedErrorReportValve().getType())) {
                String customizedErrorValveType = tongWebProperties.getTongweb().getCustomizedErrorReportValve().getType();
                try {
                    Object customizedErrorValveObj = Class.forName(customizedErrorValveType).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (customizedErrorValveObj instanceof ErrorReportValve) {
                        ErrorReportValve customizedErrorValve = (ErrorReportValve)customizedErrorValveObj;
                        StandardHost host = (StandardHost)this.tongweb.getHost();
                        host.getPipeline().addValve((Valve)customizedErrorValve);
                        break block9;
                    }
                    log.warn((Object)("customize valve class " + customizedErrorValveType + " is invalid , customized errorValve failed."));
                }
                catch (Throwable e) {
                    log.warn((Object)("class " + customizedErrorValveType + " not exist. customized errorValve failed."), e);
                }
            } else {
                this.generateErrorReportValve(true, false);
            }
        }
    }

    private void generateErrorReportValve(boolean showReport, boolean showServerInfo) {
        ErrorReportValve valve = new ErrorReportValve();
        valve.setShowReport(showReport);
        valve.setShowServerInfo(showServerInfo);
        StandardHost host = (StandardHost)this.tongweb.getHost();
        host.setErrorReportValveClass(valve.getClass().getCanonicalName());
        host.getPipeline().addValve((Valve)valve);
    }
}

