/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.commons.license.LicenseSDKProvider;
import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import com.tongweb.container.Engine;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.ConnectorConfigHandler;
import com.tongweb.starter.utils.CheckIntegrityUtil;
import com.tongweb.starter.utils.PropertyMapper;

public class LicenseConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(LicenseConfigHandler.class);
    private ServletContainer tongweb;

    public LicenseConfigHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        PropertyMapper map = PropertyMapper.get();
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb License Config Start.");
        }
        new CheckIntegrityUtil();
        String validType = tongWebProperties.getTongweb().getLicense().getType();
        String productVersion = "esRTevlz6wm/tpN/Cbl4CfU7xtHDelNBw/kd4O9uSO0=";
        String licensePath = tongWebProperties.getTongweb().getLicense().getPath();
        String tongwebEdition = "Embed";
        if (validType.equals("remote")) {
            map.from(tongWebProperties.getTongweb().getLicense().getLicenseIps()).whenHasText().to(this::putLicenseIps);
            map.from(tongWebProperties.getTongweb().getLicense().getLicensePublicKey()).whenHasText().to(this::putPublicKey);
            this.putProductKey(productVersion);
            this.putTongwebEdition(tongwebEdition);
            if (tongWebProperties.getTongweb().getLicense().getSsl() != null) {
                map.from(tongWebProperties.getTongweb().getLicense().isSslEnabled()).whenNonNull().to(this::pusSslEnabled);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStore()).whenHasText().to(this::putKeyStore);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStorePassword()).whenHasText().to(this::putKeyStorePassword);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStoreType()).whenHasText().to(this::putKeyStoreType);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStore()).whenHasText().to(this::putTrustStore);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStorePassword()).whenHasText().to(this::putTrustStorePassword);
                map.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStoreType()).whenHasText().to(this::putTrustStoreType);
            }
            LicenseSDKProvider.validate();
        } else {
            LicenseProviderFacade.config((LicenseConfig)LicenseProviderFacade.genConfig((String)productVersion, (String)licensePath, (String)tongwebEdition, (String)"TongWeb"));
            LicenseProviderFacade.validate();
            LicenseProviderFacade.startWorker();
        }
        Engine engine = this.tongweb.getEngine();
        engine.addLifecycleListener(event -> {
            if ("before_stop".equals(event.getType())) {
                LicenseProviderFacade.exit();
            }
        });
        map.from(tongWebProperties.getTongweb().getMaxThreads()).when(this::isPositive).to(ConnectorConfigHandler::customizeMaxThreads);
        map.from(tongWebProperties.getTongweb().getMinSpareThreads()).when(this::isPositive).to(ConnectorConfigHandler::customizeMinThreads);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb License Config End.");
        }
    }

    private void putLicenseIps(String value) {
        System.setProperty("server.tongweb.license.license-ips", value);
    }

    private void putPublicKey(String value) {
        System.setProperty("server.tongweb.license.publicKey", value);
    }

    private void putProductKey(String value) {
        System.setProperty("server.tongweb.license.productKey", value);
    }

    private void putTongwebEdition(String value) {
        System.setProperty("server.tongweb.license.tongWebEdition", value);
    }

    private void pusSslEnabled(boolean value) {
        System.setProperty("server.tongweb.license.ssl.enabled", String.valueOf(value));
    }

    private void putKeyStore(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStore", value);
    }

    private void putKeyStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStorePassword", value);
    }

    private void putKeyStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStoreType", value);
    }

    private void putTrustStore(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStore", value);
    }

    private void putTrustStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStorePassword", value);
    }

    private void putTrustStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStoreType", value);
    }
}

