/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.commons.license.DynamicLoadingListener;
import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http11.Http11Nio2Protocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.bean.TongwebConfig;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.utils.DataSize;
import com.tongweb.starter.utils.PropertyMapper;
import com.tongweb.starter.utils.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ProtocolConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(ProtocolConfigHandler.class);
    private ServletContainer tongweb;
    private static final String DEFAULT_LOCAL_ADDRESS = "0.0.0.0";

    public ProtocolConfigHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Protocol Config Start.");
        }
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(tongWebProperties).whenNonNull().to(this::customizeAddress);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeIoMode);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxThreads);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMinThreads);
        propertyMapper.from(tongWebProperties.getMaxHttpHeaderSize()).as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(this::customizeHttpHeaderSize);
        propertyMapper.from(tongWebProperties.getTongweb().getMaxSavePostSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(this::customizeMaxSavePostSize);
        propertyMapper.from(tongWebProperties.getTongweb().getMaxSwallowSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).to(this::customizeMaxSwallowSize);
        propertyMapper.from(tongWebProperties.getTongweb().getConnectionTimeout()).whenNonNull().to(this::customizeConnectionTimeout);
        propertyMapper.from(tongWebProperties.getTongweb().getConnectionLinger()).whenNonNull().to(this::customizeConnectionLinger);
        propertyMapper.from(tongWebProperties.getTongweb().getConnectionUploadTimeout()).whenNonNull().to(this::customizeConnectionUploadTimeout);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeDisableUploadTimeout);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxConnections);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxHeaderCount);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeAcceptCount);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeProcessorCache);
        propertyMapper.from(tongWebProperties.getTongweb().getKeepAliveTimeout()).whenNonNull().to(this::customizeKeepAliveTimeout);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxKeepAliveRequests);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxExtensionSize);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeMaxTrailerSize);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeRejectIllegalHeader);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeRestrictedUserAgents);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeTcpNoDelay);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeUseKeepAliveResponseHeader);
        propertyMapper.from(tongWebProperties.getTongweb().getSelectorTimeout()).whenNonNull().to(this::customizeSelectorTimeout);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeUseSendFile);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Protocol Config End.");
        }
    }

    @Override
    public boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeAddress(TongWebProperties tongWebProperties) {
        AbstractProtocol protocol = (AbstractProtocol)this.tongweb.getConnector().getProtocolHandler();
        try {
            if (StringUtils.isEmpty(tongWebProperties.getAddress())) {
                protocol.setAddress(InetAddress.getByName(DEFAULT_LOCAL_ADDRESS));
            } else {
                protocol.setAddress(InetAddress.getByName(tongWebProperties.getAddress()));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private void customizeIoMode(TongwebConfig tongwebConfig) {
    }

    private void customizeMaxThreads(TongwebConfig tongwebConfig) {
        final int maxThreads = tongwebConfig.getMaxThreads();
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            final AbstractProtocol protocol = (AbstractProtocol)handler;
            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)maxThreads);
            protocol.setMaxThreads(targetThread);
            LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                public String getListenerKey() {
                    return "MaxThreads";
                }

                public void exec() {
                    if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                        protocol.setMaxThreads(5);
                    } else {
                        int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)maxThreads);
                        protocol.setMaxThreads(targetThread);
                    }
                }
            });
        }
    }

    private void customizeMinThreads(TongwebConfig tongwebConfig) {
        final int minSpareThreads = tongwebConfig.getMinSpareThreads();
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            final AbstractProtocol protocol = (AbstractProtocol)handler;
            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)minSpareThreads);
            protocol.setMinSpareThreads(targetThread);
            LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                public String getListenerKey() {
                    return "MinSpareThreads";
                }

                public void exec() {
                    if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                        protocol.setMinSpareThreads(5);
                    } else {
                        int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)minSpareThreads);
                        protocol.setMinSpareThreads(targetThread);
                    }
                }
            });
        }
    }

    private void customizeHttpHeaderSize(int maxHttpHeaderSize) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
        }
    }

    private void customizeMaxSavePostSize(int maxSavePostSize) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxSavePostSize(maxSavePostSize);
        }
    }

    private void customizeMaxSwallowSize(int maxSwallowSize) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxSwallowSize(maxSwallowSize);
        }
    }

    private void customizeConnectionTimeout(Long connectionTimeout) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setConnectionTimeout(connectionTimeout.intValue());
        }
    }

    private void customizeConnectionLinger(Long connectionLinger) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setConnectionLinger(connectionLinger.intValue());
        }
    }

    private void customizeConnectionUploadTimeout(Long connectionUploadTimeout) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setConnectionUploadTimeout(connectionUploadTimeout.intValue());
        }
    }

    private void customizeDisableUploadTimeout(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setDisableUploadTimeout(tongwebConfig.getDisableUploadTimeout().booleanValue());
        }
    }

    private void customizeMaxConnections(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setMaxConnections(tongwebConfig.getMaxConnections());
        }
    }

    private void customizeMaxHeaderCount(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setMaxHeaderCount(tongwebConfig.getMaxHeaderCount().intValue());
        }
    }

    private void customizeAcceptCount(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setAcceptCount(tongwebConfig.getAcceptCount());
        }
    }

    private void customizeProcessorCache(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            ((AbstractProtocol)handler).setProcessorCache(tongwebConfig.getProcessorCache());
        }
    }

    private void customizeKeepAliveTimeout(Long keepAliveTimeout) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setKeepAliveTimeout(keepAliveTimeout.intValue());
        }
    }

    private void customizeMaxKeepAliveRequests(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxKeepAliveRequests(tongwebConfig.getMaxKeepAliveRequests());
        }
    }

    private void customizeMaxExtensionSize(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxExtensionSize(tongwebConfig.getMaxExtensionSize().intValue());
        }
    }

    private void customizeMaxTrailerSize(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxTrailerSize(tongwebConfig.getMaxTrailerSize());
        }
    }

    private void customizeRejectIllegalHeader(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setRejectIllegalHeader(tongwebConfig.getRejectIllegalHeader().booleanValue());
        }
    }

    private void customizeRestrictedUserAgents(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setRestrictedUserAgents(tongwebConfig.getRestrictedUserAgents());
        }
    }

    private void customizeTcpNoDelay(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setTcpNoDelay(tongwebConfig.getTcpNoDelay().booleanValue());
        }
    }

    private void customizeUseKeepAliveResponseHeader(TongwebConfig tongwebConfig) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
            protocol.setUseKeepAliveResponseHeader(tongwebConfig.getUseKeepAliveResponseHeader().booleanValue());
        }
    }

    private void customizeSelectorTimeout(Long selectorTimeout) {
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        if (handler instanceof Http11NioProtocol) {
            Http11NioProtocol protocol = (Http11NioProtocol)handler;
            protocol.setSelectorTimeout(selectorTimeout.longValue());
        }
    }

    private void customizeUseSendFile(TongwebConfig tongwebConfig) {
        Http11NioProtocol protocol;
        ProtocolHandler handler = this.tongweb.getConnector().getProtocolHandler();
        Boolean useSendFile = tongwebConfig.getUseSendFile();
        if (handler instanceof Http11NioProtocol) {
            protocol = (Http11NioProtocol)handler;
            protocol.setUseSendfile(useSendFile.booleanValue());
        }
        if (handler instanceof Http2Protocol) {
            protocol = (Http2Protocol)handler;
            protocol.setUseSendfile(useSendFile.booleanValue());
        }
        if (handler instanceof Http11Nio2Protocol) {
            protocol = (Http11Nio2Protocol)handler;
            protocol.setUseSendfile(useSendFile.booleanValue());
        }
    }
}

