/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.service;

import com.tongweb.container.LifecycleException;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.parse.ConfigProcessor;
import com.tongweb.starter.service.TongWebStarter;
import java.io.IOException;

public class StandardTongWebStarer
implements TongWebStarter {
    private static final Log log = LogFactory.getLog(StandardTongWebStarer.class);
    private ConfigProcessor processor;
    private ServletContainer tongweb;
    private boolean alreadyConfig = false;

    public StandardTongWebStarer() {
        this.init();
    }

    public void setConfigFileName(String fileName) {
        this.processor.setFileName(fileName);
    }

    public void config() {
        this.configInternal();
    }

    public void start() {
        if (!this.alreadyConfig) {
            this.configInternal();
        }
        this.checkLicense();
        this.startInternal();
    }

    private void init() {
        this.tongweb = new ServletContainer();
        this.processor = new ConfigProcessor(this.tongweb);
    }

    private void configInternal() {
        try {
            this.processor.processConfig();
            this.processor.configComponents();
            this.processor.addShutdownListener();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alreadyConfig = true;
    }

    private void checkLicense() {
    }

    private void startInternal() {
        try {
            this.tongweb.start();
            this.tongweb.getServer().await();
        }
        catch (LifecycleException e) {
            log.error((Object)"start tongweb failed", (Throwable)e);
        }
    }

    public ServletContainer getTongweb() {
        return this.tongweb;
    }
}

