/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.conf;

import com.tongtech.tlq.admin.conf.Attribute;
import com.tongtech.tlq.admin.conf.CheckPublic;
import com.tongtech.tlq.admin.conf.Property;
import com.tongtech.tlq.admin.conf.TlqConfException;
import java.io.Serializable;

public class Program
implements Serializable {
    private Attribute prgID;
    private Attribute prgName;
    private Attribute prgDesc;
    private Attribute prgType;
    private Attribute startType;
    private Attribute prgPara;
    private Attribute prgRunPara;
    private Attribute initNum;
    private Attribute maxNum;
    private CheckPublic checkPublic = new CheckPublic();

    public Program() {
        int n = 42;
        this.prgID = new Attribute(Property.strSysFldMsg[n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.prgName = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.prgDesc = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.prgType = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.startType = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.prgPara = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.prgRunPara = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.initNum = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
        this.maxNum = new Attribute(Property.strSysFldMsg[++n][0], Property.strSysFldMsg[n][1], Property.strSysFldMsg[n][2], Property.strSysFldMsg[n][3], Property.strSysFldMsg[n][4]);
    }

    public Program(int n) {
        this();
        this.prgID.setValue(String.valueOf(n));
    }

    public String toString() {
        return "Program";
    }

    public void setPrgID(int n) throws TlqConfException {
        if (n < 100 || n > 9999) {
            throw new TlqConfException("prgID: " + n + " is not in(100..9999)!");
        }
        this.prgID.setValue(String.valueOf(n));
    }

    public void setPrgName(String string) throws TlqConfException {
        this.prgName.setValue(string);
    }

    public void setPrgDesc(String string) throws TlqConfException {
        if (string.length() > 32) {
            throw new TlqConfException("prgDesc: " + string + " length must be <=  32 !");
        }
        this.prgDesc.setValue(string);
    }

    public void setPrgType(String string) throws TlqConfException {
        if (!("N".equals(string) || "P".equals(string) || "T".equals(string) || "S".equals(string))) {
            throw new TlqConfException("prgTypeStr:" + string + " is not legal!");
        }
        this.prgType.setValue(string);
    }

    public void setStartType(int n) throws TlqConfException {
        if (n == 0) {
            this.startType.setValue(String.valueOf(n));
            return;
        }
        if (n == 1) {
            this.startType.setValue(String.valueOf(n));
            return;
        }
        throw new TlqConfException("startType: " + " is not in(0/1)!");
    }

    public void setPrgPara(String string) throws TlqConfException {
        if (string.length() > 256) {
            throw new TlqConfException("prgPara: " + string + " length must be <= 256 !");
        }
        this.prgPara.setValue(string);
    }

    public void setInitNum(int n) throws TlqConfException {
        if (!this.checkPublic.NumberCheck(n)) {
            throw new TlqConfException("initNum: " + n + " can't be negative!");
        }
        this.initNum.setValue(String.valueOf(n));
    }

    public Attribute getPrgID() {
        return this.prgID;
    }

    public Attribute getPrgName() {
        return this.prgName;
    }

    public Attribute getPrgDesc() {
        return this.prgDesc;
    }

    public Attribute getPrgType() {
        return this.prgType;
    }

    public Attribute getStartType() {
        return this.startType;
    }

    public Attribute getPrgPara() {
        return this.prgPara;
    }

    public Attribute getInitNum() {
        return this.initNum;
    }

    protected void setReadPrgType(String string) throws TlqConfException {
        if (string.equals("Normal")) {
            this.prgType.setValue("N");
        } else if (string.equals("Period")) {
            this.prgType.setValue("P");
        } else if (string.equals("Time")) {
            this.prgType.setValue("T");
        } else if (string.equals("Start")) {
            this.prgType.setValue("S");
        } else {
            throw new TlqConfException("PrgType: " + string + " is not legal!");
        }
    }

    protected Attribute getWritePrgType() {
        Attribute attribute = (Attribute)this.prgType.clone();
        if (this.prgType.getValue().equals("N")) {
            attribute.setValue("Normal");
        } else if (this.prgType.getValue().equals("P")) {
            attribute.setValue("Period");
        } else if (this.prgType.getValue().equals("T")) {
            attribute.setValue("Time");
        } else if (this.prgType.getValue().equals("S")) {
            attribute.setValue("Start");
        }
        return attribute;
    }

    public void check() throws TlqConfException {
        block6: {
            if (!this.getPrgType().getValue().equals("N") && !this.checkPublic.programNameCheck(this.prgName.getValue())) {
                throw new TlqConfException("prgName: " + this.prgName.getValue() + " is not legal!");
            }
            if (this.getPrgType().getValue().equals("P")) {
                try {
                    int n = Integer.parseInt(this.getPrgPara().getValue());
                    if (n < 0) {
                        throw new TlqConfException("PrgPara: " + this.getPrgPara().getValue() + " is not legal!" + "when PrgType is " + this.getPrgType().getValue() + "PrgId=" + this.getPrgID().getValue());
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TlqConfException("PrgPara: " + this.getPrgPara().getValue() + " is not legal!" + "when PrgType is " + this.getPrgType().getValue() + "PrgId=" + this.getPrgID().getValue());
                }
            }
            if (this.getPrgType().getValue().equals("T")) {
                this.checkPublic.WildCharTimeCheck(this.getPrgPara().getValue());
            }
        }
    }

    public Attribute getMaxNum() {
        return this.maxNum;
    }

    public void setMaxNum(int n) throws TlqConfException {
        if (!this.checkPublic.NumberCheck(n)) {
            throw new TlqConfException("maxNum: " + n + " can't be negative!");
        }
        this.maxNum.setValue(String.valueOf(n));
    }

    public Attribute getPrgRunPara() {
        return this.prgRunPara;
    }

    public void setPrgRunPara(String string) throws TlqConfException {
        if (string.length() > 256) {
            throw new TlqConfException("prgRunPara: " + string + " length must be <= 256 !");
        }
        this.prgRunPara.setValue(string);
    }
}

