/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.conf;

import com.tongtech.tlq.admin.conf.Attribute;
import com.tongtech.tlq.admin.conf.CheckPublic;
import com.tongtech.tlq.admin.conf.Property;
import com.tongtech.tlq.admin.conf.TlqConfException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class RcvProcess
implements Serializable {
    private Attribute rcvProcID;
    private Attribute rcvProcStatus;
    private Attribute listenPort;
    private Attribute localAddr;
    private Attribute secExitFlag;
    private Attribute secExitNetData;
    private Attribute secExitTransportData;
    private Attribute sSLFlag;
    private Attribute sSLVersion;
    private Attribute sSLNegoFlag;
    private Attribute sessionTimeout;
    private Attribute sSLCiphe;
    private Attribute protocol;
    private CheckPublic checkPublic = new CheckPublic();

    public RcvProcess() {
        int n = 0;
        this.rcvProcID = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 1;
        this.rcvProcStatus = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 2;
        this.listenPort = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 3;
        this.localAddr = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 4;
        this.secExitFlag = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 5;
        this.secExitNetData = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 6;
        this.secExitTransportData = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 7;
        this.sSLFlag = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 8;
        this.sSLVersion = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 9;
        this.sSLNegoFlag = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 10;
        this.sessionTimeout = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 11;
        this.sSLCiphe = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
        n = 12;
        this.protocol = new Attribute(Property.strRcvProcessMsg[n][0], Property.strRcvProcessMsg[n][1], Property.strRcvProcessMsg[n][2], Property.strRcvProcessMsg[n][3], Property.strRcvProcessMsg[n][4]);
    }

    public RcvProcess(int n) {
        this();
        this.rcvProcID.setValue(String.valueOf(n));
    }

    public void setRcvProcID(int n) throws NumberFormatException, TlqConfException {
        if (!this.checkPublic.NumberCheck(n)) {
            throw new TlqConfException("rcvProcID: " + n + " can't be negative!");
        }
        this.rcvProcID.setValue(String.valueOf(n));
    }

    public void setRcvProcStatus(int n) throws TlqConfException {
        if (n == 0) {
            this.rcvProcStatus.setValue(String.valueOf(n));
            return;
        }
        if (n == 1) {
            this.rcvProcStatus.setValue(String.valueOf(n));
            return;
        }
        throw new TlqConfException("rcvProcStatus: " + n + " is not in(0/1)!");
    }

    public void setListenPort(int n) throws TlqConfException {
        if (n < 1024 || n > 65535) {
            throw new TlqConfException("listenPort: " + n + " is not in(1024..65535)!");
        }
        this.listenPort.setValue(String.valueOf(n));
    }

    public void setLocalAddr(String string) {
        this.localAddr.setValue(string);
    }

    public void setSecExitFlag(String string) throws TlqConfException {
        if (string == null || string.length() == 0) {
            this.secExitFlag.setValue(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("Transport")) {
                if (!bl) {
                    bl = true;
                    continue;
                }
                throw new TlqConfException("Transport:  has existed!");
            }
            if (string2.equals("Net")) {
                if (!bl2) {
                    bl2 = true;
                    continue;
                }
                throw new TlqConfException("Net:  has existed!");
            }
            if (string2.equals("ByRecv")) {
                if (!bl3) {
                    bl3 = true;
                    continue;
                }
                throw new TlqConfException("ByRecv:  has existed!");
            }
            throw new TlqConfException("secExitFlag: " + string + " is not legal!");
        }
        this.secExitFlag.setValue(string);
    }

    public void setSecExitNetData(String string) throws TlqConfException {
        if (string != null && (string.length() < 0 || string.length() > 48)) {
            throw new TlqConfException("secExitNetData: " + string + " is not in(0..48 byte)");
        }
        this.secExitNetData.setValue(string);
    }

    public void setSecExitTransportData(String string) throws TlqConfException {
        if (string != null && (string.length() < 0 || string.length() > 48)) {
            throw new TlqConfException("secExitTransportData: " + string + " is not in(0..48 byte)");
        }
        this.secExitTransportData.setValue(string);
    }

    public void setSSLFlag(int n) throws TlqConfException {
        this.sSLFlag.setValue(String.valueOf(n));
    }

    public void setSSLVersion(int n) throws TlqConfException {
        this.sSLVersion.setValue(String.valueOf(n));
    }

    public void setSSLNegoFlag(int n) throws TlqConfException {
        this.sSLNegoFlag.setValue(String.valueOf(n));
    }

    public void setSessionTimeout(int n) throws TlqConfException {
        this.sessionTimeout.setValue(String.valueOf(n));
    }

    public void setSSLCiphe(String string) throws TlqConfException {
        this.sSLCiphe.setValue(string);
    }

    public void setProtocol(int n) throws TlqConfException {
        if (!this.checkPublic.switchCheck(n)) {
            throw new TlqConfException("protocol: " + n + " is not in(0/1)!");
        }
        this.protocol.setValue(String.valueOf(n));
    }

    public Attribute getRcvProcID() {
        return this.rcvProcID;
    }

    public Attribute getRcvProcStatus() {
        return this.rcvProcStatus;
    }

    public Attribute getListenPort() {
        return this.listenPort;
    }

    public Attribute getLocalAddr() {
        return this.localAddr;
    }

    public Attribute getSecExitFlag() {
        return this.secExitFlag;
    }

    public Attribute getSecExitNetData() {
        return this.secExitNetData;
    }

    public Attribute getSecExitTransportData() {
        return this.secExitTransportData;
    }

    public Attribute getSSLFlag() {
        return this.sSLFlag;
    }

    public Attribute getsSLVersion() {
        return this.sSLVersion;
    }

    public Attribute getSSLNegoFlag() {
        return this.sSLNegoFlag;
    }

    public Attribute getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Attribute getSSLCiphe() {
        return this.sSLCiphe;
    }

    public Attribute getProtocol() {
        return this.protocol;
    }
}

