/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.conf;

import com.tongtech.tlq.admin.conf.Attribute;
import com.tongtech.tlq.admin.conf.CheckPublic;
import com.tongtech.tlq.admin.conf.JndiBroker;
import com.tongtech.tlq.admin.conf.NodeSystemInfo;
import com.tongtech.tlq.admin.conf.Program;
import com.tongtech.tlq.admin.conf.Property;
import com.tongtech.tlq.admin.conf.QCU;
import com.tongtech.tlq.admin.conf.QueModel;
import com.tongtech.tlq.admin.conf.SuperviseBroker;
import com.tongtech.tlq.admin.conf.TLQ_QcuConf;
import com.tongtech.tlq.admin.conf.TlqConfException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;

public class TLQ_SysConf {
    private static final String SYSFILE_NAME = "tlsys.conf";
    protected static final String TLQCONF_ENV_PATHNAME = "TONGCONFDIR";
    private String SYSFILE_PATH = "";
    public static String TLQ_WEBMNGDIR;
    private SuperviseBroker tempSuperviseBroker = new SuperviseBroker();
    private NodeSystemInfo tempSystem = new NodeSystemInfo();
    private QCU tempQcu = new QCU();
    private Program tempProgram = new Program();
    private QueModel tempQueModel = new QueModel();
    private JndiBroker tempJndiBroker = new JndiBroker();
    public TreeMap systemTreeMap = new TreeMap();
    public TreeMap spvBrkTreeMap = new TreeMap();
    public TreeMap qcuTreeMap = new TreeMap();
    public TreeMap programTreeMap = new TreeMap();
    public TreeMap queModelTreeMap = new TreeMap();
    public TreeMap jndiBrokerTreeMap = new TreeMap();
    private CheckPublic checkPublic = new CheckPublic();
    private String CFGFILENAME = "";
    private int editObjectNum = 0;
    private int is = -1;
    private int intIsDef = 0;
    public Properties pros = new Properties();
    public InputStream in;

    public TLQ_SysConf(String string, Locale locale) throws TlqConfException {
        try {
            if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
                this.in = this.getClass().getResourceAsStream("Tlq_TransConfig.properties");
            }
            if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh")) {
                this.in = this.getClass().getResourceAsStream("/ApplicationResources_zh.properties");
            }
            this.pros.load(this.in);
            this.in.close();
        }
        catch (Exception exception) {
            System.out.println("Open Properties file error!");
        }
        if (string == null || string.length() == 0) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.systempath_empty"));
        }
        if (!string.endsWith("\\") && !string.endsWith("/")) {
            string = string + "\\";
        }
        this.SYSFILE_PATH = string;
        this.CFGFILENAME = string + SYSFILE_NAME;
        this.readConf();
    }

    public TLQ_SysConf(Locale locale) throws TlqConfException {
        try {
            if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
                this.in = this.getClass().getResourceAsStream("Tlq_TransConfig.properties");
            }
            if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh")) {
                this.in = this.getClass().getResourceAsStream("Tlq_TransConfig_zh.properties");
            }
            this.pros.load(this.in);
            this.in.close();
        }
        catch (Exception exception) {
            System.out.println("Open Properties file error!");
        }
        String string = this.pros.getProperty("exception.tlq.conf.system.programmaxnum_error");
        String string2 = System.getProperty(TLQCONF_ENV_PATHNAME);
        if (string2 == null || string2.length() == 0) {
            string2 = this.getClass().getResource("/").getPath();
        }
        this.SYSFILE_PATH = string2;
        this.CFGFILENAME = string2 + SYSFILE_NAME;
        this.readConf();
    }

    private void check() throws TlqConfException {
        NodeSystemInfo nodeSystemInfo = (NodeSystemInfo)this.systemTreeMap.get("system");
        String string = nodeSystemInfo.getNodeName().getValue();
        if (!this.checkPublic.nameCheck(string)) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.sys_nodename") + string + " is not legal!");
        }
        try {
            int n = Integer.parseInt(nodeSystemInfo.getProgramMaxNum().getValue());
            if (n < this.programTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("prn_left") + this.programTreeMap.size() + this.pros.getProperty("prn_mid") + n + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.programmaxnum_error"));
        }
        Iterator iterator = this.programTreeMap.values().iterator();
        while (iterator.hasNext()) {
            Program program = (Program)iterator.next();
            program.check();
        }
        try {
            int n = Integer.parseInt(nodeSystemInfo.getQueModelMaxNum().getValue());
            if (n < this.queModelTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelrn_left") + this.queModelTreeMap.size() + this.pros.getProperty("exception.tlq.conf.system.quemodelrn_mid") + n + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelmaxnum_error"));
        }
    }

    private void readConf() throws TlqConfException {
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(this.CFGFILENAME);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + this.pros.getProperty("exception.tlq.conf.system.nullpointerexception"));
        }
        if (!file.exists()) {
            this.systemTreeMap.put("system", this.tempSystem);
            this.writeToFile();
            return;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + this.pros.getProperty("exception.tlq.conf.system.filenotfoundexception"));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string = "";
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                this.GetValuesFromLinkCfg(string, hashSet, hashSet2, hashSet3);
            }
            fileInputStream.close();
            bufferedReader.close();
        }
        catch (TlqConfException tlqConfException) {
            tlqConfException.printStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + this.pros.getProperty("exception.tlq.conf.system.tlqconfexception"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + this.pros.getProperty("exception.tlq.conf.system.ioexception"));
        }
        this.check();
    }

    private boolean GetValuesFromLinkCfg(String string, HashSet hashSet, HashSet hashSet2, HashSet hashSet3) throws TlqConfException {
        try {
            if (string.charAt(0) == '[') {
                if (this.setSec(string)) {
                    return true;
                }
                return this.setSubSec(string);
            }
            return this.setField(string, hashSet, hashSet2, hashSet3);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
        }
    }

    public void writeToFile() throws TlqConfException {
        File file = new File(this.CFGFILENAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createfile_error"));
            }
        }
        File file2 = new File(this.CFGFILENAME + ".temp");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createtempfile_error"));
        }
        if (file.exists()) {
            try {
                this.copyFile(this.CFGFILENAME, this.CFGFILENAME + ".temp");
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.copytotempfile_error"));
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.CFGFILENAME);
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createfileos_error"));
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createnewfile_error"));
        }
        try {
            Serializable serializable;
            Iterator iterator;
            int n;
            for (n = 0; n <= 5; ++n) {
                bufferedWriter.write(Property.strSysCmntMsg[n]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(Property.strSysSecMsg[0][0] + "\t\t" + Property.strSysSecMsg[0][1]);
            bufferedWriter.newLine();
            bufferedWriter.write(Property.strSysCmntMsg[6]);
            bufferedWriter.newLine();
            n = this.systemTreeMap.size();
            if (n > 0) {
                iterator = this.systemTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (NodeSystemInfo)iterator.next();
                    this.printSys((NodeSystemInfo)serializable, bufferedWriter);
                }
            }
            if ((n = this.spvBrkTreeMap.size()) > 0) {
                bufferedWriter.write(Property.strSysCmntMsg[18]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysCmntMsg[17]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysSecMsg[1][0] + "\t\t" + Property.strSysSecMsg[1][1]);
                bufferedWriter.newLine();
                iterator = this.spvBrkTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (SuperviseBroker)iterator.next();
                    this.printSpvBrk((SuperviseBroker)serializable, bufferedWriter);
                }
            }
            for (int i = 7; i <= 8; ++i) {
                bufferedWriter.write(Property.strSysCmntMsg[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(Property.strSysSecMsg[2][0] + "\t\t" + Property.strSysSecMsg[2][1]);
            bufferedWriter.newLine();
            n = this.qcuTreeMap.size();
            if (n > 0) {
                Iterator iterator2 = this.qcuTreeMap.values().iterator();
                while (iterator2.hasNext()) {
                    serializable = (QCU)iterator2.next();
                    this.printQCU((QCU)serializable, bufferedWriter);
                }
            }
            for (int i = 10; i <= 11; ++i) {
                bufferedWriter.write(Property.strSysCmntMsg[i]);
                bufferedWriter.newLine();
            }
            n = this.queModelTreeMap.size();
            if (n > 0) {
                bufferedWriter.write(Property.strSysSecMsg[3][0] + "\t\t" + Property.strSysSecMsg[3][1]);
                bufferedWriter.newLine();
                Iterator iterator3 = this.queModelTreeMap.values().iterator();
                while (iterator3.hasNext()) {
                    serializable = (QueModel)iterator3.next();
                    this.printQueModel((QueModel)serializable, bufferedWriter);
                }
            }
            if ((n = this.programTreeMap.size()) > 0) {
                bufferedWriter.write(Property.strSysCmntMsg[13]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysCmntMsg[14]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysSecMsg[4][0] + "\t\t" + Property.strSysSecMsg[4][1]);
                bufferedWriter.newLine();
                Iterator iterator4 = this.programTreeMap.values().iterator();
                while (iterator4.hasNext()) {
                    serializable = (Program)iterator4.next();
                    this.printProgram((Program)serializable, bufferedWriter);
                }
            }
            if ((n = this.jndiBrokerTreeMap.size()) > 0) {
                bufferedWriter.write(Property.strSysCmntMsg[13]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysCmntMsg[14]);
                bufferedWriter.newLine();
                bufferedWriter.write(Property.strSysSecMsg[4][0] + "\t\t" + Property.strSysSecMsg[4][1]);
                bufferedWriter.newLine();
                Iterator iterator5 = this.jndiBrokerTreeMap.values().iterator();
                while (iterator5.hasNext()) {
                    serializable = (Program)iterator5.next();
                    this.printProgram((Program)serializable, bufferedWriter);
                }
            }
            bufferedWriter.write(Property.strSysCmntMsg[16]);
            bufferedWriter.newLine();
            bufferedWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.getStackTrace();
            try {
                this.copyFile(this.CFGFILENAME + ".temp", this.CFGFILENAME);
            }
            catch (Exception exception2) {
                exception2.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.copytofile_error"));
            }
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.writefile_error"));
        }
    }

    private boolean setSec(String string) {
        String string2 = string;
        int n = Property.strSysSecMsg.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.regionMatches(0, Property.strSysSecMsg[i][0], 0, Property.strSysSecMsg[i][0].length())) continue;
            this.editObjectNum = i;
            switch (i) {
                case 0: {
                    this.is = -1;
                    return true;
                }
                case 1: {
                    this.is = -1;
                    return true;
                }
                case 2: {
                    this.is = 0;
                    return true;
                }
                case 3: {
                    this.is = 1;
                    return true;
                }
                case 4: {
                    this.is = 2;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean setSubSec(String string) {
        String string2 = string;
        int n = Property.strSysRcdMsg.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.regionMatches(0, Property.strSysRcdMsg[i][0], 0, Property.strSysRcdMsg[i][0].length())) continue;
            switch (i) {
                case 0: {
                    if (this.is == 0) {
                        this.tempQcu = new QCU();
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (this.is == 1) {
                        this.tempQueModel = new QueModel();
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (this.is == 2) {
                        this.tempProgram = new Program();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean setField(String string, HashSet hashSet, HashSet hashSet2, HashSet hashSet3) throws NumberFormatException, TlqConfException {
        int n = string.indexOf(61);
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2).trim();
        String string3 = string.substring(0, string.indexOf("=")).trim();
        if (this.editObjectNum == 0) {
            if (string3.equals("NodeName")) {
                this.tempSystem.setNodeName(string2);
                this.systemTreeMap.put("system", this.tempSystem);
                return true;
            }
            if (string3.equals("ProgramMaxNum")) {
                try {
                    this.tempSystem.setProgramMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("ProgramMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("InstanceMaxNum")) {
                try {
                    this.tempSystem.setInstanceMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("InstanceMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("QueModelMaxNum")) {
                try {
                    this.tempSystem.setQueModelMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("QueModelMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("ClusterDestMaxNum")) {
                try {
                    this.tempSystem.setClusterDestMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("ClusterDestMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("SendProcMaxNum")) {
                try {
                    this.tempSystem.setSendProcMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("SendProcMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("RecvProcMaxNum")) {
                try {
                    this.tempSystem.setRecvProcMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("RecvProcMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("CliBrkMaxNum")) {
                try {
                    this.tempSystem.setCliBrkMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("CliBrkMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("JmsBrkMaxNum")) {
                try {
                    this.tempSystem.setJmsBrkMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("JmsBrkMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("NetGroupMaxNum")) {
                try {
                    this.tempSystem.setNetGroupMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("NetGroupMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("NetTransMaxNum")) {
                try {
                    this.tempSystem.setNetTransMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("NetTransMaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("BlockSize")) {
                try {
                    this.tempSystem.setBlockSize(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("BlockSize:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("DebugMode")) {
                try {
                    this.tempSystem.setDebugMode(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("DebugMode:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("DebugLevel")) {
                try {
                    this.tempSystem.setDebugLevel(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("DebugLevel:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("Retrycount")) {
                try {
                    this.tempSystem.setRetrycount(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("Retrycount:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("Retrytime")) {
                try {
                    this.tempSystem.setRetrytime(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("Retrytime:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("ReLoadThreadNum")) {
                try {
                    this.tempSystem.setReLoadThreadNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("ReLoadThreadNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("LogSize")) {
                try {
                    this.tempSystem.setLogSize(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("LogSize:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("LogFileNum")) {
                try {
                    this.tempSystem.setLogFileNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("LogFileNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("SecExitLibName")) {
                this.tempSystem.setSecExitLibName(string2);
                return true;
            }
            if (string3.equals("SecExitNetName")) {
                this.tempSystem.setSecExitNetName(string2);
                return true;
            }
            if (string3.equals("SecExitTransportName")) {
                this.tempSystem.setSecExitTransportName(string2);
                return true;
            }
            if (string3.equals("SecExitMessageName")) {
                this.tempSystem.setSecExitMessageName(string2);
                return true;
            }
            return false;
        }
        if (this.editObjectNum == 1) {
            if (string3.equals("ListenPort")) {
                try {
                    this.tempSuperviseBroker.setListenPort(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("ListenPort:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                this.spvBrkTreeMap.put("spvBroker", this.tempSuperviseBroker);
                return true;
            }
            if (string3.equals("Status")) {
                try {
                    this.tempSuperviseBroker.setStatus(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("Status:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
        }
        if (this.editObjectNum == 2 && this.qcuTreeMap != null) {
            if (this.tempQcu != null) {
                if (string3.equals("QCUName")) {
                    if (hashSet.contains(string2)) {
                        throw new TlqConfException("QCUName: " + string2 + this.pros.getProperty("exception.tlq.conf.system.existed"));
                    }
                    this.tempQcu.setQcuName(string2);
                    this.qcuTreeMap.put(string2, this.tempQcu);
                    hashSet.add(string2);
                    return true;
                }
                if (string3.equals("QCUStatus")) {
                    try {
                        this.tempQcu.setQcuStatus(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("QCUStatus:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.editObjectNum == 3 && this.queModelTreeMap != null) {
            if (this.tempQueModel != null) {
                if (string3.equals("QueModelName")) {
                    if (hashSet2.contains(string2)) {
                        throw new TlqConfException("QueModelName: " + string2 + this.pros.getProperty("exception.tlq.conf.system.existed"));
                    }
                    this.tempQueModel.setQueModelName(string2);
                    this.queModelTreeMap.put(string2, this.tempQueModel);
                    hashSet2.add(string2);
                    return true;
                }
                if (string3.equals("IsDef")) {
                    int n3;
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("IsDef:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    if (this.intIsDef == 0) {
                        if (n3 == 1) {
                            this.intIsDef = 1;
                        }
                        this.tempQueModel.setIsDef(n3);
                        return true;
                    }
                    if (n3 == 1) {
                        throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.defaultquemodel_error"));
                    }
                    this.tempQueModel.setIsDef(n3);
                    return true;
                }
                if (string3.equals("MsgNum")) {
                    try {
                        this.tempQueModel.setMsgNum(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("MsgNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("MsgSize")) {
                    try {
                        this.tempQueModel.setMsgSize(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("MsgSize:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("QueDataBuff")) {
                    try {
                        this.tempQueModel.setQueDataBuff(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("QueDataBuff:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("MsgArrangeMode")) {
                    try {
                        this.tempQueModel.setMsgArrangeMode(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("MsgArrangeMode:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("DefPriority")) {
                    try {
                        this.tempQueModel.setDefPriority(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("DefPriority:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("DefPersistence")) {
                    try {
                        this.tempQueModel.setDefPersistence(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("DefPersistence:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.editObjectNum == 4 && this.programTreeMap != null) {
            if (this.tempProgram != null) {
                if (string3.equals("PrgID")) {
                    if (hashSet3.contains(string2)) {
                        throw new TlqConfException("PrgID: " + string2 + this.pros.getProperty("exception.tlq.conf.system.existed"));
                    }
                    try {
                        this.tempProgram.setPrgID(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("PrgID:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    this.programTreeMap.put(string2, this.tempProgram);
                    hashSet3.add(string2);
                    return true;
                }
                if (string3.equals("PrgName")) {
                    this.tempProgram.setPrgName(string2);
                    return true;
                }
                if (string3.equals("PrgDesc")) {
                    this.tempProgram.setPrgDesc(string2);
                    return true;
                }
                if (string3.equals("PrgType")) {
                    this.tempProgram.setReadPrgType(string2);
                    return true;
                }
                if (string3.equals("StartType")) {
                    try {
                        this.tempProgram.setStartType(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("StartType:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("PrgPara")) {
                    this.tempProgram.setPrgPara(string2);
                    return true;
                }
                if (string3.equals("PrgRunPara")) {
                    this.tempProgram.setPrgRunPara(string2);
                    return true;
                }
                if (string3.equals("InitNum")) {
                    try {
                        this.tempProgram.setInitNum(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("InitNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
                if (string3.equals("MaxNum")) {
                    try {
                        this.tempProgram.setMaxNum(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        throw new TlqConfException("MaxNum:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.editObjectNum == 5 && this.jndiBrokerTreeMap != null && this.tempJndiBroker != null) {
            if (string3.equals("JndiBrokerStatus")) {
                try {
                    this.tempJndiBroker.setJndiBrokerStatus(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("JndiBrokerStatus:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("ListenPort")) {
                try {
                    this.tempJndiBroker.setListenPort(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new TlqConfException("ListenPort:" + this.pros.getProperty("exception.tlq.conf.system.numberformatexception"));
                }
                return true;
            }
            if (string3.equals("IP")) {
                this.tempJndiBroker.setIp(string2);
                return true;
            }
            return false;
        }
        return false;
    }

    private void printSys(NodeSystemInfo nodeSystemInfo, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        if (nodeSystemInfo.getNodeName().isPutOut() || nodeSystemInfo.getNodeName().modified()) {
            n = Property.getSysKeyIdx("NodeName");
            attribute = nodeSystemInfo.getNodeName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getProgramMaxNum().isPutOut() || nodeSystemInfo.getProgramMaxNum().modified()) {
            n = Property.getSysKeyIdx("ProgramMaxNum");
            attribute = nodeSystemInfo.getProgramMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getInstanceMaxNum().isPutOut() || nodeSystemInfo.getInstanceMaxNum().modified()) {
            n = Property.getSysKeyIdx("InstanceMaxNum");
            attribute = nodeSystemInfo.getInstanceMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getQueModelMaxNum().isPutOut() || nodeSystemInfo.getQueModelMaxNum().modified()) {
            n = Property.getSysKeyIdx("QueModelMaxNum");
            attribute = nodeSystemInfo.getQueModelMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getClusterDestMaxNum().isPutOut() || nodeSystemInfo.getClusterDestMaxNum().modified()) {
            n = Property.getSysKeyIdx("ClusterDestMaxNum");
            attribute = nodeSystemInfo.getClusterDestMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getSendProcMaxNum().isPutOut() || nodeSystemInfo.getSendProcMaxNum().modified()) {
            n = Property.getSysKeyIdx("SendProcMaxNum");
            attribute = nodeSystemInfo.getSendProcMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getRecvProcMaxNum().isPutOut() || nodeSystemInfo.getRecvProcMaxNum().modified()) {
            n = Property.getSysKeyIdx("RecvProcMaxNum");
            attribute = nodeSystemInfo.getRecvProcMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getCliBrkMaxNum().isPutOut() || nodeSystemInfo.getCliBrkMaxNum().modified()) {
            n = Property.getSysKeyIdx("CliBrkMaxNum");
            attribute = nodeSystemInfo.getCliBrkMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getJmsBrkMaxNum().isPutOut() || nodeSystemInfo.getJmsBrkMaxNum().modified()) {
            n = Property.getSysKeyIdx("JmsBrkMaxNum");
            attribute = nodeSystemInfo.getJmsBrkMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getNetGroupMaxNum().isPutOut() || nodeSystemInfo.getNetGroupMaxNum().modified()) {
            n = Property.getSysKeyIdx("NetGroupMaxNum");
            attribute = nodeSystemInfo.getNetGroupMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getNetTransMaxNum().isPutOut() || nodeSystemInfo.getNetTransMaxNum().modified()) {
            n = Property.getSysKeyIdx("NetTransMaxNum");
            attribute = nodeSystemInfo.getNetTransMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getBlockSize().isPutOut() || nodeSystemInfo.getBlockSize().modified()) {
            n = Property.getSysKeyIdx("BlockSize");
            attribute = nodeSystemInfo.getBlockSize();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getDebugMode().isPutOut() || nodeSystemInfo.getDebugMode().modified()) {
            n = Property.getSysKeyIdx("DebugMode");
            attribute = nodeSystemInfo.getDebugMode();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getDebugLevel().isPutOut() || nodeSystemInfo.getDebugLevel().modified()) {
            n = Property.getSysKeyIdx("DebugLevel");
            attribute = nodeSystemInfo.getDebugLevel();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getRetrycount().isPutOut() || nodeSystemInfo.getRetrycount().modified()) {
            n = Property.getSysKeyIdx("Retrycount");
            attribute = nodeSystemInfo.getRetrycount();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getRetrytime().isPutOut() || nodeSystemInfo.getRetrytime().modified()) {
            n = Property.getSysKeyIdx("Retrytime");
            attribute = nodeSystemInfo.getRetrytime();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getReLoadThreadNum().isPutOut() || nodeSystemInfo.getReLoadThreadNum().modified()) {
            n = Property.getSysKeyIdx("ReLoadThreadNum");
            attribute = nodeSystemInfo.getReLoadThreadNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getLogSize().isPutOut() || nodeSystemInfo.getLogSize().modified()) {
            n = Property.getSysKeyIdx("LogSize");
            attribute = nodeSystemInfo.getLogSize();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getLogFileNum().isPutOut() || nodeSystemInfo.getLogFileNum().modified()) {
            n = Property.getSysKeyIdx("LogFileNum");
            attribute = nodeSystemInfo.getLogFileNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getSecExitLibName().isPutOut() || nodeSystemInfo.getSecExitLibName().modified()) {
            n = Property.getSysKeyIdx("SecExitLibName");
            attribute = nodeSystemInfo.getSecExitLibName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getSecExitNetName().isPutOut() || nodeSystemInfo.getSecExitNetName().modified()) {
            n = Property.getSysKeyIdx("SecExitNetName");
            attribute = nodeSystemInfo.getSecExitNetName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getSecExitTransportName().isPutOut() || nodeSystemInfo.getSecExitTransportName().modified()) {
            n = Property.getSysKeyIdx("SecExitTransportName");
            attribute = nodeSystemInfo.getSecExitTransportName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (nodeSystemInfo.getSecExitMessageName().isPutOut() || nodeSystemInfo.getSecExitMessageName().modified()) {
            n = Property.getSysKeyIdx("SecExitMessageName");
            attribute = nodeSystemInfo.getSecExitMessageName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printSpvBrk(SuperviseBroker superviseBroker, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(Property.strSysCmntMsg[17]);
        bufferedWriter.newLine();
        if (superviseBroker.getListenPort().isPutOut() || superviseBroker.getListenPort().modified()) {
            n = Property.getSysKeyIdx("ListenPort");
            attribute = superviseBroker.getListenPort();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (superviseBroker.getStatus().isPutOut() || superviseBroker.getStatus().modified()) {
            n = Property.getSysKeyIdx("Status");
            attribute = superviseBroker.getStatus();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printQCU(QCU qCU, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(Property.strSysCmntMsg[9]);
        bufferedWriter.newLine();
        bufferedWriter.write(Property.strSysRcdMsg[0][0] + "\t\t" + Property.strSysRcdMsg[0][1]);
        bufferedWriter.newLine();
        if (qCU.getQcuName().isPutOut() || qCU.getQcuName().modified()) {
            n = Property.getSysKeyIdx("QCUName");
            attribute = qCU.getQcuName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (qCU.getQcuStatus().isPutOut() || qCU.getQcuStatus().modified()) {
            n = Property.getSysKeyIdx("QCUStatus");
            attribute = qCU.getQcuStatus();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printQueModel(QueModel queModel, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(Property.strSysCmntMsg[12]);
        bufferedWriter.newLine();
        bufferedWriter.write(Property.strSysRcdMsg[1][0] + "\t\t" + Property.strSysRcdMsg[1][1]);
        bufferedWriter.newLine();
        if (queModel.getQueModelName().isPutOut() || queModel.getQueModelName().modified()) {
            n = Property.getSysKeyIdx("QueModelName");
            attribute = queModel.getQueModelName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getIsDef().isPutOut() || queModel.getIsDef().modified()) {
            n = Property.getSysKeyIdx("IsDef");
            attribute = queModel.getIsDef();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getMsgNum().isPutOut() || queModel.getMsgNum().modified()) {
            n = Property.getSysKeyIdx("MsgNum");
            attribute = queModel.getMsgNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getMsgSize().isPutOut() || queModel.getMsgSize().modified()) {
            n = Property.getSysKeyIdx("MsgSize");
            attribute = queModel.getMsgSize();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getQueDataBuff().isPutOut() || queModel.getQueDataBuff().modified()) {
            n = Property.getSysKeyIdx("QueDataBuff");
            attribute = queModel.getQueDataBuff();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getMsgArrangeMode().isPutOut() || queModel.getMsgArrangeMode().modified()) {
            n = Property.getSysKeyIdx("MsgArrangeMode");
            attribute = queModel.getMsgArrangeMode();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getDefPriority().isPutOut() || queModel.getDefPriority().modified()) {
            n = Property.getSysKeyIdx("DefPriority");
            attribute = queModel.getDefPriority();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (queModel.getDefPersistence().isPutOut() || queModel.getDefPersistence().modified()) {
            n = Property.getSysKeyIdx("DefPersistence");
            attribute = queModel.getDefPersistence();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printProgram(Program program, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(Property.strSysCmntMsg[15]);
        bufferedWriter.newLine();
        bufferedWriter.write(Property.strSysRcdMsg[2][0] + "\t\t" + Property.strSysRcdMsg[2][1]);
        bufferedWriter.newLine();
        if (program.getPrgID().isPutOut() || program.getPrgID().modified()) {
            n = Property.getSysKeyIdx("PrgID");
            attribute = program.getPrgID();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getPrgName().isPutOut() || program.getPrgName().modified()) {
            n = Property.getSysKeyIdx("PrgName");
            attribute = program.getPrgName();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getPrgDesc().isPutOut() || program.getPrgDesc().modified()) {
            n = Property.getSysKeyIdx("PrgDesc");
            attribute = program.getPrgDesc();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getPrgType().isPutOut() || program.getPrgType().modified()) {
            n = Property.getSysKeyIdx("PrgType");
            attribute = program.getWritePrgType();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getStartType().isPutOut() || program.getStartType().modified()) {
            n = Property.getSysKeyIdx("StartType");
            attribute = program.getStartType();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getPrgPara().isPutOut() || program.getPrgPara().modified()) {
            n = Property.getSysKeyIdx("PrgPara");
            attribute = program.getPrgPara();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getPrgRunPara().isPutOut() || program.getPrgRunPara().modified()) {
            n = Property.getSysKeyIdx("PrgRunPara");
            attribute = program.getPrgRunPara();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getInitNum().isPutOut() || program.getInitNum().modified()) {
            n = Property.getSysKeyIdx("InitNum");
            attribute = program.getInitNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (program.getMaxNum().isPutOut() || program.getMaxNum().modified()) {
            n = Property.getSysKeyIdx("MaxNum");
            attribute = program.getMaxNum();
            bufferedWriter.write(Property.strSysFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + Property.strSysFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    public boolean addSuperviseBroker(SuperviseBroker superviseBroker) throws TlqConfException, Exception {
        if (superviseBroker == null) {
            throw new TlqConfException(" superviseBroker :argument is empty! ");
        }
        if (this.spvBrkTreeMap.containsKey("spvBroker")) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.spvbrokerexist_error"));
        }
        this.spvBrkTreeMap.put("spvBroker", superviseBroker);
        return true;
    }

    public boolean modifySuperviseBroker(SuperviseBroker superviseBroker) throws TlqConfException, Exception {
        if (superviseBroker == null) {
            throw new TlqConfException(" superviseBroker :argument is empty! ");
        }
        this.spvBrkTreeMap.put("spvBroker", superviseBroker);
        return true;
    }

    public boolean deleteSuperviseBroker() throws TlqConfException, Exception {
        if (!this.spvBrkTreeMap.containsKey("spvBroker")) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.spvbrokerconf_error"));
        }
        this.spvBrkTreeMap.remove("spvBroker");
        return true;
    }

    public boolean addJndiBroker(JndiBroker jndiBroker) throws TlqConfException, Exception {
        if (jndiBroker == null) {
            throw new TlqConfException(" jndiBroker :argument is empty! ");
        }
        if (this.jndiBrokerTreeMap.containsKey("jndiBroker")) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.spvbrokerexist_error"));
        }
        this.jndiBrokerTreeMap.put("jndiBroker", jndiBroker);
        return true;
    }

    public boolean modifyJndiBroker(JndiBroker jndiBroker) throws TlqConfException, Exception {
        if (jndiBroker == null) {
            throw new TlqConfException(" jndiBroker :argument is empty! ");
        }
        this.jndiBrokerTreeMap.put("jdniBroker", jndiBroker);
        return true;
    }

    public boolean deleteJndiBroker() throws TlqConfException, Exception {
        if (!this.jndiBrokerTreeMap.containsKey("jndiBroker")) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.spvbrokerconf_error"));
        }
        this.jndiBrokerTreeMap.remove("jndiBroker");
        return true;
    }

    public boolean addQcu(QCU qCU) throws TlqConfException, Exception {
        if (qCU == null) {
            throw new TlqConfException(" Qcu :argument is empty! ");
        }
        if (this.qcuTreeMap.containsKey(qCU.getQcuName().getValue())) {
            throw new TlqConfException(" QCUName: " + qCU.getQcuName().getValue() + this.pros.getProperty("exception.tlq.conf.system.existed"));
        }
        TLQ_QcuConf tLQ_QcuConf = new TLQ_QcuConf();
        tLQ_QcuConf.CFGFILENAME = this.SYSFILE_PATH + "tlqcu_" + qCU.getQcuName().getValue() + ".Conf";
        tLQ_QcuConf.basicTreeMap.put("basic", qCU);
        tLQ_QcuConf.writeToFile();
        this.qcuTreeMap.put(qCU.getQcuName().getValue(), qCU);
        return true;
    }

    public boolean modifySystem(NodeSystemInfo nodeSystemInfo) throws TlqConfException {
        if (nodeSystemInfo == null) {
            throw new TlqConfException(" system :argument is empty! ");
        }
        if (!this.checkPublic.nameCheck(nodeSystemInfo.getNodeName().getValue())) {
            throw new TlqConfException("nodeName: " + nodeSystemInfo.getNodeName().getValue() + " is not legal!");
        }
        try {
            int n = Integer.parseInt(nodeSystemInfo.getProgramMaxNum().getValue());
            int n2 = Integer.parseInt(nodeSystemInfo.getQueModelMaxNum().getValue());
            if (n < this.programTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("maxprogramnum_left") + n + this.pros.getProperty("maxprogramnum_mid") + this.programTreeMap.size() + "] ");
            }
            if (n2 < this.queModelTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("maxquemodelnum_left") + n2 + this.pros.getProperty("maxquemodelnum_mid") + this.queModelTreeMap.size() + "] ");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.sysnum_illegal"));
        }
        this.systemTreeMap.put("system", nodeSystemInfo);
        return true;
    }

    public boolean deleteQcu(String string) throws TlqConfException {
        if (this.qcuTreeMap.containsKey(string)) {
            String string2 = this.SYSFILE_PATH + "tlqcu_" + string + ".Conf";
            File file = new File(string2);
            if (!file.delete()) {
                throw new TlqConfException(this.pros.getProperty("deletequcfile") + string + this.pros.getProperty("unsuccessfully"));
            }
            file = new File(string2 + ".temp");
            if (!file.delete()) {
                throw new TlqConfException(this.pros.getProperty("deletequcfile") + string + ".temp" + this.pros.getProperty("unsuccessfully"));
            }
            this.qcuTreeMap.remove(string);
            return true;
        }
        throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.qcuname") + string + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    public boolean modifyQcu(QCU qCU) throws TlqConfException, Exception {
        if (qCU == null) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.qcu") + " :argument is empty! ");
        }
        if (!this.qcuTreeMap.containsKey(qCU.getQcuName().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.qcuname") + qCU.getQcuName().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        this.qcuTreeMap.put(qCU.getQcuName().getValue(), qCU);
        return true;
    }

    public boolean addQueModel(QueModel queModel) throws TlqConfException {
        if (queModel == null) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodel") + " :argument is empty! ");
        }
        if (this.queModelTreeMap.containsKey(queModel.getQueModelName().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelname") + queModel.getQueModelName().getValue() + this.pros.getProperty("exception.tlq.conf.system.existed"));
        }
        try {
            int n = Integer.parseInt(this.tempSystem.getQueModelMaxNum().getValue());
            if (n <= this.queModelTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelrn_left") + this.queModelTreeMap.size() + this.pros.getProperty("exception.tlq.conf.system.quemodel_mid") + n + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelmaxnum_illegal"));
        }
        if (Integer.parseInt(queModel.getIsDef().getValue()) == 1) {
            Iterator iterator = this.queModelTreeMap.values().iterator();
            while (iterator.hasNext()) {
                QueModel queModel2 = (QueModel)iterator.next();
                int n = Integer.parseInt(queModel2.getIsDef().getValue());
                if (n != 1) continue;
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.defaultquemodel_error"));
            }
        }
        this.queModelTreeMap.put(queModel.getQueModelName().getValue(), queModel);
        return true;
    }

    public boolean deleteQueModel(String string) throws TlqConfException {
        if (this.queModelTreeMap.containsKey(string)) {
            this.queModelTreeMap.remove(string);
            return true;
        }
        throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelname") + string + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    public boolean modifyQueModel(QueModel queModel) throws TlqConfException {
        if (queModel == null) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodel") + " :argument is empty! ");
        }
        if (!this.queModelTreeMap.containsKey(queModel.getQueModelName().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.quemodelname") + queModel.getQueModelName().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        if (Integer.parseInt(queModel.getIsDef().getValue()) == 1) {
            Iterator iterator = this.queModelTreeMap.values().iterator();
            while (iterator.hasNext()) {
                QueModel queModel2 = (QueModel)iterator.next();
                int n = Integer.parseInt(queModel2.getIsDef().getValue());
                if (n != 1 || queModel.getQueModelName().getValue().equals(queModel2.getQueModelName().getValue())) continue;
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.defaultquemodel_error"));
            }
        }
        this.queModelTreeMap.put(queModel.getQueModelName().getValue(), queModel);
        return true;
    }

    public boolean addProgram(Program program) throws TlqConfException {
        if (program == null) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.program") + " :argument is empty! ");
        }
        program.check();
        try {
            int n = Integer.parseInt(this.tempSystem.getProgramMaxNum().getValue());
            if (n <= this.programTreeMap.size()) {
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.programrn_left") + this.programTreeMap.size() + this.pros.getProperty("exception.tlq.conf.system.programrn_mid") + n + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.programmaxnum_error"));
        }
        if (this.programTreeMap.containsKey(program.getPrgID().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.prgid") + program.getPrgID().getValue() + this.pros.getProperty("exception.tlq.conf.system.existed"));
        }
        this.programTreeMap.put(program.getPrgID().getValue(), program);
        return true;
    }

    public boolean deleteProgram(int n) throws TlqConfException {
        if (this.programTreeMap.containsKey(String.valueOf(n))) {
            this.programTreeMap.remove(String.valueOf(n));
            return true;
        }
        throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.prgid") + n + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    public boolean modifyProgram(Program program) throws TlqConfException {
        if (program == null) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.program") + " :argument is empty! ");
        }
        program.check();
        if (!this.programTreeMap.containsKey(program.getPrgID().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.prgid") + program.getPrgID().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        this.programTreeMap.put(program.getPrgID().getValue(), program);
        return true;
    }

    private void copyFile(String string, String string2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string3 = "";
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string3);
            bufferedWriter.newLine();
        }
        fileInputStream.close();
        bufferedReader.close();
        bufferedWriter.close();
        fileOutputStream.close();
    }
}

