/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.conf.jndi;

import com.tongtech.tlq.admin.conf.Attribute;
import com.tongtech.tlq.admin.conf.CheckPublic;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.conf.jndi.Factory;
import com.tongtech.tlq.admin.conf.jndi.JndiProperty;
import com.tongtech.tlq.admin.conf.jndi.JndiQueue;
import com.tongtech.tlq.admin.conf.jndi.JndiSystem;
import com.tongtech.tlq.admin.conf.jndi.JndiTopic;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;

public class Tlq_JndiConf {
    private static final String TLQCONF_ENV_PATHNAME = "TONGCONFDIR";
    private static final String JMSFILE_PRE = "tlqjndi";
    private static final String JMSFILE_SUF = ".conf";
    private JndiSystem tempJndiSystem = new JndiSystem();
    private Factory tempFactory = new Factory();
    private JndiQueue tempJndiQueue = new JndiQueue();
    private JndiTopic tempJndiTopic = new JndiTopic();
    public TreeMap jndiSystemTreeMap = new TreeMap();
    public TreeMap jndiQueueTreeMap = new TreeMap();
    public TreeMap jndiTopicTreeMap = new TreeMap();
    public TreeMap factoryTreeMap = new TreeMap();
    public TreeMap clusterFactoryTreeMap = new TreeMap();
    public TreeMap clusterQueueTreeMap = new TreeMap();
    private CheckPublic checkPublic = new CheckPublic();
    private String CFGFILENAME = "";
    private int editObjectNum = 0;
    private int is = -1;
    public Properties pros = new Properties();
    public InputStream in;
    HashSet facJndiNameHashSet = new HashSet();

    private void check() throws TlqConfException {
        Iterator iterator = this.factoryTreeMap.values().iterator();
        while (iterator.hasNext()) {
            Factory factory = (Factory)iterator.next();
        }
    }

    public Tlq_JndiConf(Locale locale) throws TlqConfException {
        try {
            if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
                this.in = this.getClass().getResourceAsStream("../Tlq_TransConfig.properties");
            }
            if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh")) {
                this.in = this.getClass().getResourceAsStream("../Tlq_TransConfig_zh.properties");
            }
            this.pros.load(this.in);
            this.in.close();
        }
        catch (Exception exception) {
            System.out.println("Open Properties file error!");
        }
        String string = System.getProperty(TLQCONF_ENV_PATHNAME);
        if (string == null || string.length() == 0) {
            string = this.getClass().getResource("/").getPath();
        }
        this.CFGFILENAME = string + JMSFILE_PRE + JMSFILE_SUF;
        this.readConf();
    }

    public Tlq_JndiConf(String string, Locale locale) throws TlqConfException {
        try {
            if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
                this.in = this.getClass().getResourceAsStream("../Tlq_TransConfig.properties");
            }
            if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh")) {
                this.in = this.getClass().getResourceAsStream("../Tlq_TransConfig_zh.properties");
            }
            this.pros.load(this.in);
            this.in.close();
        }
        catch (Exception exception) {
            System.out.println("Open Properties file error!");
        }
        if (string == null || string.length() == 0) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.jndi.jndiconfpath_empty"));
        }
        if (!string.endsWith("\\") && !string.endsWith("/")) {
            string = string + "\\";
        }
        this.CFGFILENAME = string + JMSFILE_PRE + JMSFILE_SUF;
        this.readConf();
    }

    private void readConf() throws TlqConfException {
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(this.CFGFILENAME);
        }
        catch (NullPointerException nullPointerException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + nullPointerException.getMessage());
        }
        if (!file.exists()) {
            try {
                this.jndiSystemTreeMap.put("jndiSystem", this.tempJndiSystem);
                this.writeToFile();
            }
            catch (TlqConfException tlqConfException) {
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + tlqConfException.getMessage());
            }
            return;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + fileNotFoundException.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string = "";
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                this.GetValuesFromLinkCfg(string);
            }
            fileInputStream.close();
            bufferedReader.close();
        }
        catch (TlqConfException tlqConfException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + tlqConfException.getMessage());
        }
        catch (IOException iOException) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.qcu.file") + this.CFGFILENAME + " " + iOException.getMessage());
        }
        this.check();
    }

    private boolean GetValuesFromLinkCfg(String string) throws TlqConfException {
        try {
            if (string.charAt(0) == '[') {
                if (this.setSec(string)) {
                    return true;
                }
                return this.setSubSec(string);
            }
            return this.setField(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TlqConfException(numberFormatException.getMessage());
        }
    }

    private boolean setSec(String string) {
        String string2 = string;
        int n = JndiProperty.strJndiSecMsg.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.regionMatches(0, JndiProperty.strJndiSecMsg[i][0], 0, JndiProperty.strJndiSecMsg[i][0].length())) continue;
            this.editObjectNum = i;
            switch (i) {
                case 0: {
                    this.is = -1;
                    return true;
                }
                case 1: {
                    this.is = 0;
                    return true;
                }
                case 2: {
                    this.is = 1;
                    return true;
                }
                case 3: {
                    this.is = 2;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean setSubSec(String string) {
        String string2 = string;
        int n = JndiProperty.strJndiRcdMsg.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.regionMatches(0, JndiProperty.strJndiRcdMsg[i][0], 0, JndiProperty.strJndiRcdMsg[i][0].length())) continue;
            switch (i) {
                case 0: {
                    if (this.is == 0) {
                        this.tempFactory = new Factory();
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (this.is == 1) {
                        this.tempJndiQueue = new JndiQueue();
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (this.is == 2) {
                        this.tempJndiTopic = new JndiTopic();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean setField(String string) throws NumberFormatException, TlqConfException {
        int n = string.indexOf(61);
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2).trim();
        String string3 = string.substring(0, string.indexOf("=")).trim();
        if (this.editObjectNum == 0) {
            if (string3.equals("JndiQueueMaxNum")) {
                try {
                    this.tempJndiSystem.setJndiQueueMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TlqConfException("JndiQueueMaxNum:" + numberFormatException.getMessage());
                }
                this.jndiSystemTreeMap.put("jndiSystem", this.tempJndiSystem);
                return true;
            }
            if (string3.equals("JndiTopicMaxNum")) {
                try {
                    this.tempJndiSystem.setJndiTopicMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TlqConfException("JndiTopicMaxNum:" + numberFormatException.getMessage());
                }
                return true;
            }
            if (string3.equals("FactoryMaxNum")) {
                try {
                    this.tempJndiSystem.setFactoryMaxNum(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TlqConfException("FactoryMaxNum:" + numberFormatException.getMessage());
                }
                return true;
            }
            return false;
        }
        if (this.editObjectNum == 1 && this.factoryTreeMap != null) {
            if (this.tempFactory != null) {
                if (string3.equals("FacName")) {
                    if (this.facJndiNameHashSet.contains(string2)) {
                        throw new TlqConfException("FacName: " + string2 + " exist!");
                    }
                    this.tempFactory.setFacName(string2);
                    this.factoryTreeMap.put(string2, this.tempFactory);
                    this.facJndiNameHashSet.add(string2);
                    return true;
                }
                if (string3.equals("FacType")) {
                    try {
                        this.tempFactory.setFacType(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TlqConfException("FacType:" + numberFormatException.getMessage());
                    }
                    return true;
                }
                if (string3.equals("TmqiAddressList")) {
                    this.tempFactory.setTmqiAddressList(string2);
                    return true;
                }
                if (string3.equals("TmqiPingInterval")) {
                    this.tempFactory.setTmqiPingInterval(Integer.parseInt(string2));
                    return true;
                }
                if (string3.equals("TmqiConsumerFlowLimit")) {
                    this.tempFactory.setTmqiConsumerFlowLimit(Integer.parseInt(string2));
                    return true;
                }
                if (string3.equals("TmqiConsumerFlowThreshold")) {
                    this.tempFactory.setTmqiConsumerFlowThreshold(Integer.parseInt(string2));
                    return true;
                }
                if (string3.equals("TmqiAckTimeout")) {
                    this.tempFactory.setTmqiAckTimeout(Integer.parseInt(string2));
                    return true;
                }
                if (string3.equals("TmqiProducerFlowBytesLimit")) {
                    this.tempFactory.setTmqiProducerFlowBytesLimit(Integer.parseInt(string2));
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.editObjectNum == 2 && this.jndiQueueTreeMap != null) {
            if (this.tempJndiQueue != null) {
                if (string3.equals("JndiQueueName")) {
                    if (this.facJndiNameHashSet.contains(string2)) {
                        throw new TlqConfException("JndiQueueName: " + string2 + " exist!");
                    }
                    this.tempJndiQueue.setJndiQueueName(string2);
                    this.jndiQueueTreeMap.put(string2, this.tempJndiQueue);
                    this.facJndiNameHashSet.add(string2);
                    return true;
                }
                if (string3.equals("TlqQueueName")) {
                    this.tempJndiQueue.setTlqQueueName(string2);
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.editObjectNum == 3 && this.jndiTopicTreeMap != null) {
            if (this.tempJndiTopic != null) {
                if (string3.equals("JndiTopicName")) {
                    if (this.facJndiNameHashSet.contains(string2)) {
                        throw new TlqConfException("JndiTopicName: " + string2 + " exist!");
                    }
                    this.tempJndiTopic.setJndiTopicName(string2);
                    this.jndiTopicTreeMap.put(string2, this.tempJndiTopic);
                    this.facJndiNameHashSet.add(string2);
                    return true;
                }
                if (string3.equals("TlqTopicName")) {
                    this.tempJndiTopic.setTlqTopicName(string2);
                    return true;
                }
                if (string3.equals("TlqPubQueueName")) {
                    this.tempJndiTopic.setTlqPubQueueName(string2);
                    return true;
                }
                if (string3.equals("TlqPubQueueName")) {
                    this.tempJndiTopic.setTlqPubQueueName(string2);
                    return true;
                }
                if (string3.equals("TlqSubQueueName")) {
                    this.tempJndiTopic.setTlqSubQueueName(string2);
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public void writeToFile() throws TlqConfException {
        File file = new File(this.CFGFILENAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createfile_error"));
            }
        }
        File file2 = new File(this.CFGFILENAME + ".temp");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createtempfile_error"));
        }
        if (file.exists()) {
            try {
                this.copyFile(this.CFGFILENAME, this.CFGFILENAME + ".temp");
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.copytotempfile_error"));
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.CFGFILENAME);
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createfileos_error"));
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.getStackTrace();
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.createfile_error"));
        }
        try {
            Serializable serializable;
            int n;
            for (n = 0; n <= 5; ++n) {
                bufferedWriter.write(JndiProperty.strJndiCmntMsg[n]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(JndiProperty.strJndiSecMsg[0][0] + "\t\t" + JndiProperty.strJndiSecMsg[0][1]);
            bufferedWriter.newLine();
            bufferedWriter.write(JndiProperty.strJndiCmntMsg[6]);
            bufferedWriter.newLine();
            n = this.jndiSystemTreeMap.size();
            if (n > 0) {
                Iterator iterator = this.jndiSystemTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (JndiSystem)iterator.next();
                    this.printJndiSystem((JndiSystem)serializable, bufferedWriter);
                }
            }
            for (int i = 7; i <= 8; ++i) {
                bufferedWriter.write(JndiProperty.strJndiCmntMsg[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(JndiProperty.strJndiSecMsg[1][0] + "\t\t" + JndiProperty.strJndiSecMsg[1][1]);
            bufferedWriter.newLine();
            n = this.factoryTreeMap.size();
            if (n > 0) {
                Iterator iterator = this.factoryTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (Factory)iterator.next();
                    this.printFactory((Factory)serializable, bufferedWriter);
                }
            }
            for (int i = 10; i <= 11; ++i) {
                bufferedWriter.write(JndiProperty.strJndiCmntMsg[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(JndiProperty.strJndiSecMsg[2][0] + "\t\t" + JndiProperty.strJndiSecMsg[2][1]);
            bufferedWriter.newLine();
            n = this.jndiQueueTreeMap.size();
            if (n > 0) {
                Iterator iterator = this.jndiQueueTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (JndiQueue)iterator.next();
                    this.printJndiQueue((JndiQueue)serializable, bufferedWriter);
                }
            }
            for (int i = 13; i <= 14; ++i) {
                bufferedWriter.write(JndiProperty.strJndiCmntMsg[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.write(JndiProperty.strJndiSecMsg[3][0] + "\t\t" + JndiProperty.strJndiSecMsg[3][1]);
            bufferedWriter.newLine();
            n = this.jndiTopicTreeMap.size();
            if (n > 0) {
                Iterator iterator = this.jndiTopicTreeMap.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (JndiTopic)iterator.next();
                    this.printJndiTopic((JndiTopic)serializable, bufferedWriter);
                }
            }
            bufferedWriter.write(JndiProperty.strJndiCmntMsg[16]);
            bufferedWriter.newLine();
            bufferedWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.getStackTrace();
            try {
                this.copyFile(this.CFGFILENAME + ".temp", this.CFGFILENAME);
            }
            catch (Exception exception2) {
                exception2.getStackTrace();
                throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.copytofile_error"));
            }
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.system.writefile_error"));
        }
    }

    private void printJndiSystem(JndiSystem jndiSystem, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        if (jndiSystem.getJndiQueueMaxNum().isPutOut() || jndiSystem.getJndiQueueMaxNum().modified()) {
            n = JndiProperty.getJndiKeyIdx("JndiQueueMaxNum");
            attribute = jndiSystem.getJndiQueueMaxNum();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiSystem.getJndiTopicMaxNum().isPutOut() || jndiSystem.getJndiTopicMaxNum().modified()) {
            n = JndiProperty.getJndiKeyIdx("JndiTopicMaxNum");
            attribute = jndiSystem.getJndiTopicMaxNum();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiSystem.getFactoryMaxNum().isPutOut() || jndiSystem.getFactoryMaxNum().modified()) {
            n = JndiProperty.getJndiKeyIdx("FactoryMaxNum");
            attribute = jndiSystem.getFactoryMaxNum();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printFactory(Factory factory, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(JndiProperty.strJndiCmntMsg[9]);
        bufferedWriter.newLine();
        bufferedWriter.write(JndiProperty.strJndiRcdMsg[0][0] + "\t\t" + JndiProperty.strJndiRcdMsg[0][1]);
        bufferedWriter.newLine();
        if (factory.getFacName().isPutOut() || factory.getFacName().modified()) {
            n = JndiProperty.getJndiKeyIdx("FacName");
            attribute = factory.getFacName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getFacType().isPutOut() || factory.getFacType().modified()) {
            n = JndiProperty.getJndiKeyIdx("FacType");
            attribute = factory.getFacType();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiAddressList().isPutOut() || factory.getTmqiAddressList().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiAddressList");
            attribute = factory.getTmqiAddressList();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiPingInterval().isPutOut() || factory.getTmqiPingInterval().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiPingInterval");
            attribute = factory.getTmqiPingInterval();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiConsumerFlowLimit().isPutOut() || factory.getTmqiConsumerFlowLimit().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiConsumerFlowLimit");
            attribute = factory.getTmqiConsumerFlowLimit();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiConsumerFlowThreshold().isPutOut() || factory.getTmqiConsumerFlowThreshold().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiConsumerFlowThreshold");
            attribute = factory.getTmqiConsumerFlowThreshold();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiAckTimeout().isPutOut() || factory.getTmqiAckTimeout().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiAckTimeout");
            attribute = factory.getTmqiAckTimeout();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (factory.getTmqiProducerFlowBytesLimit().isPutOut() || factory.getTmqiProducerFlowBytesLimit().modified()) {
            n = JndiProperty.getJndiKeyIdx("TmqiProducerFlowBytesLimit");
            attribute = factory.getTmqiProducerFlowBytesLimit();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printJndiQueue(JndiQueue jndiQueue, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(JndiProperty.strJndiCmntMsg[12]);
        bufferedWriter.newLine();
        bufferedWriter.write(JndiProperty.strJndiRcdMsg[1][0] + "\t\t" + JndiProperty.strJndiRcdMsg[1][1]);
        bufferedWriter.newLine();
        if (jndiQueue.getJndiQueueName().isPutOut() || jndiQueue.getJndiQueueName().modified()) {
            n = JndiProperty.getJndiKeyIdx("JndiQueueName");
            attribute = jndiQueue.getJndiQueueName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiQueue.getTlqQueueName().isPutOut() || jndiQueue.getTlqQueueName().modified()) {
            n = JndiProperty.getJndiKeyIdx("TlqQueueName");
            attribute = jndiQueue.getTlqQueueName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    private void printJndiTopic(JndiTopic jndiTopic, BufferedWriter bufferedWriter) throws IOException {
        Attribute attribute;
        int n;
        bufferedWriter.write(JndiProperty.strJndiCmntMsg[15]);
        bufferedWriter.newLine();
        bufferedWriter.write(JndiProperty.strJndiRcdMsg[2][0] + "\t\t" + JndiProperty.strJndiRcdMsg[2][1]);
        bufferedWriter.newLine();
        if (jndiTopic.getJndiTopicName().isPutOut() || jndiTopic.getJndiTopicName().modified()) {
            n = JndiProperty.getJndiKeyIdx("JndiTopicName");
            attribute = jndiTopic.getJndiTopicName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiTopic.getTlqTopicName().isPutOut() || jndiTopic.getTlqTopicName().modified()) {
            n = JndiProperty.getJndiKeyIdx("TlqTopicName");
            attribute = jndiTopic.getTlqTopicName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiTopic.getTlqPubQueueName().getValue() != null && !"".equals(jndiTopic.getTlqPubQueueName().getValue()) && (jndiTopic.getTlqPubQueueName().isPutOut() || jndiTopic.getTlqPubQueueName().modified())) {
            n = JndiProperty.getJndiKeyIdx("TlqPubQueueName");
            attribute = jndiTopic.getTlqPubQueueName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
        if (jndiTopic.getTlqSubQueueName().getValue() != null && !"".equals(jndiTopic.getTlqSubQueueName().getValue()) && (jndiTopic.getTlqSubQueueName().isPutOut() || jndiTopic.getTlqSubQueueName().modified())) {
            n = JndiProperty.getJndiKeyIdx("TlqSubQueueName");
            attribute = jndiTopic.getTlqSubQueueName();
            bufferedWriter.write(JndiProperty.strJndiFldMsg[n][0] + " = " + attribute.getValue() + "\t\t" + JndiProperty.strJndiFldMsg[n][3]);
            bufferedWriter.newLine();
        }
    }

    public boolean modifySystem(JndiSystem jndiSystem) throws TlqConfException {
        if (jndiSystem == null) {
            throw new TlqConfException(" jndiSystem :argument is empty! ");
        }
        this.jndiSystemTreeMap.put("jndiSystem", jndiSystem);
        return true;
    }

    public boolean addFactory(Factory factory) throws TlqConfException, Exception {
        if (factory == null) {
            throw new TlqConfException(" factory :argument is empty! ");
        }
        if (this.factoryTreeMap.containsKey(factory.getFacName().getValue())) {
            throw new TlqConfException(" FacName: " + factory.getFacName().getValue() + " exist!");
        }
        if (this.facJndiNameHashSet.contains(factory.getFacName().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.jndi.jndiisname") + factory.getFacName().getValue() + " exist!");
        }
        this.factoryTreeMap.put(factory.getFacName().getValue(), factory);
        return true;
    }

    public boolean modifyFactory(Factory factory) throws TlqConfException, Exception {
        if (factory == null) {
            throw new TlqConfException(" factory :argument is empty! ");
        }
        if (!this.factoryTreeMap.containsKey(factory.getFacName().getValue())) {
            throw new TlqConfException(" FacName :" + factory.getFacName().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        this.factoryTreeMap.put("" + factory.getFacName().getValue(), factory);
        return true;
    }

    public boolean deleteFactory(String string) throws TlqConfException {
        if (this.factoryTreeMap.containsKey("" + string)) {
            this.factoryTreeMap.remove("" + string);
            return true;
        }
        throw new TlqConfException(" FacName: " + string + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    public boolean addJndiQueue(JndiQueue jndiQueue) throws TlqConfException, Exception {
        if (jndiQueue == null) {
            throw new TlqConfException(" jndiQueue :argument is empty! ");
        }
        if (this.jndiQueueTreeMap.containsKey(jndiQueue.getJndiQueueName().getValue())) {
            throw new TlqConfException(" JndiQueueName: " + jndiQueue.getJndiQueueName().getValue() + " exist!");
        }
        if (this.facJndiNameHashSet.contains(jndiQueue.getJndiQueueName().getValue())) {
            throw new TlqConfException(" Jndi is name: " + jndiQueue.getJndiQueueName().getValue() + " exist!");
        }
        this.jndiQueueTreeMap.put(jndiQueue.getJndiQueueName().getValue(), jndiQueue);
        return true;
    }

    public boolean modifyJndiQueue(JndiQueue jndiQueue) throws TlqConfException, Exception {
        if (jndiQueue == null) {
            throw new TlqConfException(" jndiQueue :argument is empty! ");
        }
        if (!this.jndiQueueTreeMap.containsKey(jndiQueue.getJndiQueueName().getValue())) {
            throw new TlqConfException(" JndiQueueName: " + jndiQueue.getJndiQueueName().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        this.jndiQueueTreeMap.put("" + jndiQueue.getJndiQueueName().getValue(), jndiQueue);
        return true;
    }

    public boolean deleteJndiQueue(String string) throws TlqConfException {
        if (this.jndiQueueTreeMap.containsKey("" + string)) {
            this.jndiQueueTreeMap.remove("" + string);
            return true;
        }
        throw new TlqConfException(" JndiQueueName: " + string + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    public boolean addJndiTopic(JndiTopic jndiTopic) throws TlqConfException, Exception {
        if (jndiTopic == null) {
            throw new TlqConfException(" jndiTopic :argument is empty! ");
        }
        if (this.jndiTopicTreeMap.containsKey(jndiTopic.getJndiTopicName().getValue())) {
            throw new TlqConfException(" JndiTopicName: " + jndiTopic.getJndiTopicName().getValue() + " exist!");
        }
        if (this.facJndiNameHashSet.contains(jndiTopic.getJndiTopicName().getValue())) {
            throw new TlqConfException(this.pros.getProperty("exception.tlq.conf.jndi.jndiisname") + jndiTopic.getJndiTopicName().getValue() + " exist!");
        }
        this.jndiTopicTreeMap.put(jndiTopic.getJndiTopicName().getValue(), jndiTopic);
        return true;
    }

    public boolean modifyJndiTopic(JndiTopic jndiTopic) throws TlqConfException, Exception {
        if (jndiTopic == null) {
            throw new TlqConfException(" jndiTopic :argument is empty! ");
        }
        if (!this.jndiTopicTreeMap.containsKey(jndiTopic.getJndiTopicName().getValue())) {
            throw new TlqConfException(" JndiTopicName: " + jndiTopic.getJndiTopicName().getValue() + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
        }
        this.jndiTopicTreeMap.put("" + jndiTopic.getJndiTopicName().getValue(), jndiTopic);
        return true;
    }

    public boolean deleteJndiTopic(String string) throws TlqConfException {
        if (this.jndiTopicTreeMap.containsKey("" + string)) {
            this.jndiTopicTreeMap.remove("" + string);
            return true;
        }
        throw new TlqConfException(" JndiTopicName: " + string + this.pros.getProperty("exception.tlq.conf.system.doesnot") + " exist!");
    }

    private void copyFile(String string, String string2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string3 = "";
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string3);
            bufferedWriter.newLine();
        }
        fileInputStream.close();
        bufferedReader.close();
        bufferedWriter.close();
        fileOutputStream.close();
    }
}

