/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.dynamic.comunit;

import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.ConstDefine;
import com.tongtech.tlq.admin.dynamic.JavaCTransInType;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;

public class Client {
    public static final int SENDBUF_SIZE = 32896;
    public static final int RECVBUF_SIZE = 32896;
    private static final int ATTEMP_TIMES = 3;
    public static final int RECVF_TIME = 10000;
    public int SoTimeout = 10000;
    public int ConnTimeout = 10000;
    public int RCVRETRY_TIMES = 10;
    InputStream dis = null;
    OutputStream dos = null;
    PrintStream dps = null;
    Socket socket = null;
    public Locale loc = null;
    private String ip = null;
    private int port = 0;
    private boolean connOk = false;
    private byte[] bakHead = null;
    private byte[] bakSendData = null;
    private boolean allowAutoReConn = false;
    private int connTimes = 10;
    private long interval = 1000L;

    public Client(String string, int n) {
        this.ip = string;
        this.port = n;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean isConnected() {
        return this.connOk;
    }

    public void setConnected(boolean bl) {
        this.connOk = bl;
    }

    public void setReConn(boolean bl, int n, long l) throws TlqConfException {
        if (bl && (n < -1 || l < 10L)) {
            throw new TlqConfException("connTimes[" + n + "] or interval[" + l + "] is invalid!", 4000, 0);
        }
        this.allowAutoReConn = bl;
        this.connTimes = n;
        this.interval = l;
    }

    public synchronized void connect() throws TlqConfException {
        if (this.connOk) {
            return;
        }
        this.closeNoException();
        this.connOk = false;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.ip);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new TlqConfException("Connect Ip=" + this.ip + " Port=" + this.port + " failed,UnknownHostException![" + unknownHostException.getMessage() + "]", unknownHostException);
        }
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        while (true) {
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
                this.socket = new Socket();
                l = System.currentTimeMillis();
                if (ConstDefine.logDebug == 1) {
                    System.out.println("Connect Ip=" + this.ip + " Port=" + this.port + " ConnTimeout=" + this.ConnTimeout + " StartTime=" + l);
                }
                this.socket.connect(inetSocketAddress, this.ConnTimeout);
                if (ConstDefine.logDebug != 1) break;
                l2 = System.currentTimeMillis();
                System.out.println("Connect Ip=" + this.ip + " Port=" + this.port + " ConnTimeout=" + this.ConnTimeout + " StartOKTime=" + l2 + " UseTime=" + (l2 - l));
            }
            catch (IOException iOException) {
                l2 = System.currentTimeMillis();
                if (!this.allowAutoReConn) {
                    this.connOk = false;
                    throw new TlqConfException("Connect Ip=" + this.ip + " Port=" + this.port + " ConnTimeout=" + this.ConnTimeout + " StartOKTime=" + l2 + " UseTime=" + (l2 - l) + " failed!IOException[" + iOException.getMessage() + "]", (Throwable)iOException, 4600, 0);
                }
                try {
                    if (ConstDefine.logDebug == 1) {
                        System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Conn Times=" + n + ",Link IP[" + this.ip + "] Port[" + this.port + "]" + " SoTimeout=" + this.SoTimeout + " StartOKTime=" + l2 + " UseTime=" + (l2 - l));
                    }
                    Thread.sleep(this.interval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (++n < this.connTimes) continue;
                throw new TlqConfException("ReConnect Ip=" + this.ip + " Port=" + this.port + " overtimes!IOException[" + iOException.getMessage() + "]permit[" + this.allowAutoReConn + " connTimes[" + this.connTimes + "]interval" + this.interval + "]", (Throwable)iOException, 4600, 0);
            }
            break;
        }
        try {
            this.socket.setTcpNoDelay(true);
            this.socket.setSendBufferSize(32896);
            this.socket.setReceiveBufferSize(32896);
            this.socket.setSoTimeout(this.SoTimeout);
            this.dos = this.socket.getOutputStream();
            this.dis = new DataInputStream(this.socket.getInputStream());
            this.dps = new PrintStream(this.dos);
            this.connOk = true;
        }
        catch (IOException iOException) {
            this.connOk = false;
            try {
                this.socket.close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            if (this.loc.equals(Locale.ENGLISH) || this.loc.equals(Locale.US)) {
                throw new TlqConfException("Set socket parameters faild!Link IP[" + this.ip + "] Port[" + this.port + "]", (Throwable)iOException, 4600, 0);
            }
            throw new TlqConfException("\u8bbe\u7f6eSocket\u8fde\u63a5\u53c2\u6570\u5931\u8d25Link IP[" + this.ip + "] Port[" + this.port + "]", (Throwable)iOException, 4600, 0);
        }
    }

    private void recvdata() throws IOException {
        block6: {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.dis.available();
            try {
                if (n4 <= 0) break block6;
                byte[] byArray = new byte[n4];
                while (++n <= this.RCVRETRY_TIMES) {
                    n2 = this.dis.read(byArray, n3, n4 - n3);
                    if (n2 > 0) {
                        n3 += n2;
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (n3 < n4) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void send(byte[] byArray, byte[] byArray2) throws TlqConfException {
        Object object;
        if (!this.connOk) {
            if (this.allowAutoReConn) {
                this.closeNoException();
                this.connect();
                if (ConstDefine.logDebug == 1) {
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Send. Connect have been closed,will reconnect!Link IP[" + this.ip + "] Port[" + this.port + "]");
                }
            } else {
                if (this.loc.equals(Locale.ENGLISH)) {
                    throw new TlqConfException("Client connection not exist!Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
                }
                throw new TlqConfException("\u8fde\u63a5\u672a\u5efa\u7acb\uff01Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
            }
        }
        int n = 0;
        if (byArray2 != null) {
            n = byArray2.length;
        }
        if (ConstDefine.logDebug == 1) {
            object = new String(byArray2, 0, n);
            System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Send Data=" + (String)object + "Link IP[" + this.ip + "] Port[" + this.port + "]");
        }
        object = new JavaCTransInType();
        byte[] byArray3 = ((JavaCTransInType)object).intToByte(n);
        System.arraycopy(byArray3, 0, byArray, 12, 4);
        if (this.allowAutoReConn) {
            this.bakHead = byArray;
            this.bakSendData = byArray2;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.recvdata();
                this.dos.write(byArray);
                if (byArray2 != null) {
                    this.dos.write(byArray2);
                }
                this.dps.checkError();
                this.dos.flush();
                break;
            }
            catch (IOException iOException) {
                if (iOException instanceof SocketTimeoutException) {
                    TlqConfException tlqConfException = null;
                    tlqConfException = this.loc.equals(Locale.ENGLISH) ? new TlqConfException("Client-SendData, recvdata read time out![" + iOException.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]") : new TlqConfException("\u53d1\u9001\u6570\u636e\u524d,\u63a5\u6536\u6570\u636e\u5305\u5934\u8d85\u65f6![" + iOException.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]");
                    tlqConfException.tlq_errno = 4001;
                    throw tlqConfException;
                }
                if (i < 3 && this.allowAutoReConn) {
                    this.closeNoException();
                    this.connect();
                    if (ConstDefine.logDebug != 1) continue;
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Send data failed,will reconnect!Link IP[" + this.ip + "] Port[" + this.port + "]");
                    continue;
                }
                this.closeNoException();
                if (ConstDefine.logDebug == 1) {
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "Send Data Error,Link IP[" + this.ip + "] Port[" + this.port + "] close");
                }
                if (this.loc.equals(Locale.ENGLISH)) {
                    throw new TlqConfException("Client-SendData unsuccessfully![" + iOException.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
                }
                System.out.println(iOException.getMessage());
                throw new TlqConfException("\u53d1\u9001\u6570\u636e\u5931\u8d25\uff01Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
            }
        }
    }

    public byte[] receive() throws TlqConfException {
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[4];
        JavaCTransInType javaCTransInType = new JavaCTransInType();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray3 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                while (++n4 <= this.RCVRETRY_TIMES) {
                    n = this.dis.read(byArray, n2, 128 - n2);
                    if (n4 == 1 && n < 0) {
                        throw new Exception("Client-Receive package head data,connect have been closed");
                    }
                    if (n > 0) {
                        n2 += n;
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (n2 < 128) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SocketTimeoutException) {
                    TlqConfException tlqConfException = null;
                    tlqConfException = this.loc.equals(Locale.ENGLISH) ? new TlqConfException("Client-Receive package head data,read time out![" + exception.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]") : new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u5934\u8d85\u65f6![" + exception.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]");
                    tlqConfException.tlq_errno = 4001;
                    throw tlqConfException;
                }
                if (i < 3 && this.allowAutoReConn) {
                    this.closeNoException();
                    this.connect();
                    this.send(this.bakHead, this.bakSendData);
                    if (ConstDefine.logDebug != 1) continue;
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Recv head failed,will reconnect!Link IP[" + this.ip + "] Port[" + this.port + "]");
                    continue;
                }
                this.closeNoException();
                if (ConstDefine.logDebug == 1) {
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "Recv Head Error,Link IP[" + this.ip + "] Port[" + this.port + "] close");
                }
                if (this.loc.equals(Locale.ENGLISH)) {
                    throw new TlqConfException("Client-Receive package head data unsuccessfully![" + exception.getMessage() + "]", 4600, 0);
                }
                System.out.print(exception.getMessage());
                throw new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u5934\u5931\u8d25\uff01", 4600, 0);
            }
            if (n4 > this.RCVRETRY_TIMES) {
                if (this.loc.equals(Locale.ENGLISH)) {
                    throw new TlqConfException("Client-Receive package head data unsuccessfully, retrying times has exceeded the scope!Link IP[" + this.ip + "] Port[" + this.port + "]");
                }
                throw new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u5934\u5931\u8d25\uff0c\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570\uff01Link IP[" + this.ip + "] Port[" + this.port + "]");
            }
            n4 = 0;
            int n5 = 0;
            int n6 = 12;
            while (n6 < 16) {
                byArray2[n5] = byArray[n6];
                ++n6;
                ++n5;
            }
            n3 = javaCTransInType.byteToInt(byArray2);
            if (0 == n3) {
                return byArray;
            }
            byArray3 = new byte[128 + n3];
            System.arraycopy(byArray, 0, byArray3, 0, 128);
            try {
                while (++n4 <= this.RCVRETRY_TIMES) {
                    n = this.dis.read(byArray3, n2, n3 + 128 - n2);
                    if (n4 == 1 && n < 0) {
                        throw new Exception("Client-Receive package data,connect have been closed");
                    }
                    if (n > 0) {
                        n2 += n;
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (n2 < 128 + n3) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SocketTimeoutException) {
                    TlqConfException tlqConfException = null;
                    tlqConfException = this.loc.equals(Locale.ENGLISH) ? new TlqConfException("Client-Receive package data,read time out![" + exception.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]") : new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u8d85\u65f6![" + exception.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]");
                    tlqConfException.tlq_errno = 4001;
                    throw tlqConfException;
                }
                if (i < 3 && this.allowAutoReConn) {
                    this.closeNoException();
                    this.connect();
                    this.send(this.bakHead, this.bakSendData);
                    if (ConstDefine.logDebug != 1) continue;
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Recv data failed,will reconnect.Link IP[" + this.ip + "] Port[" + this.port + "]");
                    continue;
                }
                this.closeNoException();
                if (ConstDefine.logDebug == 1) {
                    System.out.println("TreadNo[" + Thread.currentThread().getName() + "Recv Data Error,Link IP[" + this.ip + "] Port[" + this.port + "] ");
                }
                if (this.loc.equals(Locale.ENGLISH)) {
                    throw new TlqConfException("Client-Receive package data unsuccessfully![" + exception.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
                }
                System.out.print(exception.getMessage());
                throw new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u5931\u8d25\uff01Link IP[" + this.ip + "] Port[" + this.port + "]", 4600, 0);
            }
            if (n4 <= this.RCVRETRY_TIMES) break;
            if (this.loc.equals(Locale.ENGLISH)) {
                throw new TlqConfException("Client-Receive package data unsuccessfully, retrying times has exceeded the scope!Link IP[" + this.ip + "] Port[" + this.port + "]");
            }
            throw new TlqConfException("\u63a5\u6536\u6570\u636e\u5305\u5931\u8d25\uff0c\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570\uff01Link IP[" + this.ip + "] Port[" + this.port + "]");
        }
        return byArray3;
    }

    public synchronized void close() throws TlqConfException {
        this.connOk = false;
        try {
            if (this.dis != null) {
                this.dis.close();
            }
            this.dis = null;
            if (this.dos != null) {
                this.dos.close();
            }
            this.dos = null;
            if (this.dps != null) {
                this.dps.close();
            }
            this.dps = null;
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
            this.connOk = false;
            if (ConstDefine.logDebug == 1) {
                System.out.println("TreadNo[" + Thread.currentThread().getName() + "]Link IP[" + this.ip + "] Port[" + this.port + "] close");
            }
        }
        catch (IOException iOException) {
            if (this.loc.equals(Locale.ENGLISH)) {
                throw new TlqConfException("Client-Close Socket unsuccessfully![" + iOException.getMessage() + "]Link IP[" + this.ip + "] Port[" + this.port + "]", (Throwable)iOException, 4600, 0);
            }
            System.out.print(iOException.getMessage());
            throw new TlqConfException("\u5173\u95edsocket\u5931\u8d25\uff01Link IP[" + this.ip + "] Port[" + this.port + "]", (Throwable)iOException, 4600, 0);
        }
    }

    private synchronized void closeNoException() {
        try {
            this.close();
        }
        catch (TlqConfException tlqConfException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }
}

