/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api;

import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.ConstDefine;
import com.tongtech.tlq.admin.dynamic.comunit.Client;
import com.tongtech.tlq.admin.dynamic.manage.PackParseData;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Locale;

public class TLQConnect {
    private Client client;
    private char language = (char)69;
    public static final int DEBUG_YES = 1;
    public static final int DEBUG_NO = 0;
    private int isDebug = 0;
    private int recvDataTmOut = 10;
    private int connTmOut = 10;
    private char resourceType = (char)77;

    public TLQConnect(String string, int n) throws TLQParameterException, TLQRemoteException {
        if (null == string) {
            throw new TLQParameterException("Parameter: ip is empty!");
        }
        if (n < 0) {
            throw new TLQParameterException("Parameter: port < 0!");
        }
        this.client = new Client(string, n);
        this.client.loc = Locale.ENGLISH;
        this.client.RCVRETRY_TIMES = this.recvDataTmOut;
    }

    public TLQConnect(Client client) throws TLQParameterException, TLQRemoteException {
        if (client == null) {
            throw new TLQParameterException("Parameter: client is empty!");
        }
        this.client = client;
        if (client.loc == null) {
            throw new TLQParameterException("Parameter: locale is illegal!");
        }
        if (Locale.ENGLISH.getLanguage().equals(client.loc.getLanguage())) {
            this.language = (char)69;
        } else if (Locale.CHINESE.equals(client.loc) || Locale.SIMPLIFIED_CHINESE.equals(client.loc) || client.loc.toString().contains("zh")) {
            this.language = (char)90;
        } else {
            throw new TLQParameterException("Parameter\uff1alocale is not in english or chinese!");
        }
    }

    public char getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(char c) {
        this.resourceType = c;
    }

    public String getIp() {
        return this.client.getIp();
    }

    public int getPort() {
        return this.client.getPort();
    }

    public char getLanguage() {
        return this.language;
    }

    protected Client getClient() {
        return this.client;
    }

    public void connect() throws TLQRemoteException {
        try {
            this.client.connect();
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        try {
            PackParseData packParseData = new PackParseData(this.client);
            byte[] byArray = this.client.receive();
            ArrayList arrayList = packParseData.parse(byArray);
            Integer n = (Integer)arrayList.get(0);
            if (n < 0) {
                String string = (String)arrayList.get(1);
                throw new TlqConfException(string);
            }
        }
        catch (TlqConfException tlqConfException) {
            try {
                this.client.close();
            }
            catch (TlqConfException tlqConfException2) {
                tlqConfException2.printStackTrace();
            }
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void close() throws TLQRemoteException {
        try {
            this.client.close();
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public int getIsDebug() {
        return this.isDebug;
    }

    public void setIsDebug(int n) throws TLQParameterException {
        if (n != 0 && n != 1) {
            throw new TLQParameterException("Parameter: isDebug is illegal!");
        }
        this.isDebug = n;
        ConstDefine.logDebug = n;
    }

    public int getRecvDataTmOut() {
        return this.recvDataTmOut;
    }

    public void setRecvDataTmOut(int n) throws TLQParameterException {
        if (n <= 0) {
            throw new TLQParameterException("Parameter: recvDataTmOut is illegal!");
        }
        this.recvDataTmOut = n;
        this.client.SoTimeout = this.recvDataTmOut * 1000;
    }

    public int getConnTmOut() {
        return this.connTmOut;
    }

    public void setConnTmOut(int n) throws TLQParameterException {
        if (n < 0) {
            throw new TLQParameterException("Parameter: connTmOut is illegal!");
        }
        this.connTmOut = n;
        this.client.ConnTimeout = this.connTmOut * 1000;
    }

    public Locale getLocale() {
        return this.client.loc;
    }

    public void setLocale(Locale locale) throws TLQParameterException {
        if (locale == null) {
            throw new TLQParameterException("Parameter: locale is illegal!");
        }
        if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
            this.language = (char)69;
        } else if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh")) {
            this.language = (char)90;
        } else {
            throw new TLQParameterException("Parameter\uff1alocale is not in english or chinese!");
        }
        this.client.loc = locale;
    }

    public boolean isConnect() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public void setReConn(boolean bl, int n, long l) throws TLQRemoteException {
        try {
            this.client.setReConn(bl, n, l);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }
}

