/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.jndi;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.conf.jndi.ClusterQueue;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;

public class TLQOptJndiClusterQueue
extends TLQOptBaseObj {
    public TLQOptJndiClusterQueue(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TJCQ";
        this.objLevel = 1;
        this.objName = "";
    }

    public Map getClusterQueueList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public ClusterQueue getClusterQueue(String string) throws TLQParameterException, TLQRemoteException {
        ClusterQueue clusterQueue;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiClusterQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            clusterQueue = (ClusterQueue)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return clusterQueue;
    }

    public void setClusterQueue(ClusterQueue clusterQueue) throws TLQParameterException, TLQRemoteException {
        if (clusterQueue == null) {
            throw new TLQParameterException(" jndiClusterQueue :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = clusterQueue.getJndiClusterQueueName().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, clusterQueue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addClusterQueue(ClusterQueue clusterQueue) throws TLQParameterException, TLQRemoteException {
        if (clusterQueue == null) {
            throw new TLQParameterException(" factory :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = clusterQueue.getJndiClusterQueueName().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, clusterQueue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteClusterQueue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiClusterQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistClusterQueue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" clusterQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 1;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TJCQ";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }
}

