/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.jndi;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.conf.jndi.JndiQueue;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;

public class TLQOptJndiQueue
extends TLQOptBaseObj {
    public TLQOptJndiQueue(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TJJQ";
        this.objLevel = 1;
        this.objName = "";
    }

    public Map getJndiQueueList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public JndiQueue getJndiQueue(String string) throws TLQParameterException, TLQRemoteException {
        JndiQueue jndiQueue;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            jndiQueue = (JndiQueue)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return jndiQueue;
    }

    public void setJndiQueue(JndiQueue jndiQueue) throws TLQParameterException, TLQRemoteException {
        if (jndiQueue == null) {
            throw new TLQParameterException(" jndiQueue :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = jndiQueue.getJndiQueueName().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, jndiQueue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addJndiQueue(JndiQueue jndiQueue) throws TLQParameterException, TLQRemoteException {
        if (jndiQueue == null) {
            throw new TLQParameterException(" jndiQueue :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = jndiQueue.getJndiQueueName().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, jndiQueue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteJndiQueue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistJndiQueue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 1;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TJJQ";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }
}

