/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.jndi;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.conf.jndi.JndiTopic;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;

public class TLQOptJndiTopic
extends TLQOptBaseObj {
    public TLQOptJndiTopic(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TJJT";
        this.objLevel = 1;
        this.objName = "";
    }

    public Map getJndiTopicList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public JndiTopic getJndiTopic(String string) throws TLQParameterException, TLQRemoteException {
        JndiTopic jndiTopic;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiTopicName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            jndiTopic = (JndiTopic)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return jndiTopic;
    }

    public void setJndiTopic(JndiTopic jndiTopic) throws TLQParameterException, TLQRemoteException {
        if (jndiTopic == null) {
            throw new TLQParameterException(" jndiTopic :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = jndiTopic.getJndiTopicName().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, jndiTopic);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addJndiTopic(JndiTopic jndiTopic) throws TLQParameterException, TLQRemoteException {
        if (jndiTopic == null) {
            throw new TLQParameterException(" jndiTopic :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = jndiTopic.getJndiTopicName().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, jndiTopic);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteJndiTopic(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiTopicName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistJndiQueue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" jndiTopicName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 1;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TJJT";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }
}

