/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.node;

import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.common.TlqPage;
import com.tongtech.tlq.admin.conf.NodeSystemInfo;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class TLQOptNodeSystem
extends TLQOptBaseObj {
    public TLQOptNodeSystem(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TSYS";
        this.objLevel = 1;
        this.objName = "sysInfo";
    }

    public NodeSystemInfo getNodeSystemInfo() throws TLQRemoteException {
        NodeSystemInfo nodeSystemInfo;
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        try {
            nodeSystemInfo = (NodeSystemInfo)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return nodeSystemInfo;
    }

    public void setNodeSystemInfo(NodeSystemInfo nodeSystemInfo) throws TLQParameterException, TLQRemoteException {
        if (nodeSystemInfo == null) {
            throw new TLQParameterException(" nodeSystemInfo :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, nodeSystemInfo);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public String getNodeState() throws TLQRemoteException {
        String string;
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        try {
            string = this.tlqDynamic.RemoteQueryState(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        String string2 = string.equals("6002") ? "Stopped" : (string.equals("6003") ? "Working" : (string.equals("6004") ? "Stopping" : (string.equals("6005") ? "Starting" : "Stopped")));
        return string2;
    }

    public void startNode() throws TLQRemoteException {
        try {
            this.tlqDynamic.RemoteControl("6802");
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopNodeByNormal() throws TLQRemoteException {
        try {
            this.tlqDynamic.RemoteControl("6803");
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopNodeByAbort() throws TLQRemoteException {
        try {
            this.tlqDynamic.RemoteControl("6804");
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties getNodeSpvInfo() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(2), (ArrayList)arrayList.get(3), (ArrayList)arrayList.get(4));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public void restoreNodeConfFile() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)82;
        tlqObjDesc.setOperResMode('C');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Map getTLQProcessInSys(TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        Map map = null;
        try {
            TlqObjDesc tlqObjDesc = new TlqObjDesc();
            this.setTlqObjDesc(tlqObjDesc);
            tlqObjDesc.setOperResMode('M');
            tlqObjDesc.objProps.put("MoniType", "process");
            ArrayList arrayList = this.tlqDynamic.superTlqObjs(tlqObjDesc, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }
}

