/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.node;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.conf.Program;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;

public class TLQOptProgram
extends TLQOptBaseObj {
    public TLQOptProgram(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TPGM";
        this.objLevel = 1;
        this.objName = "";
    }

    public Map getProgramList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getProgramList(String string) throws TLQParameterException, TLQRemoteException {
        if (!("N".equals(string) || "P".equals(string) || "T".equals(string) || "S".equals(string))) {
            throw new TLQParameterException("prgType:" + string + " is not legal!");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objProps.put("PrgType", string);
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Program getProgram(String string) throws TLQParameterException, TLQRemoteException {
        Program program;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" programId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            program = (Program)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return program;
    }

    public void setProgram(Program program) throws TLQParameterException, TLQRemoteException {
        if (program == null) {
            throw new TLQParameterException(" program :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = program.getPrgID().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, program);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addProgram(Program program) throws TLQParameterException, TLQRemoteException {
        if (program == null) {
            throw new TLQParameterException(" program :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = program.getPrgID().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, program);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteProgram(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" programId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void loadProgram(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" programId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)97;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void unLoadProgram(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" programId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)100;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistProgram(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" programId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 1;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TPGM";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Map getProgramList2() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objProps.put("listType", "2");
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, 0);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }
}

