/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.qcu;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.comunit.Client;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import com.tongtech.tlq.admin.remote.api.qcu.ParaNameValue;
import java.util.ArrayList;

public class TLQOptCheck
extends TLQOptBaseObj {
    private Client client;
    public static final String TYPE_COMMON = "TCHK";
    public static final String RMT_LISTEN_PORT = "T_PORT";
    public static final String RMT_IP = "T_IP";
    public static final String RMT_SO_FILE = "T_SO";
    public static final String RMT_SO_FUNC = "T_SO_FUNC";
    public static final String RMT_FILE = "T_FILE";
    public static final String RMT_PSRMTQ = "T_PSRMTQ";
    public static final String RMT_SNCONNQ = "T_SNDCONQ";
    public static final String RMT_CLSTERQ = "T_CLSTERQ";
    public static final String PREFIX = "Server-spv_common_check:";
    public static final String RMT_QUE = "T_QUE";
    public static final String RMT_JNDI_NAME = "T_JNDI_NAME";

    public TLQOptCheck(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
    }

    public boolean checkListenPort(int n) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("port", "" + n)};
        try {
            this.tlqDynamic.remoteCheck(RMT_LISTEN_PORT, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean checkSpvListenPort(int n) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("port", "" + n), new ParaNameValue("procname", "spv")};
        try {
            this.tlqDynamic.remoteCheck(RMT_LISTEN_PORT, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean checkSoFile(String string) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("filename", string)};
        try {
            this.tlqDynamic.remoteCheck(RMT_SO_FILE, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean checkSoFunction(String string, String string2, String string3) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("filename", string == null ? "" : string.trim()), new ParaNameValue("funcname", string2), new ParaNameValue("qcuname", string3 == null ? "" : string3.trim())};
        try {
            this.tlqDynamic.remoteCheck(RMT_SO_FUNC, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean checkIP(String string) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("ip", string)};
        try {
            this.tlqDynamic.remoteCheck(RMT_IP, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean checkFile(String string) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("filename", string)};
        try {
            this.tlqDynamic.remoteCheck(RMT_FILE, paraNameValueArray);
            return true;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistQue(String string, String string2) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("qcu", string), new ParaNameValue("que", string2)};
        try {
            try {
                this.tlqDynamic.remoteCheck(RMT_QUE, paraNameValueArray);
            }
            catch (TlqConfException tlqConfException) {
                String string3 = tlqConfException.getMessage();
                if (string3.indexOf("error.queue.exists") != -1) {
                    return true;
                }
                throw tlqConfException;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public String[] getPubSubFreeRmtQ(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException("qcuName should not be null");
        }
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("qcu", string)};
        try {
            ArrayList arrayList = this.tlqDynamic.remoteCheck(RMT_PSRMTQ, paraNameValueArray);
            ArrayList arrayList2 = (ArrayList)arrayList.get(2);
            if (arrayList2.size() > 0) {
                DataSet dataSet = (DataSet)arrayList2.get(0);
                String string2 = dataSet.getValue();
                String[] stringArray = string2.split("\\|");
                return stringArray;
            }
            return new String[0];
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public String[] getSndConnFreeSndQ(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException("qcuName should not be null");
        }
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("qcu", string)};
        try {
            ArrayList arrayList = this.tlqDynamic.remoteCheck(RMT_SNCONNQ, paraNameValueArray);
            ArrayList arrayList2 = (ArrayList)arrayList.get(2);
            if (arrayList2.size() > 0) {
                DataSet dataSet = (DataSet)arrayList2.get(0);
                String string2 = dataSet.getValue();
                String[] stringArray = string2.split("\\|");
                return stringArray;
            }
            return new String[0];
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public String[] getClusterDestFreeQ(String string, String string2) throws TLQParameterException, TLQRemoteException {
        if (string == null || string.trim().equals("")) {
            throw new TLQParameterException("qcuName should not be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new TLQParameterException("clusterName should not be null");
        }
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("qcu", string), new ParaNameValue("cluster", string2)};
        try {
            ArrayList arrayList = this.tlqDynamic.remoteCheck(RMT_CLSTERQ, paraNameValueArray);
            ArrayList arrayList2 = (ArrayList)arrayList.get(2);
            if (arrayList2.size() > 0) {
                DataSet dataSet = (DataSet)arrayList2.get(0);
                String string3 = dataSet.getValue();
                String[] stringArray = string3.split("\\|");
                return stringArray;
            }
            return new String[0];
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean jndiNameCheck(String string) throws TLQRemoteException {
        ParaNameValue[] paraNameValueArray = new ParaNameValue[]{new ParaNameValue("checkName", string)};
        try {
            try {
                this.tlqDynamic.remoteCheck(RMT_JNDI_NAME, paraNameValueArray);
            }
            catch (TlqConfException tlqConfException) {
                String string2 = tlqConfException.getMessage();
                if (string2.indexOf("error.jndiname.exists") != -1) {
                    return true;
                }
                throw tlqConfException;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }
}

