/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.qcu;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.common.TlqPage;
import com.tongtech.tlq.admin.conf.LocalQue;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class TLQOptLocalQue
extends TLQOptBaseObj {
    public TLQOptLocalQue(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TLCQ";
        this.objLevel = 2;
        this.objName = "";
    }

    public Map getLocalQueList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            int n = 0;
            while (n < arrayList.size()) {
                DataSet dataSet = (DataSet)arrayList.get(n);
                if (dataSet.value.length() > 7 && dataSet.value.subSequence(0, 7).equals("TLQ.SYS")) {
                    arrayList.remove(n);
                    n = 0;
                    continue;
                }
                ++n;
            }
            map = this.getListMap(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getLocalQueList2(int n) throws TLQParameterException, TLQRemoteException {
        if (n != 0 && n != 1) {
            throw new TLQParameterException(" getListCondition is not legal!");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objProps.put("listType", "2");
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, n);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public LocalQue getLocalQue(String string) throws TLQParameterException, TLQRemoteException {
        LocalQue localQue;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            localQue = (LocalQue)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return localQue;
    }

    public void setLocalQue(LocalQue localQue) throws TLQParameterException, TLQRemoteException {
        if (localQue == null) {
            throw new TLQParameterException(" localQueue :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = localQue.getLocalQueName().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, localQue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addLocalQue(LocalQue localQue) throws TLQParameterException, TLQRemoteException {
        if (localQue == null) {
            throw new TLQParameterException(" localQueue :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = localQue.getLocalQueName().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, localQue);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteLocalQueByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteLocalQueByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)70;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void clearMessageByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)80;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void clearMessageByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)81;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteSingleMsgByMsgId(String string, ArrayList arrayList) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (arrayList == null || arrayList.size() == 0) {
            throw new TLQParameterException(" msgIdList :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = "S".charAt(0);
        try {
            this.tlqDynamic.delQueMessages(tlqObjDesc, arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteGroupMsgByMsgId(String string, ArrayList arrayList) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (arrayList == null || arrayList.size() == 0) {
            throw new TLQParameterException(" groupIdList :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = "G".charAt(0);
        try {
            this.tlqDynamic.delQueMessages(tlqObjDesc, arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Map getSingleMessages(String string, String string2, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" msgStatus :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "S", "", tlqObjDesc.objType, null, tlqPage);
            map = this.getDateSetMap(arrayList, string2, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getSingleMessages(String string, String string2, Properties properties, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" msgStatus :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            if (properties != null && properties.size() > 0) {
                ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "S", "", tlqObjDesc.objType, properties, tlqPage);
                map = this.getDateSetMap(arrayList, string2, tlqPage);
            } else {
                ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "S", "", tlqObjDesc.objType, null, tlqPage);
                map = this.getDateSetMap(arrayList, string2, tlqPage);
            }
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getGroupMessages(String string, String string2, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" msgStatus :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "G", "", tlqObjDesc.objType, null, tlqPage);
            map = this.getDateSetMap(arrayList, string2, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getGroupMessages(String string, String string2, Properties properties, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" msgStatus :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            if (properties != null && properties.size() > 0) {
                ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "G", "", tlqObjDesc.objType, properties, tlqPage);
                map = this.getDateSetMap(arrayList, string2, tlqPage);
            } else {
                ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "G", "", tlqObjDesc.objType, null, tlqPage);
                map = this.getDateSetMap(arrayList, string2, tlqPage);
            }
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getGroupSubMessages(String string, String string2, String string3, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" msgStatus :argument is empty! ");
        }
        if (string3 == null || "".equals(string3)) {
            throw new TLQParameterException(" groupId :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, string2, "D", string3, tlqObjDesc.objType, null, tlqPage);
            map = this.getDateSetMap(arrayList, string2, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getGroupLinkTable(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, "2", "V", "", tlqObjDesc.objType, null, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getLocalQueMsgNum(String string, int n, int n2) throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objType = "TQUE";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsgnum(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, n, n2, "L", tlqObjDesc.objType);
            ArrayList arrayList2 = (ArrayList)arrayList.get(2);
            map = this.getMap(arrayList2);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public void deleteLocalQueFirstMsg(String string, String string2) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" DelStatus :argument is empty! ");
        }
        String string3 = null;
        if (string2.equals("7")) {
            string3 = "7";
        } else if (string2.equals("1")) {
            string3 = "1";
        } else if (string2.equals("2")) {
            string3 = "2";
        } else if (string2.equals("4")) {
            string3 = "4";
        } else {
            throw new TLQParameterException(" DelStatus is not legal !");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)70;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        try {
            this.tlqDynamic.delQueMessages(tlqObjDesc, arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void loadLocalQue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)97;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void unLoadLocalQue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)100;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties getLocalQueSpareInfo(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objName = string;
        TlqPage tlqPage = new TlqPage();
        tlqPage.setReadNum("1");
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superMsg(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, "2", "S", "", tlqObjDesc.objType, null, tlqPage);
            properties = this.getQueSpareProperties(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public boolean isExistQue(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TLCQ";
        tlqObjDesc.obj1Name = this.obj1Name;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties statHistoryMsgNum(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        tlqObjDesc.objName = string;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.countTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(arrayList.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public Map getLocalQueListOfNormalType(int n) throws TLQParameterException, TLQRemoteException {
        if (n != 0 && n != 1) {
            throw new TLQParameterException(" getListCondition is not legal!");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objProps.put("listType", "2");
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, n);
            Integer n2 = (Integer)this.getFieldNameIndex(map).get("UsageType");
            ArrayList arrayList2 = (ArrayList)map.get("FieldValueList");
            for (int i = 0; i < arrayList2.size(); ++i) {
                ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
                String string = (String)arrayList3.get(n2);
                if ("0".equals(string)) continue;
                arrayList2.remove(i);
                --i;
            }
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Properties moveMsgInQueByMsgId(String string, ArrayList arrayList, int n) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" localQueueName :argument is empty! ");
        }
        if (arrayList == null || arrayList.size() == 0) {
            throw new TLQParameterException(" moveMsgIdList :argument is empty! ");
        }
        if (n < 0 || n > 9) {
            throw new TLQParameterException(" destPriority :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objProps.put("DestPriority", new Integer(n));
        tlqObjDesc.objProps.put("MoveMsgNum", new Integer(arrayList.size()));
        tlqObjDesc.objProps.put("DestPriority", new Integer(n));
        tlqObjDesc.objProps.put("DestQueName", new Integer(string));
        tlqObjDesc.objName = string;
        Properties properties = null;
        try {
            ArrayList arrayList2 = this.tlqDynamic.moveQueMessages(tlqObjDesc, arrayList);
            properties = this.getProperties((ArrayList)arrayList2.get(arrayList2.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public Properties moveMsgBetweenQue(String string, String string2) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" srcLocalQueueName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" destLocalQueueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        tlqObjDesc.objProps.put("DestQueName", string2);
        tlqObjDesc.objName = string;
        ArrayList arrayList = new ArrayList();
        Properties properties = null;
        try {
            ArrayList arrayList2 = this.tlqDynamic.moveQueMessages(tlqObjDesc, arrayList);
            properties = this.getProperties((ArrayList)arrayList2.get(arrayList2.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }
}

