/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.qcu;

import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.common.TlqPage;
import com.tongtech.tlq.admin.conf.Attribute;
import com.tongtech.tlq.admin.conf.PubSubBroker;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class TLQOptPubSubBroker
extends TLQOptBaseObj {
    public TLQOptPubSubBroker(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TPSB";
        this.objLevel = 2;
        this.objName = "pubsubBroker";
    }

    public PubSubBroker getPubSubBroker() throws TLQParameterException, TLQRemoteException {
        PubSubBroker pubSubBroker;
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)67;
        Attribute attribute = new Attribute("memPSBrokerStatus", "", "", "");
        try {
            pubSubBroker = this.tlqDynamic.getPubSubBroker(tlqObjDesc.obj1Name, attribute, tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return pubSubBroker;
    }

    public void setPubSubBroker(PubSubBroker pubSubBroker) throws TLQParameterException, TLQRemoteException {
        if (pubSubBroker == null) {
            throw new TLQParameterException(" pubSubBroker :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, pubSubBroker);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addPubSubBroker(PubSubBroker pubSubBroker) throws TLQParameterException, TLQRemoteException {
        if (pubSubBroker == null) {
            throw new TLQParameterException(" pubSubBroker :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objName = pubSubBroker.getBrokerName().getValue();
        tlqObjDesc.operResMode = (char)67;
        this.setTlqObjDesc(tlqObjDesc);
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, pubSubBroker);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deletePubSubBroker() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)68;
        tlqObjDesc.operResMode = (char)67;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void startPubSubBroker() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)83;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopPubSubBrokerByNormal() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)80;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopPubSubBrokerByAbort() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)81;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties getPubSubSupervisor() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(arrayList.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public Map getAllTopicAndSubscriber(TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superPubSub(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, tlqObjDesc.objName, 'A', tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getSubscriberByTopic(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" topicName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superPubSub(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, string, 'T', tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getTopicBySubscriber(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" subId :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superPubSub(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, string, 'S', tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public String queryPubSubBrokerState() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)66;
        tlqObjDesc.operResMode = (char)77;
        String string = "Stopped";
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            string = this.getProcessState(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return string;
    }

    public boolean isExistBroker() throws TLQParameterException, TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            Object var3_4 = null;
            return arrayList != null && arrayList.size() > 0;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public byte[] getSubscriberString(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" subId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.setOperResMode('M');
        byte[] byArray = null;
        TlqPage tlqPage = new TlqPage();
        try {
            ArrayList arrayList = this.tlqDynamic.superPubSub(this.tlqConnect.getLanguage(), tlqObjDesc.obj1Name, string, 's', tlqPage);
            byArray = (byte[])arrayList.get(1);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return byArray;
    }
}

