/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.qcu;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.common.TlqPage;
import com.tongtech.tlq.admin.conf.QCU;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TLQOptQCU
extends TLQOptBaseObj {
    public TLQOptQCU(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TQCU";
        this.objLevel = 1;
        this.objName = "";
    }

    public Map getQCUList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMapForProcess(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public QCU getQCU(String string) throws TLQParameterException, TLQRemoteException {
        QCU qCU;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            qCU = (QCU)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return qCU;
    }

    public void setQCU(QCU qCU) throws TLQParameterException, TLQRemoteException {
        if (qCU == null) {
            throw new TLQParameterException(" qcu :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = qCU.getQcuName().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, qCU);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addQCU(QCU qCU) throws TLQParameterException, TLQRemoteException {
        if (qCU == null) {
            throw new TLQParameterException(" qcu :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = qCU.getQcuName().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, qCU);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void loadQCU(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)97;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void unLoadQCU(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)100;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteQCUByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteQCUByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)70;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void startQCU(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)83;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopQCUByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)80;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopQCUByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)81;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties statQCUHistoryMsgNum(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        tlqObjDesc.objName = string;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.countTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(arrayList.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public Map getAppInstanceInQCU(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        Map map = null;
        try {
            TlqObjDesc tlqObjDesc = new TlqObjDesc();
            tlqObjDesc.setLanguageType(this.tlqConnect.getLanguage());
            tlqObjDesc.setObj1Name(string);
            tlqObjDesc.setObj1Type("TQCU");
            tlqObjDesc.setObjName(string);
            tlqObjDesc.setObjType("TAPI");
            tlqObjDesc.setObjLevel(2);
            tlqObjDesc.setOperResMode('M');
            ArrayList arrayList = this.tlqDynamic.superTlqObjs(tlqObjDesc, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getTLQProcessInQCU(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        Map map = null;
        try {
            TlqObjDesc tlqObjDesc = new TlqObjDesc();
            tlqObjDesc.setLanguageType(this.tlqConnect.getLanguage());
            tlqObjDesc.setObj1Name(string);
            tlqObjDesc.setObj1Type("TQCU");
            tlqObjDesc.setObjName(string);
            tlqObjDesc.setObjType("TPRC");
            tlqObjDesc.setObjLevel(2);
            tlqObjDesc.setOperResMode('M');
            ArrayList arrayList = this.tlqDynamic.superTlqObjs(tlqObjDesc, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getTransactionInQCU(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        Map map = null;
        try {
            TlqObjDesc tlqObjDesc = new TlqObjDesc();
            tlqObjDesc.setLanguageType(this.tlqConnect.getLanguage());
            tlqObjDesc.setObj1Name(string);
            tlqObjDesc.setObj1Type("TQCU");
            tlqObjDesc.setObjName(string);
            tlqObjDesc.setObjType("TTAN");
            tlqObjDesc.setObjLevel(2);
            tlqObjDesc.setOperResMode('M');
            ArrayList arrayList = this.tlqDynamic.superTlqObjs(tlqObjDesc, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Properties getQCUSpvInfo(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        tlqObjDesc.objName = string;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(2), (ArrayList)arrayList.get(3), (ArrayList)arrayList.get(4));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public void restoreQCUConfFile(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)82;
        tlqObjDesc.objName = string;
        tlqObjDesc.setOperResMode('C');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistQue(String string, String string2) throws TLQParameterException, TLQRemoteException {
        boolean bl;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" queName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = string2;
        tlqObjDesc.objType = "TQUE";
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        try {
            ArrayList arrayList;
            DataSet dataSet;
            ArrayList arrayList2 = this.tlqDynamic.superTlqObj(tlqObjDesc);
            bl = arrayList2.size() == 3 ? "1".equals((dataSet = (DataSet)(arrayList = (ArrayList)arrayList2.get(2)).get(0)).getValue()) : false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return bl;
    }

    public boolean isExistQcu(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 1;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TQCU";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new TLQRemoteException(exception);
        }
    }

    public int getQueMsgNum(String string, String string2, Map map) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" queName :argument is empty! ");
        }
        ArrayList arrayList = new ArrayList(map.keySet());
        ArrayList arrayList2 = new ArrayList(map.values());
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = string2;
        tlqObjDesc.objType = "TQUE";
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.operResMode = this.getResourceType();
        int n = 0;
        try {
            ArrayList arrayList3 = this.tlqDynamic.superspecialQueMsgnum(this.tlqConnect.getLanguage(), string, string2, arrayList, arrayList2, tlqObjDesc.objType);
            ArrayList arrayList4 = (ArrayList)arrayList3.get(2);
            DataSet dataSet = (DataSet)arrayList4.get(0);
            String string3 = dataSet.getValue();
            n = Integer.parseInt(string3);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return n;
    }

    public String queryQCUState(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)66;
        tlqObjDesc.objName = string;
        tlqObjDesc.setOperResMode('M');
        String string2 = "Stopped";
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            string2 = this.getProcessState(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return string2;
    }

    public Map getTLQProcessList2InQCU(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.objType = "TPRC";
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = "";
        tlqObjDesc.objProps.put("listType", "2");
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, 0);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getTopicBrokerList(String string, int n) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objType = "TCHL";
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.operResMode = this.getResourceType();
        tlqObjDesc.setLanguageType(this.tlqConnect.getLanguage());
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            tlqObjDesc.objProps.put("listType", "2");
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, n);
        }
        catch (TlqConfException tlqConfException) {
            tlqConfException.printStackTrace();
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public Map getDeadQue(String string) throws TLQParameterException, TLQRemoteException {
        Object object;
        ArrayList arrayList;
        ArrayList arrayList2;
        if (string == null) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("", "TLQ.SYS.DEAD");
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TLCQ";
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.objProps.put("listType", "2");
        Map map = null;
        try {
            arrayList2 = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList2, 1);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        arrayList2 = (ArrayList)map.get("FieldValueList");
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList = (ArrayList)arrayList2.get(i);
            String string2 = (String)arrayList.get(8);
            object = (String)arrayList.get(0);
            if (!string2.equals("2")) continue;
            hashMap.put((String)object, (String)object);
        }
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TVTQ";
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.objProps.put("listType", "2");
        Map map2 = null;
        try {
            arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map2 = this.getList2Map(arrayList, 0);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        arrayList = (ArrayList)map2.get("FieldValueList");
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (ArrayList)arrayList.get(i);
            String string3 = (String)((ArrayList)object).get(0);
            String string4 = (String)((ArrayList)object).get(5);
            if (!hashMap.containsValue(string4)) continue;
            hashMap.put(string3, string3);
        }
        return hashMap;
    }

    public Map useCurrentDeadQueList(String string, String string2) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" qcuName :argument is empty! ");
        }
        if (string2 == null || "".equals(string2)) {
            throw new TLQParameterException(" deadQueName :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = string2;
        tlqObjDesc.objType = "TQUE";
        tlqObjDesc.obj1Name = string;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.addProp("OPER_lIST", "L");
        Map map = null;
        try {
            tlqObjDesc.objProps.put("listType", "2");
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getList2Map(arrayList, 0);
        }
        catch (TlqConfException tlqConfException) {
            tlqConfException.printStackTrace();
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }
}

