/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.api.qcu;

import com.tongtech.tlq.admin.common.DataSet;
import com.tongtech.tlq.admin.common.TlqObjDesc;
import com.tongtech.tlq.admin.common.TlqPage;
import com.tongtech.tlq.admin.conf.SendProcess;
import com.tongtech.tlq.admin.conf.TlqConfException;
import com.tongtech.tlq.admin.dynamic.manage.TlqDynamic;
import com.tongtech.tlq.admin.remote.api.TLQConnect;
import com.tongtech.tlq.admin.remote.api.TLQOptBaseObj;
import com.tongtech.tlq.admin.remote.api.TLQParameterException;
import com.tongtech.tlq.admin.remote.api.TLQRemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class TLQOptSendProcess
extends TLQOptBaseObj {
    public TLQOptSendProcess(TLQConnect tLQConnect, TlqDynamic tlqDynamic) {
        super(tLQConnect, tlqDynamic);
        this.objType = "TSDP";
        this.objLevel = 2;
        this.objName = "";
    }

    public Map getSendProcessList() throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = "";
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            map = this.getListMapForProcess(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }

    public SendProcess getSendProcess(String string) throws TLQParameterException, TLQRemoteException {
        SendProcess sendProcess;
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        try {
            sendProcess = (SendProcess)this.tlqDynamic.getTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return sendProcess;
    }

    public void setSendProcess(SendProcess sendProcess) throws TLQParameterException, TLQRemoteException {
        if (sendProcess == null) {
            throw new TLQParameterException(" sendProcess :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = sendProcess.getSendProcID().getValue();
        try {
            this.tlqDynamic.modifyTlqObj(tlqObjDesc, sendProcess);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void addSendProcess(SendProcess sendProcess) throws TLQParameterException, TLQRemoteException {
        if (sendProcess == null) {
            throw new TLQParameterException(" sendProcess :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = sendProcess.getSendProcID().getValue();
        try {
            this.tlqDynamic.addTlqObj(tlqObjDesc, sendProcess);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteSendProcessByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)68;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void deleteSendProcessByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)70;
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void startSendProcess(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)83;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopSendProcessByNormal(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)80;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void stopSendProcessByAbort(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)81;
        tlqObjDesc.setOperResMode('M');
        try {
            this.tlqDynamic.controlTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Properties getSendProcessSpvInfo(String string) throws TLQRemoteException {
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        tlqObjDesc.objName = string;
        Properties properties = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            properties = this.getProperties((ArrayList)arrayList.get(arrayList.size() - 1));
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return properties;
    }

    public String querySendProcessState(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objOpt = (char)66;
        tlqObjDesc.objName = string;
        tlqObjDesc.setOperResMode('M');
        String string2 = "Stopped";
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObj(tlqObjDesc);
            string2 = this.getProcessState(arrayList);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return string2;
    }

    public void loadSendProcess(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)97;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public void unLoadSendProcess(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.objName = string;
        tlqObjDesc.objOpt = (char)100;
        try {
            this.tlqDynamic.loadOrUnloadTlqObj(tlqObjDesc);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public boolean isExistSendProcess(String string) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendProcessId :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        tlqObjDesc.objLevel = 2;
        tlqObjDesc.objName = "";
        tlqObjDesc.objType = "TSDP";
        tlqObjDesc.obj1Name = this.obj1Name;
        tlqObjDesc.obj1Type = "TQCU";
        tlqObjDesc.operResMode = (char)67;
        try {
            ArrayList arrayList = this.tlqDynamic.listTlqObj(tlqObjDesc);
            DataSet dataSet = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                dataSet = (DataSet)arrayList.get(i);
                if (!dataSet.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
    }

    public Map getSendProcessSpvInfo(String string, TlqPage tlqPage) throws TLQParameterException, TLQRemoteException {
        if (string == null || "".equals(string)) {
            throw new TLQParameterException(" sendQueueName :argument is empty! ");
        }
        if (tlqPage == null) {
            throw new TLQParameterException(" tlqPage :argument is empty! ");
        }
        TlqObjDesc tlqObjDesc = new TlqObjDesc();
        this.setTlqObjDesc(tlqObjDesc);
        tlqObjDesc.operResMode = (char)77;
        tlqObjDesc.objName = string;
        Map map = null;
        try {
            ArrayList arrayList = this.tlqDynamic.superTlqObjs(tlqObjDesc, tlqPage);
            map = this.getDateSetMap(arrayList, null, tlqPage);
        }
        catch (TlqConfException tlqConfException) {
            throw new TLQRemoteException(tlqConfException);
        }
        return map;
    }
}

