/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.admin.remote.jmx;

import com.tongtech.tlq.admin.remote.jmx.TLQParameterException;
import com.tongtech.tlq.admin.remote.jmx.TLQRemoteException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public class TLQConnector
implements Serializable,
Cloneable {
    private String ip;
    private int port;
    private char language = (char)69;
    private int isDebug = 0;
    private int recvDataTmOut = 10;
    private Locale locale = Locale.ENGLISH;
    private String hash;
    private Map mbeans;
    private char resourceType = (char)77;
    private int connTmOut = 10;
    private boolean allowAutoReConn = false;
    private int connTimes = 10;
    private long interval = 1000L;
    public static final int DEBUG_YES = 1;
    public static final int DEBUG_NO = 0;

    protected TLQConnector clone() {
        try {
            return (TLQConnector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public TLQConnector(String string, int n) {
        this.ip = string;
        this.port = n;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String string) {
        this.hash = string;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getIsDebug() {
        return this.isDebug;
    }

    public void setIsDebug(int n) {
        this.isDebug = n;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws TLQParameterException {
        if (locale == null) {
            throw new TLQParameterException("Parameter: locale is illegal!");
        }
        if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
            this.language = (char)69;
        } else if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.toString().contains("zh_")) {
            this.language = (char)90;
        } else {
            throw new TLQParameterException("Parameter\uff1alocale is not in english or chinese!");
        }
        this.locale = locale;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getRecvDataTmOut() {
        return this.recvDataTmOut;
    }

    public void setRecvDataTmOut(int n) {
        this.recvDataTmOut = n;
    }

    public int getConnTmOut() {
        return this.connTmOut;
    }

    public void setConnTmOut(int n) throws TLQParameterException {
        if (n < 0) {
            throw new TLQParameterException("Parameter: connTmOut is illegal!");
        }
        this.connTmOut = n;
    }

    public Map getMbeans() {
        return this.mbeans;
    }

    public void setMbeans(Map map) {
        this.mbeans = map;
    }

    public char getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(char c) {
        this.resourceType = c;
    }

    public void setReConn(boolean bl, int n, long l) throws TLQRemoteException {
        if (bl && (n < -1 || l < 10L)) {
            throw new TLQRemoteException("connTimes[" + n + "] or interval[" + l + "] is invalid!", 4000, 0);
        }
        this.allowAutoReConn = bl;
        this.connTimes = n;
        this.interval = l;
    }

    public int getConnTimes() {
        return this.connTimes;
    }

    public long getInterval() {
        return this.interval;
    }

    public boolean isPermit() {
        return this.allowAutoReConn;
    }
}

