/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import java.io.Flushable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Component;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.reporter.BufferNextMessage;
import zipkin.reporter.ByteBounded;
import zipkin.reporter.ByteBoundedQueue;
import zipkin.reporter.ByteBoundedQueueByDisruptor;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoder;
import zipkin.reporter.Reporter;
import zipkin.reporter.ReporterMetrics;
import zipkin.reporter.Sender;

public abstract class AsyncReporter<S>
implements Reporter<S>,
Flushable,
Component {
    public static AsyncReporter<Span> create(Sender sender) {
        return new Builder(sender).build();
    }

    public static Builder builder(Sender sender) {
        return new Builder(sender);
    }

    @Override
    public abstract void flush();

    public abstract void close();

    static final class BoundedAsyncReporter<S>
    extends AsyncReporter<S> {
        static final Logger logger = Logger.getLogger(BoundedAsyncReporter.class.getName());
        final AtomicBoolean closed = new AtomicBoolean(false);
        final Encoder<S> encoder;
        final ByteBounded pending;
        final Sender sender;
        final int messageMaxBytes;
        final long messageTimeoutNanos;
        final long closeTimeoutNanos;
        final CountDownLatch close;
        final ReporterMetrics metrics;

        BoundedAsyncReporter(Builder builder, Encoder<S> encoder) {
            boolean byDisruptor = Boolean.getBoolean("zipkin.reporter.async.type");
            this.pending = byDisruptor ? new ByteBoundedQueueByDisruptor(builder.queuedMaxSpans, builder.queuedMaxBytes) : new ByteBoundedQueue(builder.queuedMaxSpans, builder.queuedMaxBytes);
            this.sender = builder.sender;
            this.messageMaxBytes = builder.messageMaxBytes;
            this.messageTimeoutNanos = builder.messageTimeoutNanos;
            this.closeTimeoutNanos = builder.closeTimeoutNanos;
            this.close = new CountDownLatch(builder.messageTimeoutNanos > 0L ? 1 : 0);
            this.metrics = builder.metrics;
            this.encoder = encoder;
        }

        @Override
        public void report(S span) {
            Util.checkNotNull(span, (String)"span");
            this.metrics.incrementSpans(1);
            byte[] next = this.encoder.encode(span);
            int messageSizeOfNextSpan = this.sender.messageSizeInBytes(Collections.singletonList(next));
            this.metrics.incrementSpanBytes(next.length);
            long st = System.currentTimeMillis();
            if (this.closed.get() || messageSizeOfNextSpan > this.messageMaxBytes || !this.pending.offer(next)) {
                this.metrics.incrementSpansDropped(1);
            }
        }

        @Override
        public void report(S[] span) {
            Util.checkNotNull(span, (String)"span");
            this.metrics.incrementSpans(span.length);
            byte[][] next = new byte[span.length][];
            int i = 0;
            while (i < span.length) {
                next[i] = this.encoder.encode(span[i]);
                ++i;
            }
            if (this.closed.get() || !this.pending.offer(next)) {
                this.metrics.incrementSpansDropped(span.length);
                logger.warning("AsyncReporter:list is full and offer trace_span lost " + span.length + " spans");
            }
        }

        @Override
        public final void flush() {
            this.flush(new BufferNextMessage(this.sender, this.messageMaxBytes, 0L));
        }

        void flush(BufferNextMessage bundler) {
            block4: {
                if (this.closed.get()) {
                    throw new IllegalStateException("closed");
                }
                this.pending.drainTo(bundler, bundler.remainingNanos());
                this.metrics.updateQueuedSpans(this.pending.count());
                this.metrics.updateQueuedBytes(this.pending.sizeInBytes());
                if (!bundler.isReady() && !this.closed.get()) {
                    return;
                }
                this.metrics.incrementMessages();
                this.metrics.incrementMessageBytes(bundler.sizeInBytes());
                List<byte[]> nextMessage = bundler.drain();
                Callback failureCallback = this.sendSpansCallback(nextMessage.size());
                try {
                    this.sender.sendSpans(nextMessage, failureCallback);
                }
                catch (RuntimeException e) {
                    failureCallback.onError(e);
                    if (!(e instanceof IllegalStateException)) break block4;
                    throw e;
                }
            }
        }

        public Component.CheckResult check() {
            return this.sender.check();
        }

        @Override
        public void close() {
            int count;
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (!this.close.await(this.closeTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    logger.warning("Timed out waiting for in-flight spans to send");
                }
            }
            catch (InterruptedException e) {
                logger.warning("Interrupted waiting for in-flight spans to send");
                Thread.currentThread().interrupt();
            }
            if ((count = this.pending.clear()) > 0) {
                this.metrics.incrementSpansDropped(count);
                logger.warning("Dropped " + count + " spans due to AsyncReporter.close()");
            }
        }

        Callback sendSpansCallback(final int count) {
            return new Callback(){

                @Override
                public void onComplete() {
                }

                @Override
                public void onError(Throwable t) {
                    metrics.incrementMessagesDropped(t);
                    metrics.incrementSpansDropped(count);
                    logger.log(Level.WARNING, String.format("Dropped %s spans due to %s(%s)", count, t.getClass().getSimpleName(), t.getMessage() == null ? "" : t.getMessage()), t);
                }
            };
        }

        public String toString() {
            return "AsyncReporter(" + this.sender + ")";
        }
    }

    public static final class Builder {
        final Sender sender;
        ReporterMetrics metrics = ReporterMetrics.NOOP_METRICS;
        int messageMaxBytes;
        long messageTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        long closeTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        int queuedMaxSpans = 10000;
        int queuedMaxBytes = Builder.onePercentOfMemory();

        static int onePercentOfMemory() {
            long result = (long)((double)Runtime.getRuntime().totalMemory() * 0.01);
            return (int)Math.max(Math.min(Integer.MAX_VALUE, result), Integer.MIN_VALUE);
        }

        Builder(Sender sender) {
            this.sender = (Sender)Util.checkNotNull((Object)sender, (String)"sender");
            this.messageMaxBytes = sender.messageMaxBytes();
        }

        public Builder metrics(ReporterMetrics metrics) {
            this.metrics = (ReporterMetrics)Util.checkNotNull((Object)metrics, (String)"metrics");
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            Util.checkArgument((messageMaxBytes >= 0 ? 1 : 0) != 0, (String)"messageMaxBytes < 0: %s", (Object[])new Object[]{messageMaxBytes});
            this.messageMaxBytes = Math.min(messageMaxBytes, this.sender.messageMaxBytes());
            return this;
        }

        public Builder messageTimeout(long timeout, TimeUnit unit) {
            Util.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"messageTimeout < 0: %s", (Object[])new Object[]{timeout});
            this.messageTimeoutNanos = unit.toNanos((Long)Util.checkNotNull((Object)timeout, (String)"messageTimeout"));
            return this;
        }

        public Builder closeTimeout(long timeout, TimeUnit unit) {
            Util.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"closeTimeout < 0: %s", (Object[])new Object[]{timeout});
            this.closeTimeoutNanos = unit.toNanos((Long)Util.checkNotNull((Object)timeout, (String)"closeTimeout"));
            return this;
        }

        public Builder queuedMaxSpans(int queuedMaxSpans) {
            this.queuedMaxSpans = queuedMaxSpans;
            return this;
        }

        public Builder queuedMaxBytes(int queuedMaxBytes) {
            this.queuedMaxBytes = queuedMaxBytes;
            return this;
        }

        public AsyncReporter<Span> build() {
            switch (this.sender.encoding()) {
                case JSON: {
                    return this.build(Encoder.JSON);
                }
                case THRIFT: {
                    return this.build(Encoder.THRIFT);
                }
            }
            throw new UnsupportedOperationException(this.sender.encoding().name());
        }

        public <S> AsyncReporter<S> build(Encoder<S> encoder) {
            Util.checkNotNull(encoder, (String)"encoder");
            Util.checkArgument((encoder.encoding() == this.sender.encoding() ? 1 : 0) != 0, (String)"Encoder.encoding() %s != Sender.encoding() %s", (Object[])new Object[]{encoder.encoding(), this.sender.encoding()});
            BoundedAsyncReporter<S> result = new BoundedAsyncReporter<S>(this, encoder);
            if (this.messageTimeoutNanos > 0L) {
                BufferNextMessage consumer = new BufferNextMessage(this.sender, this.messageMaxBytes, this.messageTimeoutNanos);
                Thread flushThread = new Thread(() -> Builder.lambda$0(consumer, result), "AsyncReporter(" + this.sender + ")");
                flushThread.setDaemon(true);
                flushThread.start();
            }
            return result;
        }

        /*
         * Unable to fully structure code
         */
        private static /* synthetic */ void lambda$0(BufferNextMessage var0, BoundedAsyncReporter var1_1) {
            try {
                while (!var1_1.closed.get()) {
                    var1_1.flush(var0);
                }
            }
            finally {
                ** for (next : var0.drain())
            }
lbl-1000:
            // 1 sources

            {
                var1_1.pending.offer(next);
                continue;
            }
lbl11:
            // 1 sources

            var1_1.close.countDown();
        }
    }
}

