/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import java.util.Arrays;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.reporter.ByteBounded;

final class ByteBoundedQueue
implements ByteBounded {
    private static final Logger log = LoggerFactory.getLogger(ByteBoundedQueue.class);
    final ReentrantLock lock = new ReentrantLock(false);
    final Condition available = this.lock.newCondition();
    final int maxSize;
    final int maxBytes;
    final byte[][] elements;
    int count;
    int sizeInBytes;
    int writePos;
    int readPos;

    ByteBoundedQueue(int maxSize, int maxBytes) {
        this.elements = new byte[maxSize][];
        this.maxSize = maxSize;
        this.maxBytes = maxBytes;
    }

    @Override
    public boolean offer(byte[] next) {
        if (this.count == this.elements.length) {
            return false;
        }
        if (this.count > this.elements.length) {
            this.clear();
        }
        if (this.sizeInBytes + next.length > this.maxBytes) {
            return false;
        }
        this.lock.lock();
        try {
            this.elements[this.writePos++] = next;
            if (this.writePos == this.elements.length) {
                this.writePos = 0;
            }
            ++this.count;
            this.sizeInBytes += next.length;
            this.available.signal();
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(byte[][] next) {
        if (this.count > this.elements.length) {
            log.warn("ByteBoundedQueue:list is full and trace_span lost " + this.count + " spans");
            this.clear();
        }
        if (this.count + next.length > this.elements.length) {
            return false;
        }
        this.lock.lock();
        try {
            int i = 0;
            while (i < next.length) {
                this.elements[this.writePos++] = next[i];
                if (this.writePos == this.elements.length) {
                    this.writePos = 0;
                }
                ++this.count;
                this.sizeInBytes += next[i].length;
                ++i;
            }
            this.available.signal();
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int drainTo(Consumer consumer, long nanosTimeout) {
        try {
            this.lock.lockInterruptibly();
            try {
                long nanosLeft = nanosTimeout;
                while (true) {
                    if (this.count != 0) {
                        int n = this.doDrain(consumer);
                        return n;
                    }
                    if (nanosLeft <= 0L) {
                        return 0;
                    }
                    nanosLeft = this.available.awaitNanos(nanosLeft);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    @Override
    public int clear() {
        this.lock.lock();
        try {
            int result = this.count;
            this.writePos = 0;
            this.readPos = 0;
            this.sizeInBytes = 0;
            this.count = 0;
            Arrays.fill((Object[])this.elements, null);
            int n = result;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    int doDrain(Consumer consumer) {
        int drainedCount = 0;
        int drainedSizeInBytes = 0;
        while (drainedCount < this.count) {
            byte[] next = this.elements[this.readPos];
            if (next == null || !consumer.accept(next)) break;
            ++drainedCount;
            drainedSizeInBytes += next.length;
            this.elements[this.readPos] = null;
            if (++this.readPos != this.elements.length) continue;
            this.readPos = 0;
        }
        this.count -= drainedCount;
        this.sizeInBytes -= drainedSizeInBytes;
        return drainedCount;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    static interface Consumer {
        public boolean accept(byte[] var1);
    }
}

