/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import zipkin.reporter.ByteBounded;
import zipkin.reporter.ByteBoundedQueue;
import zipkin.reporter.Sleeping0WaitStrategy;

final class ByteBoundedQueueByDisruptor
implements ByteBounded {
    final int maxSize;
    final int maxBytes;
    final byte[][] elements;
    int count;
    int sizeInBytes;
    private static int RING_SIZE = 8192;
    private static AtomicInteger ringSize = new AtomicInteger(0);
    static RingBuffer<ObjectBox> ringBuffer;
    Publisher p = new Publisher();
    private static int bqmax;
    private static ConcurrentLinkedQueue<byte[]> bq;
    private static AtomicInteger bqSize;

    static {
        bqmax = RING_SIZE * 10;
        String strategystr = System.getProperty("zipkin.reporter.disruptor.waitstrategy", "sleeping0");
        Object strategy = "sleeping0".equals(strategystr) ? new Sleeping0WaitStrategy() : ("sleeping".equals(strategystr) ? new SleepingWaitStrategy() : ("block".equals(strategystr) ? new BlockingWaitStrategy() : new Sleeping0WaitStrategy()));
        Disruptor disruptor = new Disruptor(ObjectBox.FACTORY, RING_SIZE, (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.MULTI, (WaitStrategy)strategy);
        disruptor.handleEventsWith(new EventHandler[]{new ConsumerI()});
        ringBuffer = disruptor.getRingBuffer();
        disruptor.start();
        if (System.getProperty("zipkin.sendqueue.size") != null) {
            try {
                bqmax = Integer.valueOf(System.getProperty("zipkin.sendqueue.size"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        bq = new ConcurrentLinkedQueue();
        bqSize = new AtomicInteger(0);
    }

    ByteBoundedQueueByDisruptor(int maxSize, int maxBytes) {
        this.elements = new byte[maxSize][];
        this.maxSize = maxSize;
        this.maxBytes = maxBytes;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public boolean offer(byte[] next) {
        if (ringSize.incrementAndGet() < RING_SIZE) {
            ringBuffer.publishEvent((EventTranslatorOneArg)this.p, (Object)next);
            return true;
        }
        ringSize.decrementAndGet();
        return false;
    }

    @Override
    public boolean offer(byte[][] next) {
        if (ringSize.addAndGet(next.length) < RING_SIZE) {
            ringBuffer.publishEvents((EventTranslatorOneArg)this.p, (Object[])next);
            return true;
        }
        ringSize.addAndGet(-1 * next.length);
        return false;
    }

    @Override
    public int drainTo(ByteBoundedQueue.Consumer consumer, long nanosTimeout) {
        int size = 0;
        if (bq.isEmpty()) {
            try {
                Thread.sleep(nanosTimeout / 1000000L, (int)nanosTimeout % 1000000);
            }
            catch (Exception exception) {}
        }
        while (!bq.isEmpty() && size++ < RING_SIZE - 1) {
            try {
                consumer.accept(bq.poll());
                bqSize.getAndDecrement();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bqSize.get();
    }

    @Override
    public int clear() {
        int size = bqSize.get();
        bq.clear();
        bqSize.set(0);
        return size;
    }

    static class ConsumerI
    implements EventHandler<ObjectBox> {
        ConsumerI() {
        }

        public void onEvent(ObjectBox event, long sequence, boolean endOfBatch) throws Exception {
            ringSize.decrementAndGet();
            if (bqSize.get() >= bqmax) {
                bq.clear();
                bqSize.set(0);
            }
            bq.add(event.next);
            bqSize.getAndIncrement();
        }
    }

    private static class ObjectBox {
        byte[] next;
        private static final EventFactory<ObjectBox> FACTORY = new EventFactory<ObjectBox>(){

            public ObjectBox newInstance() {
                return new ObjectBox();
            }
        };

        private ObjectBox() {
        }

        public void setNextBytes(byte[] arg2) {
            this.next = arg2;
        }
    }

    static class Publisher
    implements EventTranslatorOneArg<ObjectBox, byte[]> {
        Publisher() {
        }

        public void translateTo(ObjectBox arg0, long sequence, byte[] next) {
            arg0.setNextBytes(next);
        }
    }
}

