/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import zipkin.Span;
import zipkin.internal.Util;
import zipkin.reporter.Encoder;

public interface Reporter<S> {
    public static final Reporter<Span> NOOP = new Reporter<Span>(){

        @Override
        public void report(Span span) {
        }

        @Override
        public void report(Span[] span) {
        }
    };
    public static final Reporter<Span> CONSOLE = new Reporter<Span>(){

        @Override
        public void report(Span span) {
            System.out.println(new String(Encoder.JSON.encode(span), Util.UTF_8));
        }

        @Override
        public void report(Span[] span) {
            if (span == null) {
                return;
            }
            int i = 0;
            while (i < span.length) {
                System.out.println(new String(Encoder.JSON.encode(span[i]), Util.UTF_8));
                ++i;
            }
        }
    };

    public void report(S var1);

    public void report(S[] var1);
}

