/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.locks.LockSupport;

public final class Sleeping0WaitStrategy
implements WaitStrategy {
    private static final int DEFAULT_RETRIES = 20;
    private final int retries;

    public Sleeping0WaitStrategy() {
        this(20);
    }

    public Sleeping0WaitStrategy(int retries) {
        this.retries = retries;
    }

    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = this.retries;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            counter = this.applyWaitMethod(barrier, counter);
        }
        return availableSequence;
    }

    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int counter) throws AlertException {
        barrier.checkAlert();
        if (counter > 10) {
            --counter;
        } else if (counter > 0) {
            --counter;
            Thread.yield();
        } else {
            LockSupport.parkNanos(100000L);
        }
        return counter;
    }
}

