/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ItemClassViewSaveOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map cacheMap;
        Object addNode;
        super.beginOperationTransaction(e);
        DynamicObject[] dynObjs = e.getDataEntities();
        if (CommonUtils.isNull((Object)dynObjs)) {
            return;
        }
        String nodeCache = this.getOption().getVariableValue("_itemclass_option_params_", "");
        if (!StringUtils.isBlank((CharSequence)nodeCache) && !StringUtils.isBlank(addNode = (cacheMap = (Map)SerializationUtils.fromJsonString((String)nodeCache, Map.class)).get("_addNode_"))) {
            List addNodeList = (List)SerializationUtils.fromJsonString((String)addNode.toString(), List.class);
            this.batchAddItemClass(addNodeList);
            e.setDataEntities(new DynamicObject[0]);
        }
    }

    private void batchAddItemClass(List<Map<String, Object>> addNodeList) {
        if (CommonUtils.isNull(addNodeList)) {
            return;
        }
        ArrayList<DynamicObject> itemClassDynObjList = new ArrayList<DynamicObject>(30);
        int size = addNodeList.size();
        long[] pkIds = DB.genLongIds((String)"t_mdr_itemclass", (int)size);
        int index = 0;
        HashMap<Long, DynamicObject> parentIdDynObjMap = new HashMap<Long, DynamicObject>(size);
        HashMap<Long, List<Long>> itemClassIdMap = new HashMap<Long, List<Long>>(30);
        ArrayList<Long> existItemClassIdList = new ArrayList<Long>(16);
        for (Map<String, Object> nodeMap : addNodeList) {
            DynamicObject itemClassDynObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_class");
            long itemClassId = pkIds[index];
            itemClassDynObj.set("id", (Object)itemClassId);
            this.setItemClassDynObj(itemClassDynObj, nodeMap);
            long parentMaterialId = CommonUtils.stringToLong((Object)nodeMap.get("parentid").toString().split("_")[0]);
            if (parentMaterialId > 0L) {
                DynamicObject parentItemClassDynObj = (DynamicObject)parentIdDynObjMap.get(parentMaterialId);
                long parentItemClassId = parentMaterialId;
                if (parentItemClassDynObj != null) {
                    parentItemClassId = parentItemClassDynObj.getLong("id");
                } else {
                    existItemClassIdList.add(parentMaterialId);
                }
                if (!itemClassIdMap.containsKey(parentItemClassId)) {
                    ArrayList<Long> itemClassIdList = new ArrayList<Long>(1);
                    itemClassIdList.add(itemClassId);
                    itemClassIdMap.put(parentItemClassId, itemClassIdList);
                } else {
                    ((List)itemClassIdMap.get(parentItemClassId)).add(itemClassId);
                }
            }
            long materialId = CommonUtils.stringToLong((Object)nodeMap.get("id"));
            parentIdDynObjMap.put(materialId, itemClassDynObj);
            itemClassDynObjList.add(itemClassDynObj);
            ++index;
        }
        OperationResult result = this.saveItemClassDynObj(itemClassDynObjList, parentIdDynObjMap);
        if (result != null) {
            this.operationResult.setBillCount(0);
            this.operationResult.mergeOperateResult(result);
            this.updateItemClassIsleaf(result, itemClassIdMap, existItemClassIdList);
        }
    }

    private void setItemClassDynObj(DynamicObject itemClassDynObj, Map<String, Object> nodeMap) {
        itemClassDynObj.set("number", nodeMap.get("number"));
        itemClassDynObj.set("name", nodeMap.get("text"));
        itemClassDynObj.set("status", (Object)"C");
        itemClassDynObj.set("enable", (Object)"1");
        itemClassDynObj.set(String.join((CharSequence)"_", "standard", "id"), nodeMap.get("standard"));
        itemClassDynObj.set("level", (Object)(Integer.parseInt(nodeMap.get("level").toString()) - 1));
        itemClassDynObj.set(String.join((CharSequence)"_", "creator", "id"), (Object)RequestContext.get().getCurrUserId());
        itemClassDynObj.set("createtime", (Object)TimeServiceHelper.now());
        itemClassDynObj.set("materialclassid", (Object)nodeMap.get("id").toString().split("_")[0]);
        itemClassDynObj.set(String.join((CharSequence)"_", "parent", "id"), (Object)nodeMap.get("parentid").toString().split("_")[0]);
    }

    private OperationResult saveItemClassDynObj(List<DynamicObject> itemClassDynObjList, Map<Long, DynamicObject> parentIdDynObjMap) {
        if (CommonUtils.isNull(itemClassDynObjList)) {
            return null;
        }
        int size = itemClassDynObjList.size();
        for (DynamicObject dynObj : itemClassDynObjList) {
            long parentId = dynObj.getLong(String.join((CharSequence)"_", "parent", "id"));
            DynamicObject parentItemClassDynObj = parentIdDynObjMap.get(parentId);
            if (parentItemClassDynObj == null) continue;
            dynObj.set("parent", (Object)parentItemClassDynObj);
        }
        Object[] dynObjs = itemClassDynObjList.toArray(new DynamicObject[size]);
        BusinessDataServiceHelper.loadRefence((Object[])dynObjs, (IDataEntityType)dynObjs[0].getDynamicObjectType());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        return SaveServiceHelper.saveOperate((String)"mdr_item_class", (DynamicObject[])dynObjs, (OperateOption)option);
    }

    private void updateItemClassIsleaf(OperationResult result, Map<Long, List<Long>> itemClassIdMap, List<Long> existItemClassIdList) {
        SqlBuilder sqlBuilder;
        ArrayList<Long> successItemClassIdList = new ArrayList<Long>(30);
        List successPkIdList = result.getSuccessPkIds();
        ArrayList failItemClassIdList = new ArrayList(30);
        for (Map.Entry<Long, List<Long>> entry : itemClassIdMap.entrySet()) {
            List saveFailPkIdList;
            List saveSuccessPkIdList = entry.getValue().stream().filter(obj -> successPkIdList.contains(obj)).collect(Collectors.toList());
            long parentItemClassId = entry.getKey();
            if (!CommonUtils.isNull(saveSuccessPkIdList)) {
                successItemClassIdList.add(parentItemClassId);
            }
            if (existItemClassIdList.contains(parentItemClassId) || CommonUtils.isNull(saveFailPkIdList = entry.getValue().stream().filter(obj -> successPkIdList.contains(obj) && !successPkIdList.contains(parentItemClassId)).collect(Collectors.toList()))) continue;
            failItemClassIdList.addAll(entry.getValue());
        }
        if (!CommonUtils.isNull(successItemClassIdList)) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("UPDATE T_MDR_ITEMCLASS SET FISLEAF='0' WHERE ", new Object[0]);
            sqlBuilder.appendIn("FID", successItemClassIdList.toArray());
            DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
        }
        if (!CommonUtils.isNull(failItemClassIdList)) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("UPDATE T_MDR_ITEMCLASS SET FPARENTID=0,FLEVEL=1 WHERE", new Object[0]);
            sqlBuilder.appendIn("FID", failItemClassIdList.toArray());
            DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
        }
    }
}

