/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseItemUtils {
    private static final Log logger = LogFactory.getLog(ExpenseItemUtils.class);
    public static final String FORM_ID = "formId";
    public static final String FORM_NAME = "formName";
    public static final String SHOW_TYPE = "showType";
    public static final String NEED_CALLBACK = "needCallBack";
    public static final String FORM_TYPE = "formType";
    public static final String WEB_LIST_TEMPLATE = "bos_list";
    public static final String WEB_TREE_LIST_TEMPLATE = "bos_treelist";
    public static final String MOBILE_ER_LIST_BILL_TEMPLATE = "er_billtemplate";
    public static final String MOBILE_ER_LIST_BASE_TEMPLATE = "er_basetemplate";
    public static final String TARGET_KEY = "_submaintab_";
    public static final String CUSTOM_PARAM = "customParam";

    private ExpenseItemUtils() {
    }

    public static void showPage(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_ID) == null) {
            return;
        }
        String formType = "1";
        if (paramMap.get(FORM_TYPE) != null) {
            formType = (String)paramMap.get(FORM_TYPE);
        }
        switch (formType) {
            case "1": {
                ExpenseItemUtils.showWebForm(paramMap, formPlugin);
                break;
            }
            case "7": {
                ExpenseItemUtils.showWebBase(paramMap, formPlugin);
                break;
            }
        }
    }

    public static void showWebForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ExpenseItemUtils.openPage(showParameter, paramMap, formPlugin);
    }

    public static void showWebBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ExpenseItemUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    private static void openPage(FormShowParameter showParameter, Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_NAME) != null) {
            showParameter.setCaption((String)paramMap.get(FORM_NAME));
        }
        Boolean needCallBack = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(NEED_CALLBACK), (Object)Boolean.FALSE);
        String formId = (String)paramMap.get(FORM_ID);
        if (needCallBack.booleanValue()) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formId));
        }
        if (paramMap.get(CUSTOM_PARAM) != null) {
            Map customParam = (Map)paramMap.get(CUSTOM_PARAM);
            showParameter.getCustomParams().putAll(customParam);
        }
        showParameter.setHasRight(true);
        formPlugin.getView().showForm(showParameter);
    }

    public static void saveRelation4ExpenseItem(Object[] expenseItemPks, IFormView view) {
        if (expenseItemPks.length > 0) {
            BillList assignList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection selectedRows = assignList.getSelectedRows();
            ExpenseItemUtils.deleteRelation4ExpenseItem(expenseItemPks);
            if (!selectedRows.isEmpty()) {
                ExpenseItemUtils.saveRelation(expenseItemPks, selectedRows);
            } else {
                Object[] billTypePks = new Object[]{};
                ExpenseItemUtils.updateBillTypeStr(expenseItemPks, billTypePks);
            }
        }
    }

    public static void deleteRelation4ExpenseItem(Object[] expenseItemPks) {
        DeleteServiceHelper.delete((String)"er_expenseitembill", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", (Object)expenseItemPks)});
    }

    public static void deleteLayOutRelation4ExpenseItem(Object[] expenseItemPks) {
        DeleteServiceHelper.delete((String)"er_expenseitemlayout", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", (Object)expenseItemPks)});
    }

    private static void saveRelation(Object[] expenseItemPks, ListSelectedRowCollection selectedRows) {
        if (!selectedRows.isEmpty()) {
            ExpenseItemUtils.saveRelation(expenseItemPks, selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()).toArray());
        }
    }

    public static void saveRelation(Object[] expenseItemPks, Object[] billTypePks) {
        if (billTypePks.length > 0) {
            ArrayList<DynamicObject> relationColl = new ArrayList<DynamicObject>();
            for (Object expenseItemId : expenseItemPks) {
                for (Object billTypePK : billTypePks) {
                    DynamicObject expenseItembill = BusinessDataServiceHelper.newDynamicObject((String)"er_expenseitembill");
                    expenseItembill.set("expenseitem_id", expenseItemId);
                    expenseItembill.set("billtype_id", billTypePK);
                    expenseItembill.set("createOrg", (Object)RequestContext.get().getOrgId());
                    expenseItembill.set("enable", (Object)1);
                    expenseItembill.set("status", (Object)BillStatus.A.toString());
                    relationColl.add(expenseItembill);
                }
            }
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
        ExpenseItemUtils.updateBillTypeStr(expenseItemPks, billTypePks);
    }

    public static void saveLayOutRelation(Object[] expenseItemPks, Object[] layOutPks) {
        if (layOutPks.length > 0) {
            ArrayList<DynamicObject> relationColl = new ArrayList<DynamicObject>();
            for (Object expenseItemId : expenseItemPks) {
                for (Object layOutid : layOutPks) {
                    DynamicObject expenseItembill = BusinessDataServiceHelper.newDynamicObject((String)"er_expenseitemlayout");
                    expenseItembill.set("expenseitem_id", expenseItemId);
                    expenseItembill.set("layout_id", layOutid);
                    expenseItembill.set("createOrg", (Object)RequestContext.get().getOrgId());
                    expenseItembill.set("enable", (Object)1);
                    expenseItembill.set("status", (Object)BillStatus.A.toString());
                    relationColl.add(expenseItembill);
                }
            }
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
    }

    private static void updateBillTypeStr(Object[] expenseItemPks, Object[] billTypePks) {
        DynamicObject[] expenseItems;
        Map loadFromCache;
        List billTypeNames;
        String billTypeStr = "";
        if (billTypePks.length > 0 && (billTypeStr = StringUtils.join(billTypeNames = (loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billTypePks)})).values().stream().map(v -> v.getString("name")).collect(Collectors.toList()), (String)";")).length() > 600) {
            billTypeStr = billTypeStr.substring(0, 597).concat("...");
        }
        for (DynamicObject expenseItem : expenseItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,relbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)expenseItemPks)})) {
            expenseItem.set("relbilltype", (Object)billTypeStr);
        }
        SaveServiceHelper.save((DynamicObject[])expenseItems);
    }

    public static void copyRelation(Object tarPk, Object srcPk) {
        QFilter[] filters = new QFilter[]{new QFilter("expenseitem", "=", srcPk)};
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitembill", (String)"billtype", (QFilter[])filters);
        Object[] billTypePks = relations.values().stream().map(v -> v.get("billtype.id")).collect(Collectors.toList()).toArray();
        ExpenseItemUtils.saveRelation(new Object[]{tarPk}, billTypePks);
    }

    public static void selectedBillType(Object[] expenseItems, IFormView view) {
        DynamicObject[] relation = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", (Object)expenseItems)});
        Set<Object> billTypeSet = Stream.of(relation).map(v -> v.getDynamicObject("billtype").getPkValue()).collect(Collectors.toSet());
        OperationStatus billStatus = view.getFormShowParameter().getStatus();
        if (billStatus != null && OperationStatus.ADDNEW.equals((Object)billStatus) && billTypeSet.isEmpty() && expenseItems.length == 1) {
            billTypeSet = ExpenseItemUtils.getParentExpenseItemType(expenseItems[0]);
        }
        ExpenseItemUtils.sendAction(view, billTypeSet);
    }

    public static Set<Object> getParentExpenseItemType(Object expenseItemPk) {
        DynamicObject expenseItem = BusinessDataServiceHelper.loadSingle((Object)expenseItemPk, (String)"er_expenseitemedit", (String)"parent.id");
        if (expenseItem == null) {
            return new HashSet<Object>(0);
        }
        DynamicObject parent = expenseItem.getDynamicObject("parent");
        if (parent != null) {
            DynamicObject[] relation = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "=", parent.getPkValue())});
            if (relation.length > 0) {
                return Stream.of(relation).map(v -> v.getDynamicObject("billtype").getPkValue()).collect(Collectors.toSet());
            }
            return ExpenseItemUtils.getParentExpenseItemType(parent.getPkValue());
        }
        return new HashSet<Object>(0);
    }

    private static void sendAction(IFormView view, Set<Object> billTypeSet) {
        if (!billTypeSet.isEmpty()) {
            BillList assignList = (BillList)view.getControl("billlistap");
            AbstractGrid.GridState entryState = assignList.getEntryState();
            DynamicObjectCollection lists = assignList.getListModel().getQueryResult().getCollection();
            ArrayList<Integer> selectIndex = new ArrayList<Integer>();
            for (int i = 0; i < lists.size(); ++i) {
                if (!billTypeSet.contains(((DynamicObject)lists.get(i)).getPkValue())) continue;
                selectIndex.add(i);
            }
            int[] selectIndexs = selectIndex.stream().mapToInt(Integer::valueOf).toArray();
            entryState.selectRow(selectIndexs);
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod("billlistap", "selectRows", new Object[]{selectIndexs});
        }
    }

    public static List<String> getSubLevle(String expItemid) {
        logger.info(String.format("\u8c03\u7528getSubLevle(%s)", expItemid));
        DynamicObject[] expItemDyms = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,isleaf,parent", (QFilter[])new QFilter[]{new QFilter("parent.id", "=", (Object)Long.valueOf(expItemid))});
        ArrayList<String> expItems = new ArrayList<String>(expItemDyms.length);
        for (DynamicObject expItemDym : expItemDyms) {
            List<String> subLevle;
            boolean ifLeaf = expItemDym.getBoolean("isleaf");
            if (!ifLeaf && !(subLevle = ExpenseItemUtils.getSubLevle(expItemDym.getPkValue().toString())).isEmpty()) {
                expItems.addAll(subLevle);
            }
            expItems.add(expItemDym.getPkValue().toString());
        }
        return expItems;
    }
}

