/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialInfoHelper {
    public static final String ctrlstrategy_cu_assign = "1";
    public static final String ctrlstrategy_cu_free_assign = "2";
    public static final String ctrlstrategy_global_share = "5";
    public static final String ctrlstrategy_cu_share = "6";
    public static final String ctrlstrategy_private = "7";

    public List<Long> getInfoCreateOrg(BaseShowParameter baseShowParameter, DynamicObject ctrlview) {
        Object orgId;
        String entity = baseShowParameter.getFormId();
        String appId = baseShowParameter.getAppId();
        List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appId);
        Long material = (Long)baseShowParameter.getCustomParam("materialid");
        DynamicObject materialCtrlview = BaseDataServiceHelper.getCtrlview((String)"bd_material");
        Long materialViewId = materialCtrlview.getLong("id");
        Set<Long> baseDataOutIdSet = this.getCtrlOrg(material, materialViewId);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("material", "=", (Object)material)});
        HashSet<Long> orgs = new HashSet<Long>(loadFromCache.size());
        for (DynamicObject detail : loadFromCache.values()) {
            orgId = MaterialInfoHelper.getDataByType(detail.get("createorg"));
            orgs.add((Long)orgId);
        }
        Set<Long> allchildOrgs = this.getAllSubordinateOrgs(materialViewId, orgs);
        allchildOrgs.addAll(orgs);
        ArrayList<Long> useOrgs = new ArrayList<Long>();
        if (baseDataOutIdSet == null) {
            useOrgs.addAll(createOrgs);
        } else {
            orgId = createOrgs.iterator();
            while (orgId.hasNext()) {
                long createOrg = (Long)orgId.next();
                for (long baseDataOutId : baseDataOutIdSet) {
                    if (createOrg != baseDataOutId) continue;
                    useOrgs.add(createOrg);
                }
            }
        }
        ArrayList<Long> allUseOrgs = new ArrayList<Long>();
        Iterator iterator = useOrgs.iterator();
        while (iterator.hasNext()) {
            long useOrg = (Long)iterator.next();
            for (long childOrg : allchildOrgs) {
                if (useOrg != childOrg) continue;
                allUseOrgs.add(useOrg);
            }
        }
        return allUseOrgs;
    }

    private Set<Long> getCtrlOrg(Long materialId, Long orgViewId) {
        DBRoute dbRoute = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_material");
        String dbRouteKey = entityType.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"ctrlstrategy,createorg");
        String ctrlstragy = material.getString("ctrlstrategy");
        HashSet<Long> createOrgSet = new HashSet<Long>();
        Long createOrgId = MaterialInfoHelper.getDataByType(material.get("createorg"));
        createOrgSet.add(createOrgId);
        Set<Long> materialCtrlOrgIdSet = new HashSet<Long>();
        if (ctrlstrategy_cu_assign.equals(ctrlstragy) || ctrlstrategy_cu_free_assign.equals(ctrlstragy)) {
            String sql = "select fuseorgid useorg from t_bd_materialusereg where FdataID = " + materialId;
            materialCtrlOrgIdSet = (Set)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws Exception {
                    HashSet<Long> set = new HashSet<Long>(rs.getRow());
                    while (rs.next()) {
                        set.add(rs.getLong("useorg"));
                    }
                    return set;
                }
            });
            materialCtrlOrgIdSet.add(createOrgId);
        } else if (ctrlstrategy_global_share.equals(ctrlstragy)) {
            materialCtrlOrgIdSet = null;
        } else if (ctrlstrategy_cu_share.equals(ctrlstragy)) {
            materialCtrlOrgIdSet = this.getAllSubordinateOrgs(orgViewId, createOrgSet);
            materialCtrlOrgIdSet.add(createOrgId);
        } else if (ctrlstrategy_private.equals(ctrlstragy)) {
            materialCtrlOrgIdSet = createOrgSet;
        }
        return materialCtrlOrgIdSet;
    }

    private Set<Long> getAllSubordinateOrgs(Long orgViewId, Set<Long> orgs) {
        QFilter orgFilter = new QFilter("org", "in", orgs);
        QFilter viewFilter = new QFilter("view", "=", (Object)orgViewId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("org.status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, freezeFilter, statusFilter, enableFilter, viewFilter};
        String parentLongNumber = null;
        ArrayList<String> parentLongnumberList = new ArrayList<String>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bd.sbd.business.helper.MaterialInfoHelper.getAllSubordinateOrgs", (String)"bos_org_structure", (String)"longnumber", (QFilter[])filters, (String)"longnumber");
        Object object = null;
        try {
            for (Row row : dataSet) {
                String longnumber = row.getString("longnumber");
                if (StringUtils.isBlank((CharSequence)longnumber) || parentLongNumber != null && longnumber.startsWith(parentLongNumber)) continue;
                parentLongNumber = longnumber + "!";
                parentLongnumberList.add(parentLongNumber);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet<Long> childOrgIds = new HashSet<Long>();
        for (String longnumber : parentLongnumberList) {
            QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
            qFilters.add(longnumberFilter);
            qFilters.add(freezeFilter);
            qFilters.add(statusFilter);
            qFilters.add(enableFilter);
            qFilters.add(viewFilter);
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"kd.bd.sbd.business.helper.MaterialInfoHelper.getAllSubordinateOrgs.longnumber", (String)"bos_org_structure", (String)"org", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet2) {
                    childOrgIds.add(row.getLong("org"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet2 == null) continue;
                if (throwable != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet2.close();
            }
        }
        return childOrgIds;
    }

    public void showCreateOrgFilter(BaseShowParameter baseShowParameter, ListShowParameter lsp) {
    }

    public static Long getDataByType(Object object) {
        Long dataId = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject createorg = (DynamicObject)object;
            dataId = (Long)createorg.getPkValue();
        } else if (object instanceof Long) {
            dataId = (Long)object;
        }
        return dataId;
    }
}

