/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.inf.MetaHelper;
import kd.bd.master.inf.SelectParams;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.OpBizRuleSetWriter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillopcontrolHelper {
    private static final Log log = LogFactory.getLog(BillopcontrolHelper.class);
    private static final String RULETYPE = "OpMasterManagement";

    public FormShowParameter getConditionParam(CloseCallBack cb, String entityNumber, Object conditionJson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.setFormId("botp_condition");
        showParameter.setCloseCallBack(cb);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(true));
        return showParameter;
    }

    public FormShowParameter getSelectParams(CloseCallBack cb, String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        MetaHelper metaHelper = new MetaHelper(null, entityType);
        String colsJosnTree = metaHelper.buildTreeWithEntry2JSON(entityNumber);
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        showParameter.setFormId("bd_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(cb);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public String getLastKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String[] splitKey = key.split("\\.");
        if (splitKey.length > 1) {
            return splitKey[splitKey.length - 1];
        }
        return key;
    }

    public void updateOpBizRuleSet(List<Object> successPkIds) {
        Object pk = successPkIds.get(0);
        DynamicObject billopcontrol = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_billopcontrol", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (billopcontrol != null) {
            String entityNumber = billopcontrol.getDynamicObject("object").getString("number");
            log.info("\u6ce8\u518c\u5ba2\u5546\u72b6\u6001\u7ba1\u63a7\u670d\u52a1,\u5355\u636e\u6807\u8bc6:{},\u89c4\u5219:{}", (Object)entityNumber, (Object)RULETYPE);
            OpBizRuleSetWriter.deleteOpBizRuleSet((String)entityNumber, (String)RULETYPE);
            DynamicObjectCollection entryentity = billopcontrol.getDynamicObjectCollection("entryentity");
            ArrayList<String> opKeySet = new ArrayList<String>(entryentity.size());
            for (DynamicObject coln : entryentity) {
                String opKey = coln.getString("billoperation");
                opKeySet.add(opKey);
            }
            log.info("\u6ce8\u518c\u64cd\u4f5c,\u5355\u636e\u7c7b\u578b:{},\u64cd\u4f5c:{},\u89c4\u5219:{}", new Object[]{entityNumber, opKeySet, RULETYPE});
            OpBizRuleSetWriter.saveOpBizRuleSet((String)entityNumber, (String)RULETYPE, new ArrayList(opKeySet));
        }
    }

    public void deleteOpBizRuleSet(DynamicObject[] dyns) {
        for (DynamicObject dyn : dyns) {
            String entityNumber = dyn.getDynamicObject("object").getString("number");
            log.info("\u6ce8\u518c\u5ba2\u5546\u72b6\u6001\u7ba1\u63a7\u670d\u52a1,\u5355\u636e\u6807\u8bc6:{},\u89c4\u5219:{}", (Object)entityNumber, (Object)RULETYPE);
            try (TXHandle tx = TX.requiresNew();){
                OpBizRuleSetWriter.deleteOpBizRuleSet((String)entityNumber, (String)RULETYPE);
            }
        }
    }

    public Map<String, Object> buildMatchParam(DynamicObject dyn, Set<String> vars) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(vars.size());
        for (String var : vars) {
            Object value = dyn.get(var);
            if (value instanceof DynamicObject) {
                DynamicObject dynaObj = (DynamicObject)value;
                value = this.getPkValue(dynaObj);
            } else if (value instanceof ILocaleString) {
                ILocaleString localValue = (ILocaleString)value;
                value = localValue.getLocaleValue();
            }
            ctx.put(var, value);
        }
        return ctx;
    }

    private Long getPkValue(DynamicObject obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getLong("id");
    }

    public String getOperateName(String entityName, String opKey, String localeId) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityName);
        for (Map o : ops) {
            String op = (String)o.get("key");
            if (!op.equals(opKey)) continue;
            LinkedHashMap map = (LinkedHashMap)o.get("name");
            return (String)map.get(localeId);
        }
        return "";
    }
}

