/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.helper.MasterDataHelper;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BizpartnerHelper {
    private static final Log log = LogFactory.getLog(BizpartnerHelper.class);
    private static final String PROP_ID = "id";
    private static final String PROP_BIZPARTNER = "bizpartner";
    private static final String PROP_PARTNERROLE = "partnerrole";

    public static void saveBizPartner(List<DynamicObject> newBizPartnerdatas, List<DynamicObject> oldBizPartnerdatas) throws KDBizException {
        ArrayList<DynamicObject> bizparners = new ArrayList<DynamicObject>();
        try (TraceSpan span = Tracer.create((String)"BizpartnerHelper", (String)"saveBizPartner");){
            if (newBizPartnerdatas.size() > 0) {
                String[] codes = BizpartnerHelper.getCodeRuleNumber(newBizPartnerdatas);
                bizparners.addAll(BizpartnerHelper.saveBizPartner(newBizPartnerdatas, codes));
            }
            if (oldBizPartnerdatas.size() > 0) {
                log.info("save bizpartner saveExitBizPartner");
                bizparners.addAll(BizpartnerHelper.saveExitBizPartner(oldBizPartnerdatas));
            }
        }
        if (bizparners.size() > 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_bizpartner", (DynamicObject[])bizparners.toArray(new DynamicObject[bizparners.size()]), (OperateOption)operateOption);
            log.info("save bizpartner result:" + operationResult.isSuccess());
            if (!operationResult.isSuccess()) {
                List errorInfoList = operationResult.getAllErrorOrValidateInfo();
                StringBuilder error = new StringBuilder();
                for (IOperateInfo ori : errorInfoList) {
                    error.append(ori.getMessage());
                    error.append(' ');
                }
                throw new KDBizException(error.toString());
            }
        }
    }

    public static List<DynamicObject> saveExitBizPartner(List<DynamicObject> oldBizPartnerdatas) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(oldBizPartnerdatas.size());
        for (DynamicObject eixtData : oldBizPartnerdatas) {
            Long pk = 0L;
            if (eixtData.get(PROP_BIZPARTNER) != null && eixtData.get(PROP_BIZPARTNER) instanceof DynamicObject) {
                DynamicObject bizparterDyn = eixtData.getDynamicObject(PROP_BIZPARTNER);
                pk = bizparterDyn.getLong(PROP_ID);
            } else if (eixtData.get(PROP_BIZPARTNER) != null && eixtData.get(PROP_BIZPARTNER) instanceof Long) {
                pk = eixtData.getLong(PROP_BIZPARTNER);
            }
            map.put(pk, eixtData);
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bizpartner");
        DynamicObject[] bizpartnerDatas = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(new Object[map.size()]), (DynamicObjectType)dt);
        ArrayList<Object> bizpartners = new ArrayList<DynamicObject>();
        if (bizpartnerDatas != null && bizpartnerDatas.length > 0) {
            bizpartners = new ArrayList(bizpartnerDatas.length);
            for (DynamicObject exitBizpartner : bizpartnerDatas) {
                bizpartners.add(BizpartnerHelper.bizpartnerSetValue(map, exitBizpartner));
            }
        }
        return bizpartners;
    }

    private static List<DynamicObject> saveBizPartner(List<DynamicObject> newBizPartnerdatas, String[] codes) {
        DynamicObject bizpartner = null;
        DynamicObject data = null;
        ArrayList<DynamicObject> bizpartners = new ArrayList<DynamicObject>();
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        List ckVos = newBizPartnerdatas.stream().map(ex -> BizpartnerHelper.getLowerString(ex.getLocaleString("name").getLocaleValue())).collect(Collectors.toList());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("lower(name)", "in", ckVos));
        Map queryBizpartners = BusinessDataServiceHelper.loadFromCache((String)"bd_bizpartner", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        HashMap<String, List<DynamicObject>> bizpartnerNames = new HashMap<String, List<DynamicObject>>();
        if (!queryBizpartners.isEmpty() && queryBizpartners.size() > 0) {
            for (Map.Entry dm : queryBizpartners.entrySet()) {
                List dynamicObjects;
                String localValue = ((DynamicObject)dm.getValue()).getLocaleString("name").getLocaleValue();
                if (!BizpartnerHelper.caseInsensitiveContains(bizpartnerNames, localValue)) {
                    dynamicObjects = new ArrayList(1);
                    dynamicObjects.add(dm.getValue());
                    bizpartnerNames.put(BizpartnerHelper.getLowerString(localValue), dynamicObjects);
                    continue;
                }
                dynamicObjects = (List)bizpartnerNames.get(BizpartnerHelper.getLowerString(localValue));
                dynamicObjects.add(dm.getValue());
                bizpartnerNames.put(BizpartnerHelper.getLowerString(localValue), dynamicObjects);
            }
        }
        for (int i = 0; i < newBizPartnerdatas.size(); ++i) {
            data = newBizPartnerdatas.get(i);
            String name = BizpartnerHelper.getLowerString(data.getLocaleString("name").getLocaleValue());
            String type = data.getString("type");
            if (!bizpartnerNames.isEmpty() && bizpartnerNames.size() > 0 && BizpartnerHelper.caseInsensitiveContains(bizpartnerNames, name)) {
                List datas = (List)bizpartnerNames.get(name);
                if (datas != null && datas.size() > 0) {
                    boolean flag = false;
                    for (DynamicObject dm : datas) {
                        if (!"4".equals(type) && data.getString("societycreditcode").equals(dm.getString("societycreditcode")) && data.getString("tx_register_no").equals(dm.getString("tx_register_no")) && data.getString("type").equals(dm.getString("type"))) {
                            map.put(Long.valueOf(dm.getPkValue().toString()), data);
                            data.set("bizpartner_id", (Object)Long.valueOf(dm.getPkValue().toString()));
                            flag = true;
                            break;
                        }
                        if (!"4".equals(type) || !type.equals(dm.getString("type")) || !data.getString("idno").equals(dm.getString("idno"))) continue;
                        map.put(Long.valueOf(dm.getPkValue().toString()), data);
                        data.set("bizpartner_id", (Object)Long.valueOf(dm.getPkValue().toString()));
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    bizpartner = BizpartnerHelper.createBizpartner(codes, data, i);
                    data.set(PROP_BIZPARTNER, (Object)bizpartner);
                    bizpartners.add(bizpartner);
                    continue;
                }
                log.info("createBizpartner codes:" + codes.length + " i:" + i);
                bizpartner = BizpartnerHelper.createBizpartner(codes, data, i);
                data.set(PROP_BIZPARTNER, (Object)bizpartner);
                bizpartners.add(bizpartner);
                continue;
            }
            log.info("createBizpartner codes:" + codes.length + " i:" + i);
            bizpartner = BizpartnerHelper.createBizpartner(codes, data, i);
            data.set(PROP_BIZPARTNER, (Object)bizpartner);
            bizpartners.add(bizpartner);
        }
        if (!map.isEmpty() && map.size() > 0) {
            bizpartners.addAll(BizpartnerHelper.getBizpartner(map));
        }
        return bizpartners;
    }

    public static List<DynamicObject> getBizpartner(Map<Long, DynamicObject> map) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bizpartner");
        DynamicObject[] exitBizpartners = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(new Object[map.size()]), (DynamicObjectType)dt);
        ArrayList<DynamicObject> bizpartners = null;
        if (exitBizpartners != null && exitBizpartners.length > 0) {
            bizpartners = new ArrayList<DynamicObject>(exitBizpartners.length);
            for (DynamicObject exitBizpartner : exitBizpartners) {
                bizpartners.add(BizpartnerHelper.bizpartnerSetValue(map, exitBizpartner));
            }
        }
        return bizpartners;
    }

    public static DynamicObject bizpartnerSetValue(Map<Long, DynamicObject> map, DynamicObject exitBizpartner) {
        DynamicObject obj = map.get(exitBizpartner.getLong(PROP_ID));
        exitBizpartner.set("name", obj.get("name"));
        exitBizpartner.set("simplename", obj.get("simplename"));
        exitBizpartner.set("type", obj.get("type"));
        exitBizpartner.set("country", obj.get("country"));
        exitBizpartner.set("address", obj.get("bizpartner_address"));
        exitBizpartner.set("linkman", obj.get("linkman"));
        exitBizpartner.set("phone", obj.get("bizpartner_phone"));
        exitBizpartner.set("fax", obj.get("bizpartner_fax"));
        exitBizpartner.set("societycreditcode", obj.get("societycreditcode"));
        exitBizpartner.set("tx_register_no", obj.get("tx_register_no"));
        exitBizpartner.set("artificialperson", obj.get("artificialperson"));
        exitBizpartner.set("internal_company", obj.get("internal_company"));
        exitBizpartner.set("picturefield", obj.get("picturefield"));
        exitBizpartner.set("regcapital", obj.get("regcapital"));
        exitBizpartner.set("establishdate", obj.get("establishdate"));
        exitBizpartner.set("businessterm", obj.get("businessterm"));
        exitBizpartner.set("businessscope", obj.get("businessscope"));
        exitBizpartner.set("idno", obj.get("idno"));
        exitBizpartner.set("postal_code", obj.get("postal_code"));
        exitBizpartner.set("admindivision", obj.get("admindivision"));
        exitBizpartner.set("url", obj.get("url"));
        exitBizpartner.set("duns", obj.get("duns"));
        exitBizpartner.set("curegcapital", obj.get("curegcapital"));
        exitBizpartner.set("chkisinternalcompany", obj.get("chkisinternalcompany"));
        if ("bd_supplier".equals(obj.getDataEntityType().getName())) {
            if (",2,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,2,");
            }
            if (",3,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,3,");
            }
            if (",2,3,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,2,3,");
            }
            if (",".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,");
            }
        }
        if ("bd_customer".equals(obj.getDataEntityType().getName())) {
            if (",1,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,2,");
            }
            if (",3,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",2,3,");
            }
            if (",1,3,".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",1,2,3,");
            }
            if (",".equals(exitBizpartner.getString(PROP_PARTNERROLE))) {
                exitBizpartner.set(PROP_PARTNERROLE, (Object)",2,");
            }
        }
        return exitBizpartner;
    }

    public static DynamicObject createBizpartner(String[] codes, DynamicObject data, int i) {
        DynamicObject bizpartner = BusinessDataServiceHelper.newDynamicObject((String)"bd_bizpartner");
        long id = DB.genLongId((String)"T_BD_BIZPARTNER");
        bizpartner.set(PROP_ID, (Object)id);
        bizpartner.set("masterid", (Object)id);
        bizpartner.set("enable", (Object)"1");
        bizpartner.set("status", (Object)"C");
        bizpartner.set("creator", data.get("creator"));
        bizpartner.set("createtime", (Object)TimeServiceHelper.now());
        if (codes == null || codes.length == 0 || kd.bos.util.StringUtils.isEmpty((String)codes[i])) {
            bizpartner.set("number", (Object)data.getString("number"));
        } else {
            bizpartner.set("number", (Object)codes[i]);
        }
        bizpartner.set("name", data.get("name"));
        bizpartner.set("simplename", data.get("simplename"));
        bizpartner.set("type", data.get("type"));
        bizpartner.set("country", data.get("country"));
        bizpartner.set("address", data.get("bizpartner_address"));
        bizpartner.set("linkman", data.get("linkman"));
        bizpartner.set("phone", data.get("bizpartner_phone"));
        bizpartner.set("fax", data.get("bizpartner_fax"));
        bizpartner.set("societycreditcode", data.get("societycreditcode"));
        bizpartner.set("tx_register_no", data.get("tx_register_no"));
        bizpartner.set("artificialperson", data.get("artificialperson"));
        bizpartner.set("internal_company", data.get("internal_company"));
        bizpartner.set("picturefield", data.get("picturefield"));
        bizpartner.set("postal_code", data.get("postal_code"));
        bizpartner.set("regcapital", data.get("regcapital"));
        bizpartner.set("establishdate", data.get("establishdate"));
        bizpartner.set("businessterm", data.get("businessterm"));
        bizpartner.set("businessscope", data.get("businessscope"));
        bizpartner.set("idno", data.get("idno"));
        bizpartner.set("admindivision", data.get("admindivision"));
        bizpartner.set("url", data.get("url"));
        bizpartner.set("duns", data.get("duns"));
        bizpartner.set("curegcapital", data.get("curegcapital"));
        bizpartner.set("chkisinternalcompany", data.get("chkisinternalcompany"));
        if ("bd_customer".equals(data.getDataEntityType().getName())) {
            bizpartner.set("iscustomer", (Object)Boolean.TRUE);
            bizpartner.set(PROP_PARTNERROLE, (Object)",2,");
        }
        if ("bd_supplier".equals(data.getDataEntityType().getName())) {
            bizpartner.set("issupplier", (Object)Boolean.TRUE);
            bizpartner.set(PROP_PARTNERROLE, (Object)",1,");
        }
        return bizpartner;
    }

    private static String[] getCodeRuleNumber(List<DynamicObject> newBizPartnerdatas) {
        DynamicObject bizpartner = BusinessDataServiceHelper.newDynamicObject((String)"bd_bizpartner");
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"bd_bizpartner", (DynamicObject)bizpartner, (String)RequestContext.get().getLoginOrg(), (int)newBizPartnerdatas.size());
        log.info("batchNumber:" + batchNumber.length);
        return batchNumber;
    }

    public static OperationContext prepareOperParams(BeforeOperationArgs e, String entityName) {
        OperationContext operContext = new OperationContext();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return operContext;
        }
        ArrayList<Object> partnerIds = new ArrayList<Object>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject tempObj = dataEntities[i];
            DynamicObject bizPartner = tempObj.getDynamicObject(PROP_BIZPARTNER);
            Object partnerId = bizPartner == null ? Long.valueOf(0L) : bizPartner.getPkValue();
            partnerIds.add(partnerId);
        }
        try (TraceSpan span = Tracer.create((String)"BizpartnerHelper", (String)"prepareOperParams");){
            DynamicObject[] partnerArr = BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id, number, partnerrole", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", partnerIds)});
            HashMap<String, DynamicObject> operParamsMap = operContext.getParameter();
            if (operParamsMap == null) {
                operParamsMap = new HashMap<String, DynamicObject>(partnerArr.length);
                operContext.setParameter(operParamsMap);
            }
            for (DynamicObject partner : partnerArr) {
                operParamsMap.put(String.valueOf(partner.getPkValue()), partner);
            }
        }
        return operContext;
    }

    public static void dealWithBizPartner(AfterOperationArgs afterOperArgs, OperationContext operContext, String entityName, String partnerRoleNumber) {
        block30: {
            try {
                Throwable throwable;
                TraceSpan span;
                DynamicObject[] dataEntities = afterOperArgs.getDataEntities();
                if (dataEntities == null) {
                    log.info("BizpartnerHelper.dealWithBizPartner, dataEntities is null");
                    return;
                }
                Map operParamsMap = operContext.getParameter();
                if (operParamsMap == null || operParamsMap.isEmpty()) {
                    log.info("BizpartnerHelper.dealWithBizPartner, operParamsMap is null");
                    return;
                }
                HashSet<Long> needDelBizPartnerIdSet = new HashSet<Long>(dataEntities.length);
                HashSet<DynamicObject> needUpdBizPatnerEntitySet = new HashSet<DynamicObject>(dataEntities.length);
                BizpartnerHelper.bizPartnerPreProcessing(dataEntities, operParamsMap, entityName, partnerRoleNumber, needDelBizPartnerIdSet, needUpdBizPatnerEntitySet);
                if (!needDelBizPartnerIdSet.isEmpty()) {
                    span = Tracer.create((String)"BizpartnerHelper", (String)"batch delete partner");
                    throwable = null;
                    try {
                        int needDelBizPartnerIdSetSize = needDelBizPartnerIdSet.size();
                        log.info("BizpartnerHelper batch delete bd_bizpartner " + needDelBizPartnerIdSetSize + " record");
                        OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"bd_bizpartner", (Object[])needDelBizPartnerIdSet.toArray(), null);
                        List errInfo = delResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                        log.info("BizpartnerHelper batch delete bd_bizpartner " + needDelBizPartnerIdSetSize + " record, result: " + delResult.isSuccess() + ":" + errInfo + ", delBizPartnerId:" + needDelBizPartnerIdSet);
                    }
                    catch (Throwable needDelBizPartnerIdSetSize) {
                        throwable = needDelBizPartnerIdSetSize;
                        throw needDelBizPartnerIdSetSize;
                    }
                    finally {
                        if (span != null) {
                            if (throwable != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable needDelBizPartnerIdSetSize) {
                                    throwable.addSuppressed(needDelBizPartnerIdSetSize);
                                }
                            } else {
                                span.close();
                            }
                        }
                    }
                }
                if (needUpdBizPatnerEntitySet.isEmpty()) break block30;
                span = Tracer.create((String)"BizpartnerHelper", (String)"batch update partner role");
                throwable = null;
                try {
                    int needUpdBizPatnerEntitySetSize = needUpdBizPatnerEntitySet.size();
                    log.info("BizpartnerHelper batch update BizPartner " + needUpdBizPatnerEntitySetSize + " record");
                    SaveServiceHelper.update((DynamicObject[])needUpdBizPatnerEntitySet.toArray(new DynamicObject[needUpdBizPatnerEntitySetSize]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span != null) {
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            span.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(entityName + " BizpartnerHelper.dealWithBizPartner exception", (Throwable)e);
            }
        }
    }

    private static void bizPartnerPreProcessing(DynamicObject[] dataEntities, Map<String, Object> operParamsMap, String entityName, String partnerRoleNumber, Set<Long> needDelBizPartnerIdSet, Set<DynamicObject> needUpdBizPatnerEntitySet) {
        Map<Long, Boolean> bizPartnerInUsedMap = BizpartnerHelper.queryBizPartnerInUsedMap(operParamsMap, entityName);
        for (int i = 0; i < dataEntities.length; ++i) {
            boolean onlyCurEntityRole;
            String[] roleArr;
            Long bizPartnerIdKey;
            String partnerRole;
            DynamicObject bizPartnerDyn;
            DynamicObject bizPartnerEntity = dataEntities[i].getDynamicObject(PROP_BIZPARTNER);
            String bizPartnerId = bizPartnerEntity == null ? "0" : String.valueOf(bizPartnerEntity.getPkValue());
            Object bizPartner = operParamsMap.get(bizPartnerId);
            DynamicObject dynamicObject = bizPartnerDyn = bizPartner instanceof DynamicObject ? (DynamicObject)bizPartner : null;
            if (bizPartnerDyn == null || kd.bos.util.StringUtils.isEmpty((String)(partnerRole = bizPartnerDyn.getString(PROP_PARTNERROLE))) || bizPartnerInUsedMap.get(bizPartnerIdKey = Long.valueOf(String.valueOf(bizPartnerDyn.getPkValue()))) != null || (roleArr = partnerRole.split(",")).length <= 0) continue;
            List notCurEntityRoleList = Arrays.stream(roleArr).filter(r -> !"".equals(r) && !partnerRoleNumber.equals(r)).collect(Collectors.toList());
            boolean bl = onlyCurEntityRole = notCurEntityRoleList.size() == 0;
            if (onlyCurEntityRole) {
                needDelBizPartnerIdSet.add(bizPartnerIdKey);
                continue;
            }
            bizPartnerDyn.set(PROP_PARTNERROLE, (Object)partnerRole.replace(partnerRoleNumber + ",", ""));
            needUpdBizPatnerEntitySet.add(bizPartnerDyn);
        }
    }

    private static Map<Long, Boolean> queryBizPartnerInUsedMap(Map<String, Object> operParamsMap, String entityName) {
        ArrayList<Long> bizPartnerIdList = new ArrayList<Long>(operParamsMap.size());
        for (Object bizPartner : operParamsMap.values()) {
            DynamicObject bizPartnerEntity = bizPartner instanceof DynamicObject ? (DynamicObject)bizPartner : null;
            if (bizPartnerEntity == null) continue;
            bizPartnerIdList.add(bizPartnerEntity.getLong(PROP_ID));
        }
        try (TraceSpan span = Tracer.create((String)"BizpartnerHelper", (String)"queryBizPartnerInUsedMap-loadFromCache");){
            Map idObjMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_BIZPARTNER, "in", bizPartnerIdList)});
            HashMap<Long, Boolean> bizPartnerInUsedMap = new HashMap<Long, Boolean>(idObjMap.size());
            for (DynamicObject customerSupplier : idObjMap.values()) {
                bizPartnerInUsedMap.put(customerSupplier.getDynamicObject(PROP_BIZPARTNER).getLong(PROP_ID), Boolean.TRUE);
            }
            HashMap<Long, Boolean> hashMap = bizPartnerInUsedMap;
            return hashMap;
        }
    }

    public static Map<Object, String> bizpartnerReferenceChecking(ExtendedDataEntity[] dataEntities) {
        HashMap<Object, String> result = new HashMap<Object, String>(16);
        HashSet<Object> bizpartnerIds = new HashSet<Object>(dataEntities.length);
        for (ExtendedDataEntity extDataEntity : dataEntities) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            DynamicObject bizpartner = dataEntity.getDynamicObject(PROP_BIZPARTNER);
            if (bizpartner == null) continue;
            bizpartnerIds.add(bizpartner.getPkValue());
        }
        LinkedList<String> ignoreRefEntityIds = new LinkedList<String>();
        ignoreRefEntityIds.add("bd_customer");
        ignoreRefEntityIds.add("bd_supplier");
        ignoreRefEntityIds.add("bd_malsupplier");
        Map checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)"bd_bizpartner", (Object[])bizpartnerIds.toArray(new Object[bizpartnerIds.size()]), ignoreRefEntityIds, null, null);
        if (checkRefrenced == null || checkRefrenced.isEmpty()) {
            return result;
        }
        for (ExtendedDataEntity extDataEntity : dataEntities) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            DynamicObject bizpartner = dataEntity.getDynamicObject(PROP_BIZPARTNER);
            Object bizpartnerId = bizpartner == null ? Long.valueOf(0L) : bizpartner.getPkValue();
            BaseDataCheckRefrenceResult refCheckResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(bizpartnerId);
            if (refCheckResult == null || !refCheckResult.isRefence()) continue;
            String billName = BizpartnerHelper.getRefBillName(refCheckResult);
            String fieldName = BizpartnerHelper.getRefFieldName(refCheckResult);
            String checkingMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u5546\u52a1\u4f19\u4f34\u3002", (String)"BizpartnerHelper_1", (String)"bd-master-business", (Object[])new Object[0]), billName, fieldName);
            result.put(dataEntity.getPkValue(), checkingMsg);
        }
        return result;
    }

    private static String getRefBillName(BaseDataCheckRefrenceResult refrenceCheckResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceCheckResult.getRefenceKey().getRefEntityKey());
        return refMainType.getDisplayName().toString();
    }

    private static String getRefFieldName(BaseDataCheckRefrenceResult refrenceCheckResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceCheckResult.getRefenceKey().getRefEntityKey());
        String fieldName = refrenceCheckResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceCheckResult.getRefenceKey().getRefCol())) {
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceCheckResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceCheckResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
            fieldName = ((MulBasedataProp)property).getDisplayName().toString();
            break;
        }
        return fieldName;
    }

    public static boolean isEnablePartnerRefCheck() {
        Map<String, Object> sysParamMap = MasterDataHelper.loadAppParameterFromCache("15");
        Object enablePartnerRefCheck = sysParamMap.get("enablepartnerrefcheck");
        log.info("isEnablePartnerRefCheck=" + enablePartnerRefCheck);
        return enablePartnerRefCheck instanceof Boolean && (Boolean)enablePartnerRefCheck != false;
    }

    public static boolean isEnablepartner() {
        Map<String, Object> sysParamMap = MasterDataHelper.loadAppParameterFromCache("15");
        Object enablepartner = sysParamMap.get("enablepartner");
        log.info("enablepartner=" + enablepartner);
        if (enablepartner != null) {
            return enablepartner instanceof Boolean && (Boolean)enablepartner != false;
        }
        return true;
    }

    public void updateCustomerBizPartner(List<Long> ids, Long id) {
        log.info("\u9700\u8981\u66f4\u65b0\u7684\u5ba2\u6237id\u96c6:" + ids + "\u9700\u8981\u66f4\u65b0\u7684\u5546\u52a1\u4f19\u4f34id:" + id);
        StringBuilder updateSql = new StringBuilder("update t_bd_customer set fbizpartnerid = ? where Fmasterid in(");
        this.excuteUpdate(ids, id, updateSql, "bd_customer");
    }

    public void updateSupplierBizPartner(List<Long> ids, Long id) {
        log.info("\u9700\u8981\u66f4\u65b0\u7684\u4f9b\u5e94\u5546id\u96c6:" + ids + "\u9700\u8981\u66f4\u65b0\u7684\u5546\u52a1\u4f19\u4f34id:" + id);
        StringBuilder updateSql = new StringBuilder("update t_bd_supplier set fbizpartnerid = ? where Fmasterid in(");
        this.excuteUpdate(ids, id, updateSql, "bd_supplier");
    }

    private void excuteUpdate(List<Long> ids, Long id, StringBuilder updateSql, String type) {
        DynamicObject bpn;
        Long masterid;
        DynamicObject bizpartner = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)id)});
        if (bizpartner == null) {
            log.info("\u4f20\u5165\u7684id\u67e5\u8be2\u6570\u636e\u5e93\u540e\uff0c\u5546\u52a1\u4f19\u4f34\u4e0d\u5b58\u5728\u3002");
            return;
        }
        ArrayList<Long> masterDatas = null;
        HashSet<Object> bizpaetnerIdSet = null;
        HashMap<Long, Long> supplierdataMap = new HashMap<Long, Long>();
        HashMap<Long, Long> customerdataMap = new HashMap<Long, Long>();
        HashMap<Long, DynamicObject> supBizPartnerMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> cusBizPartnerMap = new HashMap<Long, DynamicObject>();
        if ("bd_supplier".equals(type)) {
            DynamicObject[] supplierList = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,masterid,bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", ids)});
            masterDatas = new ArrayList<Long>(supplierList.length);
            bizpaetnerIdSet = new HashSet<Object>(supplierList.length);
            for (DynamicObject supplier : supplierList) {
                masterid = supplier.getLong("masterid");
                bpn = supplier.getDynamicObject(PROP_BIZPARTNER);
                if (masterid == 0L) {
                    log.info("\u4f9b\u5e94\u5546id\uff1a" + supplier.getPkValue() + "\u7684\u4f9b\u5e94\u5546\u6570\u636emasterid=0");
                }
                if (bpn == null) {
                    log.info("\u4f9b\u5e94\u5546id\uff1a" + supplier.getPkValue() + "\u7684\u5546\u52a1\u4f19\u4f34\u6570\u636e\u4e3a\u7a7a");
                }
                if (bpn == null || masterid == 0L) continue;
                masterDatas.add(masterid);
                bizpaetnerIdSet.add(bpn.getPkValue());
                supplierdataMap.put(bpn.getLong(PROP_ID), supplier.getLong(PROP_ID));
                supBizPartnerMap.put(bpn.getLong(PROP_ID), bpn);
            }
        } else if ("bd_customer".equals(type)) {
            DynamicObject[] customerList = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id,masterid,bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", ids)});
            masterDatas = new ArrayList(customerList.length);
            bizpaetnerIdSet = new HashSet(customerList.length);
            for (DynamicObject customer : customerList) {
                masterid = customer.getLong("masterid");
                bpn = customer.getDynamicObject(PROP_BIZPARTNER);
                if (masterid == 0L) {
                    log.info("\u5ba2\u6237id\uff1a" + customer.getPkValue() + "\u7684\u5ba2\u6237\u6570\u636emasterid=0");
                }
                if (bpn == null) {
                    log.info("\u5ba2\u6237id\uff1a" + customer.getPkValue() + "\u7684\u5546\u52a1\u4f19\u4f34\u6570\u636e\u4e3a\u7a7a");
                }
                if (bpn == null || masterid == 0L) continue;
                masterDatas.add(masterid);
                bizpaetnerIdSet.add(bpn.getPkValue());
                customerdataMap.put(bpn.getLong(PROP_ID), customer.getLong(PROP_ID));
                cusBizPartnerMap.put(bpn.getLong(PROP_ID), bpn);
            }
        }
        if (masterDatas != null && masterDatas.size() > 0) {
            DynamicObject[] dynamicObjectArray = null;
            try (TXHandle h = TX.required((String)this.getClass().getName());){
                try {
                    Object[] params = new Object[masterDatas.size() + 1];
                    params[0] = id;
                    for (int i = 0; i < masterDatas.size(); ++i) {
                        updateSql.append("?,");
                        params[i + 1] = masterDatas.get(i);
                    }
                    updateSql.deleteCharAt(updateSql.length() - 1);
                    updateSql.append(')');
                    DB.execute((DBRoute)DBRoute.basedata, (String)updateSql.toString(), (Object[])params);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error(e.getMessage());
                }
            }
            catch (Throwable e) {
                dynamicObjectArray = e;
                throw e;
            }
            String partnerRole = bizpartner.getString(PROP_PARTNERROLE);
            if ("bd_supplier".equals(type) && !partnerRole.contains("1")) {
                bizpartner.set(PROP_PARTNERROLE, (Object)this.getSortString(partnerRole, "1"));
            } else if ("bd_customer".equals(type) && !partnerRole.contains("2")) {
                bizpartner.set(PROP_PARTNERROLE, (Object)this.getSortString(partnerRole, "2"));
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_bizpartner", (DynamicObject[])new DynamicObject[]{bizpartner}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                log.error("\u4fdd\u5b58\u5546\u52a1\u4f19\u4f34\u5931\u8d25\u3002" + operationResult.getAllErrorInfo());
            } else {
                OperationResult op;
                ArrayList updateBizpartners;
                DynamicObject[] bizpartners;
                DynamicObject[] updateBizpartnerDatas = null;
                if ("bd_supplier".equals(type)) {
                    DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,masterid,bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_BIZPARTNER, "in", bizpaetnerIdSet)});
                    if (suppliers == null || suppliers.length == 0) {
                        bizpartners = BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id,partnerrole", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", bizpaetnerIdSet)});
                        updateBizpartnerDatas = this.removePartnerRole(bizpartners, "1");
                    } else {
                        updateBizpartners = new ArrayList(suppliers.length);
                        boolean flag = false;
                        for (Map.Entry map : supplierdataMap.entrySet()) {
                            for (DynamicObject supplier : suppliers) {
                                Long bizpartnerId = supplier.getDynamicObject(PROP_BIZPARTNER).getLong(PROP_ID);
                                if (((Long)map.getKey()).equals(bizpartnerId)) continue;
                                flag = true;
                                break;
                            }
                            if (!flag) continue;
                            updateBizpartners.add(supBizPartnerMap.get(map.getKey()));
                            flag = false;
                        }
                        updateBizpartnerDatas = this.removePartnerRole(updateBizpartners.toArray(new DynamicObject[updateBizpartners.size()]), "1");
                    }
                } else if ("bd_customer".equals(type)) {
                    DynamicObject[] customers = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id,masterid,bizpartner", (QFilter[])new QFilter[]{new QFilter(PROP_BIZPARTNER, "in", bizpaetnerIdSet)});
                    if (customers == null || customers.length == 0) {
                        bizpartners = BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id,partnerrole", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", bizpaetnerIdSet)});
                        updateBizpartnerDatas = this.removePartnerRole(bizpartners, "2");
                    } else {
                        updateBizpartners = new ArrayList(customers.length);
                        boolean flag = false;
                        for (Map.Entry map : customerdataMap.entrySet()) {
                            for (DynamicObject customer : customers) {
                                Long bizpartnerId = customer.getDynamicObject(PROP_BIZPARTNER).getLong(PROP_ID);
                                if (((Long)map.getKey()).equals(bizpartnerId)) continue;
                                flag = true;
                                break;
                            }
                            if (!flag) continue;
                            updateBizpartners.add(cusBizPartnerMap.get(map.getKey()));
                            flag = false;
                        }
                        updateBizpartnerDatas = this.removePartnerRole(updateBizpartners.toArray(new DynamicObject[updateBizpartners.size()]), "2");
                    }
                }
                if (updateBizpartnerDatas != null && !(op = OperationServiceHelper.executeOperate((String)"save", (String)"bd_bizpartner", updateBizpartnerDatas, (OperateOption)OperateOption.create())).isSuccess()) {
                    log.error("\u66f4\u65b0\u5546\u52a1\u4f19\u4f34\u4f19\u4f34\u89d2\u8272\u5931\u8d25\u3002" + operationResult.getAllErrorInfo());
                }
            }
        }
    }

    private String getSortString(String partnerRole, String newStringValue) {
        String[] arr = partnerRole.split(",");
        StringBuilder sb = new StringBuilder();
        StringBuilder newsb = new StringBuilder();
        if (arr != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                sb.append(arr[i]);
            }
        }
        sb.append(newStringValue);
        char[] chars = sb.toString().toCharArray();
        Arrays.sort(chars);
        char[] newchars = new String(chars).toCharArray();
        newsb.append(',');
        for (int i = 0; i < newchars.length; ++i) {
            newsb.append(newchars[i]);
            newsb.append(',');
        }
        return newsb.toString();
    }

    private DynamicObject[] removePartnerRole(DynamicObject[] bizpartners, String newStringValue) {
        log.info("removePartnerRole bizpartners:" + bizpartners.length + "newStringValue:" + newStringValue);
        for (DynamicObject bizpatner : bizpartners) {
            String partnerRole = bizpatner.getString(PROP_PARTNERROLE);
            String[] arr = partnerRole.split(",");
            StringBuilder sb = new StringBuilder();
            StringBuilder newsb = new StringBuilder();
            if (arr == null || arr.length <= 0) continue;
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].equals(newStringValue)) continue;
                sb.append(arr[i]);
            }
            char[] chars = sb.toString().toCharArray();
            Arrays.sort(chars);
            char[] newchars = new String(chars).toCharArray();
            newsb.append(',');
            for (int i = 0; i < newchars.length; ++i) {
                newsb.append(newchars[i]);
                newsb.append(',');
            }
            bizpatner.set(PROP_PARTNERROLE, (Object)newsb.toString());
        }
        return bizpartners;
    }

    private static boolean caseInsensitiveContains(Map<String, List<DynamicObject>> bizpartnerNames, String searchString) {
        for (Map.Entry<String, List<DynamicObject>> entry : bizpartnerNames.entrySet()) {
            if (!searchString.equalsIgnoreCase(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static String getLowerString(String name) {
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (!Character.isUpperCase(charArray[i])) continue;
            charArray[i] = Character.toLowerCase(charArray[i]);
        }
        String lowerCaseStr = new String(charArray);
        return lowerCaseStr;
    }
}

