/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.util;

import java.util.HashSet;
import java.util.Set;
import kd.bd.master.util.EntityFieldTreeOption;
import kd.bd.master.util.EntityFieldTreeResult;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

class EntityFieldNodeHandle {
    private static Log log = LogFactory.getLog(EntityFieldNodeHandle.class);
    private EntityFieldTreeOption option;
    private Set<String> ableFields;
    private EntityFieldTreeResult result = new EntityFieldTreeResult();

    public EntityFieldNodeHandle(EntityFieldTreeOption option) {
        this.option = option;
    }

    public EntityFieldTreeResult getNodes(String mastertype) {
        this.ableFields = EntityFieldNodeHandle.getFields(this.option.getEntityType());
        try {
            this.buildFldTreeNodes(this.option.getEntityType(), this.option.getParentNode(), this.option.isReadEntryEntity(), true, null, "", mastertype);
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
        }
        return this.result;
    }

    private static Set<String> getFields(IDataEntityType entityType) {
        HashSet<String> fields = new HashSet<String>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof EntryProp) && !(property instanceof SubEntryProp)) {
                if (!(property instanceof IFieldHandle)) continue;
                fields.add(property.getName());
                continue;
            }
            EntityType childEntity = (EntityType)((EntryProp)property).getItemType();
            fields.addAll(EntityFieldNodeHandle.getFields((IDataEntityType)childEntity));
        }
        return fields;
    }

    private void buildFldTreeNodes(IDataEntityType entityType, TreeNode parentNode, boolean readEntryEntity, boolean searchSubBaseData, TreeNode currentEntityNode, String prefix, String mastertype) throws CloneNotSupportedException {
        if (currentEntityNode == null) {
            String parentId = "";
            if (parentNode != null) {
                parentId = parentNode.getId();
            }
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (((EntityType)entityType).getDisplayName() != null) {
                entityNodeName = ((EntityType)entityType).getDisplayName().toString();
            }
            this.result.getNonFields().add(entityNodeId);
            currentEntityNode = new TreeNode(parentId, entityNodeId, entityNodeName);
        }
        int oriNodeCount = this.result.getNodes().size();
        for (IDataEntityProperty property : entityType.getProperties()) {
            TreeNode fldNode;
            if (property instanceof EntryProp) {
                EntityType childEntity;
                this.result.getNonFields().add(property.getName());
                if (!readEntryEntity || StringUtils.isBlank((CharSequence)(childEntity = (EntityType)((EntryProp)property).getItemType()).getAlias())) continue;
                TreeNode entityNode = new TreeNode(currentEntityNode.getId(), property.getName(), ((EntryProp)property).getDisplayName().toString());
                this.buildFldTreeNodes((IDataEntityType)childEntity, currentEntityNode, readEntryEntity, searchSubBaseData, entityNode, prefix, mastertype);
                continue;
            }
            if (searchSubBaseData && this.ableFields.size() > 0 && !this.ableFields.contains(property.getName()) || (fldNode = this.buildFldTreeNode(property, currentEntityNode, prefix, mastertype)) == null || !(property instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)property;
            IDataEntityType bdType = bdProp.getComplexType();
            String entitynumer = "";
            switch (mastertype) {
                case "1": {
                    entitynumer = "bd_supplier";
                    break;
                }
                case "2": {
                    entitynumer = "bd_customer";
                    break;
                }
                case "3": {
                    entitynumer = "bd_material";
                    break;
                }
                default: {
                    entitynumer = "bd_material";
                }
            }
            if (property instanceof FlexProp || !bdType.getName().contains(entitynumer)) continue;
            try {
                bdType = MetadataServiceHelper.getDataEntityType((String)bdType.getName());
                this.result.getNodes().add(fldNode);
            }
            catch (KDException ex) {
                ex.printStackTrace();
            }
        }
        if (oriNodeCount != this.result.getNodes().size()) {
            this.result.getNodes().add(currentEntityNode);
        } else if (StringUtils.isNotBlank(this.option.getFieldType()) && this.option.getFieldType().equals(DateTimeProp.class)) {
            this.result.getNodes().add(currentEntityNode);
        }
    }

    private TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix, String mastertype) {
        TreeNode fldNode = null;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (this.option.isIncludeID() && prop instanceof BasedataProp) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() + ".id" : prefix + "." + prop.getName();
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
        }
        return fldNode;
    }
}

