/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.formplugin.wbs;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BdWbsListPlugin
extends StandardTreeListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (!filterColumn.getFieldName().contains("project.number")) continue;
            String defprojectid = this.getPageCache().get("defprojectid");
            if (!StringUtils.isNotEmpty((CharSequence)defprojectid)) break;
            filterColumn.setDefaultValue(defprojectid);
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List schemefilters = (List)args.getFilterValues().get("schemefilter");
        if (schemefilters != null) {
            boolean existsProject = false;
            for (Map schemefilter : schemefilters) {
                List fieldName = (List)schemefilter.get("FieldName");
                if (!StringUtils.equals((CharSequence)fieldName.get(0).toString(), (CharSequence)"project.number")) continue;
                existsProject = true;
                List value = (List)schemefilter.get("Value");
                String projectNum = value.get(0).toString();
                if (!StringUtils.isEmpty((CharSequence)projectNum)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u9879\u76ee\u53f7\u8fc7\u6ee4\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BdWbsListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
            if (!existsProject) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u672a\u8bbe\u7f6e\u9879\u76ee\u53f7\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"BdWbsListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW) {
            ControlFilters controlFilters = this.getControlFilters();
            String projectIdStr = this.getPageCache().get("defprojectid");
            if (controlFilters != null) {
                List filters = controlFilters.getFilter("project.id");
                projectIdStr = filters.get(0).toString();
            }
            if (!StringUtils.isEmpty((CharSequence)projectIdStr)) {
                e.getParameter().setCustomParam("project", (Object)Long.parseLong(projectIdStr));
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeListModel treemodel = (TreeListModel)this.getTreeListView().getTreeModel();
        treemodel.getQueryParas().put("order", "createtime asc");
        super.refreshNode(e);
        long projectId = this.getSelectProjectId();
        if (projectId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        treemodel.getTreeFilter().add(qFilter);
    }

    public void initializeTree(EventObject e) {
        this.cacheDefProject();
        super.initializeTree(e);
    }

    private void cacheDefProject() {
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])qFilters, (String)"number", (int)1);
        if (!query.isEmpty()) {
            String id = ((DynamicObject)query.get(0)).getString("id");
            this.getPageCache().put("defprojectid", id);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long projectId = this.getSelectProjectId();
        if (projectId != 0L) {
            DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectId, (String)"bd_project", (String)"number,name");
            this.getTreeModel().getRoot().setText(project.getString("name") + '(' + project.getString("number") + ')');
        }
    }

    private long getSelectProjectId() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        for (QFilter qFilter : qFilters) {
            Object value;
            if (!StringUtils.equals((CharSequence)"project.id", (CharSequence)qFilter.getProperty()) || !((value = qFilter.getValue()) instanceof Long)) continue;
            return Long.parseLong(qFilter.getValue().toString());
        }
        if (!qFilters.isEmpty()) {
            return 0L;
        }
        ControlFilters controlFilters = this.getControlFilters();
        String projectIdStr = this.getPageCache().get("defprojectid");
        if (controlFilters != null) {
            List filters = controlFilters.getFilter("project.id");
            if (filters == null || filters.isEmpty()) {
                filters = controlFilters.getFilter("project.number");
                if (filters == null || filters.isEmpty()) {
                    return 0L;
                }
                String projectNum = filters.get(0).toString();
                QFilter qFilter = new QFilter("number", "=", (Object)projectNum);
                DynamicObject project = QueryServiceHelper.queryOne((String)"bd_project", (String)"id", (QFilter[])qFilter.toArray());
                if (project != null) {
                    projectIdStr = project.getString("id");
                }
            } else {
                projectIdStr = filters.get(0).toString();
            }
        }
        if (StringUtils.isEmpty((CharSequence)projectIdStr)) {
            return 0L;
        }
        return Long.parseLong(projectIdStr);
    }
}

