/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    private static final String BOS_ORG = "bos_org";
    private static final String FISBANKROLL = "fisbankroll";

    public static DynamicObject getCurrentPermOrg(String permissionEntity, String permissionItem) throws KDBizException {
        MainEntityType orgType;
        DynamicObject currentOrg;
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long orgId = RequestContext.get().getOrgId();
        int res = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)orgId, (String)permissionEntity, (String)permissionItem);
        if (res == 1 && (currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)(orgType = EntityMetadataCache.getDataEntityType((String)BOS_ORG)))).getBoolean(FISBANKROLL)) {
            return currentOrg;
        }
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(userId, null, permissionEntity, permissionItem);
        if (orgList.size() > 0) {
            return (DynamicObject)orgList.get(0);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff01", (String)"OrgHelper_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String appId, String entityID, String permissionItem) {
        List<Long> orgIdList = OrgHelper.getCacheUserPermission(userID, appId, entityID, permissionItem);
        QFilter filter = new QFilter(FISBANKROLL, "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"));
        if (orgIdList != null) {
            filter = filter.and(new QFilter("id", "in", orgIdList));
        }
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG, (QFilter[])filter.toArray());
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)BOS_ORG);
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (Map.Entry entry : orgMap.entrySet()) {
            orgColl.add(entry.getValue());
        }
        return orgColl;
    }

    public static List<Long> getCacheUserPermission(Long userId, String appId, String entityId, String permItem) {
        List orgIdsList = new ArrayList();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("base", new DistributeCacheHAPolicy());
        String key = String.valueOf(userId) + "-" + entityId + "-" + permItem;
        cache.remove(key);
        String value = (String)cache.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            HasPermOrgResult result;
            if (StringUtils.isNotEmpty((CharSequence)appId)) {
                appId = AppMetadataCache.getAppInfo((String)appId).getId();
            }
            if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem)).hasAllOrgPerm()) {
                return null;
            }
            orgIdsList = result.getHasPermOrgs();
            cache.put(key, (Object)JSON.toJSONString(orgIdsList), 60);
        } else {
            String json = (String)cache.get(key);
            orgIdsList = JSON.parseArray((String)json, Long.class);
        }
        return orgIdsList;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String appId, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, appId, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }
}

