/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.model.BankAccountModel;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasedataController;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BankAccountAuthFilterController
extends AbstractBasedataController {
    private static Log logger = LogFactory.getLog(BankAccountAuthFilterController.class);
    private static final String FILTER_TRANSFER_VIEW_ORG = "filterTransferViewOrg";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        ListShowParameter listShowParameter = event.getListShowParameter();
        List billListFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (billListFilters != null) {
            this.addInnerAccountIsolateFilter(event, listShowParameter);
        }
    }

    private void addInnerAccountIsolateFilter(BaseDataCustomControllerEvent event, ListShowParameter listShowParameter) {
        List<Long> selectOrgIds;
        String formId = listShowParameter.getBillFormId();
        if ((Objects.equals(formId, "bd_accountbanks") || Objects.equals(formId, "am_accountbank")) && !CollectionUtils.isEmpty(selectOrgIds = this.getSelectOrgIds(event.getListShowParameter().getPageId(), listShowParameter))) {
            if (listShowParameter.getCustomParam(FILTER_TRANSFER_VIEW_ORG) != null || StringUtils.isNotEmpty((CharSequence)listShowParameter.getParentFormId()) && BankAccountModel.CAS_FILTER_VIEW_ORG_BILL_ENTITY.contains(listShowParameter.getParentFormId())) {
                String entryOrgKey = String.join((CharSequence)".", "transfervieworgentry", "transfervieworg");
                event.addQFilter(new QFilter(entryOrgKey, "is null", null).or(entryOrgKey, "not in", selectOrgIds));
            }
            if (Objects.equals(this.getAppId(event), "ifm") || Objects.equals(this.getAppId(event), "fca")) {
                return;
            }
            Map<String, Map<String, Object>> stringMapMap = this.loadBatchAppParameterByOrg(selectOrgIds);
            List queryOrg = stringMapMap.entrySet().stream().filter(entry -> {
                Map value = (Map)entry.getValue();
                if (value == null) {
                    return false;
                }
                Boolean showInnerAccount = (Boolean)value.get("isshowinternalaccount");
                return showInnerAccount != null && showInnerAccount == false;
            }).map(s -> Long.parseLong((String)s.getKey())).collect(Collectors.toList());
            if (queryOrg.size() == 0) {
                return;
            }
            HashSet<Long> acctBankIdNotNeed = new HashSet<Long>(16);
            QFilter filter = new QFilter("finorgtype", "=", (Object)"1");
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBankAcct", (String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("company", "in", queryOrg), filter}, null);){
                while (ds.hasNext()) {
                    acctBankIdNotNeed.add(ds.next().getLong("id"));
                }
            }
            if (acctBankIdNotNeed.size() > 0) {
                event.addQFilter(new QFilter("id", "not in", acctBankIdNotNeed));
            }
        }
    }

    private Map<String, Map<String, Object>> loadBatchAppParameterByOrg(List<Long> selectCompanyIds) {
        AppParam param = new AppParam();
        param.setViewType("08");
        param.setAppId(AppMetadataCache.getAppInfo((String)"am").getId());
        return SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)param, selectCompanyIds);
    }

    private List<Long> getSelectOrgIds(String pageId, ListShowParameter listShowParameter) {
        List billListFilters = listShowParameter.getListFilterParameter().getQFilters();
        long selectOrg = 0L;
        List<Long> selectOrgIds = new ArrayList<Long>();
        boolean isContainsIdFilter = billListFilters.stream().filter(Objects::nonNull).map(QFilter::getProperty).anyMatch(p -> p.equals("id"));
        if (listShowParameter.getUseOrgId() > 0L) {
            selectOrgIds.add(listShowParameter.getUseOrgId());
        } else {
            boolean isContainsCompanyFilter = billListFilters.stream().filter(Objects::nonNull).map(QFilter::getProperty).anyMatch(p -> p.equals("company.id"));
            if (isContainsCompanyFilter) {
                List<Long> orgIds = this.getSelectOrgFilterPanel(billListFilters);
                if (!CollectionUtils.isEmpty(orgIds)) {
                    selectOrgIds.addAll(orgIds);
                }
            } else if (CollectionUtils.isEmpty((Collection)billListFilters) || !isContainsIdFilter) {
                String createOrg = new PageCache(pageId).get("createOrg");
                logger.info("\u9875\u9762\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u7684createOrg = {}", (Object)createOrg);
                if (StringUtils.isNotEmpty((CharSequence)createOrg) && (selectOrg = Long.parseLong(createOrg)) > 0L) {
                    selectOrgIds.add(selectOrg);
                }
            } else {
                selectOrgIds = this.getSelectOrg(billListFilters);
            }
        }
        return selectOrgIds;
    }

    private List<Long> getSelectOrgFilterPanel(List<QFilter> billListFilters) {
        for (QFilter billListFilter : billListFilters) {
            if (Objects.isNull(billListFilter) || !Objects.equals("company.id", billListFilter.getProperty())) continue;
            return (List)billListFilter.getValue();
        }
        return Collections.emptyList();
    }

    private String getAppId(BaseDataCustomControllerEvent event) {
        String appId = event.getListShowParameter().getAppId();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            if (event.getSource() instanceof BasedataEdit || event.getSource() instanceof MulBasedataEdit) {
                appId = ((FieldEdit)event.getSource()).getModel().getDataEntityType().getAppId();
            } else if (event.getSource() instanceof BillList) {
                appId = event.getListShowParameter().getParentFormId();
            }
        }
        logger.info("event.getSource()\u7c7b\u578b = {}\uff0cappId = {}", (Object)event.getSource().getClass().getName(), (Object)appId);
        return appId;
    }

    private List<Long> getSelectOrg(List<QFilter> qFilters) {
        ArrayList<Long> selectOrgId = new ArrayList<Long>(8);
        for (QFilter qFilter : qFilters) {
            String s;
            List<Long> orgList;
            if (Objects.isNull(qFilter) || !Objects.equals("id", qFilter.getProperty()) || !qFilter.toString().contains("t_bd_accountbanks_U") || (orgList = this.buildOrgs(s = qFilter.toString())) == null || orgList.size() <= 0) continue;
            selectOrgId.addAll(orgList);
        }
        return selectOrgId;
    }

    private List<Long> buildOrgs(String arg) {
        ArrayList<Long> list;
        block5: {
            String[] sp2;
            String oneOrgF;
            block4: {
                String[] sp;
                list = new ArrayList<Long>(8);
                if (StringUtils.isBlank((CharSequence)arg)) {
                    return list;
                }
                String moreOrgF = "fuseorgidin(";
                oneOrgF = "fuseorgid=";
                if ((arg = arg.replaceAll(" ", "")).indexOf(moreOrgF) < 0) break block4;
                for (String s : sp = arg.split("fuseorgidin\\(")) {
                    String[] userorgids;
                    int index = s.indexOf(41, 1);
                    if (index <= 0) continue;
                    String userorgidStr = s.substring(0, index).trim();
                    for (String userorgid : userorgids = userorgidStr.split(",")) {
                        list.add(Long.parseLong(userorgid));
                    }
                }
                break block5;
            }
            if (arg.indexOf(oneOrgF) < 0) break block5;
            for (String s : sp2 = arg.split(oneOrgF)) {
                int index = s.indexOf(41, 1);
                if (index <= 0) continue;
                String userorgidStr = s.substring(0, index).trim();
                list.add(Long.parseLong(userorgidStr));
            }
        }
        return list;
    }
}

