/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bd.assistant.plugin.basedata.FinOrgTypeTreeListPlugin;
import kd.bd.assistant.plugin.helper.CountryHelper;
import kd.bd.assistant.plugin.model.TreeNodeModel;
import kd.bd.assistant.plugin.model.TreeNodeRefModel;
import kd.bd.assistant.plugin.model.TreeNodeTypeModel;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FinOrgInfoTreeListPlugin
extends FinOrgTypeTreeListPlugin {
    public static final String KEY_COUNTRYNUM = "KEY_COUNTRYNUM";
    public static final String KEY_CURRNODEID = "KEY_CURRNODEID";
    public static final String POINT_NUMBER = ".number";
    public static final String POINT_NAME = ".name";
    protected static final TreeNodeTypeModel NODE_FINTYPE = new TreeNodeTypeModel("fintype", TreeNodeTypeModel.ROOT, TreeNodeTypeModel.LeafMode.NON_LEAF);
    protected static final TreeNodeTypeModel NODE_BANKCATE = new TreeNodeTypeModel("bankcate", TreeNodeTypeModel.ROOT, TreeNodeTypeModel.LeafMode.LEAF);
    protected static final TreeNodeTypeModel NODE_COUNTRY = new TreeNodeTypeModel("country", NODE_BANKCATE, TreeNodeTypeModel.LeafMode.NON_LEAF);
    protected static final TreeNodeTypeModel NODE_PROVINCE = new TreeNodeTypeModel("province", NODE_COUNTRY, TreeNodeTypeModel.LeafMode.NON_LEAF);
    protected static final TreeNodeTypeModel NODE_CITY = new TreeNodeTypeModel("city", NODE_PROVINCE, TreeNodeTypeModel.LeafMode.LEAF);
    protected static final TreeNodeTypeModel NODE_FINORG = new TreeNodeTypeModel("finorg", NODE_FINTYPE, TreeNodeTypeModel.LeafMode.REQUEST);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("treetype");
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent tabSelectEvent) {
                FinOrgInfoTreeListPlugin.this.forceRefreshTree(true);
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        Object resin = sp.getCustomParam("resin");
        this.getView().setVisible(Boolean.valueOf(resin != null), new String[]{"resinlink"});
    }

    @Override
    protected List<TreeNodeTypeModel> getTreeNodeTypeList() {
        return Arrays.asList(NODE_FINTYPE, NODE_BANKCATE, NODE_COUNTRY, NODE_PROVINCE, NODE_CITY, NODE_FINORG);
    }

    @Override
    protected QFilter getBillListFilter(TreeNodeModel currNode) {
        QFilter filter = null;
        TreeNodeTypeModel nodeType = currNode.getNodeType();
        Object refId = currNode.getRefEntityPkValue();
        Object currCateId = currNode.getParentRefEntityPkValue(NODE_BANKCATE);
        if (NODE_FINTYPE.equals((Object)nodeType)) {
            filter = this.getFinTypeIdFilter(refId);
        } else if (NODE_BANKCATE.equals((Object)nodeType)) {
            QFilter finTypeFilter = this.getFinTypeFilter(currNode);
            if (Objects.nonNull(finTypeFilter)) {
                filter = finTypeFilter.and(this.getBankCateFilter(currCateId));
            }
        } else if (NODE_COUNTRY.equals((Object)nodeType)) {
            filter = this.getCountryFiler(refId);
        } else if (NODE_PROVINCE.equals((Object)nodeType)) {
            filter = this.getProvinceFilter(refId);
        } else if (NODE_CITY.equals((Object)nodeType)) {
            filter = this.getCityFilter(refId);
        } else if (NODE_FINORG.equals((Object)nodeType)) {
            DynamicObject finOrg = BusinessDataServiceHelper.loadSingle((Object)refId, (String)"bd_finorginfo");
            QFilter finTypeFilter = this.getFinTypeFilter(currNode);
            if (Objects.nonNull(finTypeFilter)) {
                filter = finTypeFilter.and(this.getFinOrgFilter(finOrg.getString("longnumber")));
            }
        }
        return filter;
    }

    @Override
    protected List<TreeNodeRefModel> loadTreeNodeList(TreeNodeModel currNode) {
        List<TreeNodeRefModel> modelList = null;
        TreeNodeTypeModel nodeType = currNode.getNodeType();
        Tab tryTypeTab = (Tab)this.getControl("treetype");
        String treeType = tryTypeTab.getCurrentTab();
        if (TreeNodeTypeModel.ROOT.equals((Object)nodeType)) {
            modelList = "bytype".equals(treeType) ? this.loadFinTypeNodeList() : this.loadBankCountryData();
        } else if (NODE_FINTYPE.equals((Object)nodeType)) {
            Object finTypeId = currNode.getParentRefEntityPkValue(NODE_FINTYPE);
            DynamicObject finOrgType = BusinessDataServiceHelper.loadSingle((Object)finTypeId, (String)"bd_finorgtype");
            String finOrgTypeStr = finOrgType.getString("type");
            modelList = StringUtils.equals((CharSequence)"0", (CharSequence)finOrgTypeStr) ? this.loadBankCateNodeList(currNode) : this.loadFirstLevelFinOrgList(currNode);
        } else if (NODE_BANKCATE.equals((Object)nodeType)) {
            modelList = null;
        } else if (NODE_COUNTRY.equals((Object)nodeType) || NODE_PROVINCE.equals((Object)nodeType)) {
            modelList = this.loadBankAdminDivisionData(currNode);
        } else if (NODE_FINORG.equals((Object)nodeType)) {
            modelList = this.loadFinOrgList(currNode);
        }
        return modelList;
    }

    @Override
    protected boolean getNodeIsLeaf(TreeNodeRefModel nodeRefModel) {
        TreeNodeTypeModel nodeType = nodeRefModel.getNodeType();
        if (NODE_FINORG.equals((Object)nodeType)) {
            Object finOrgId = nodeRefModel.getRefEntityPkValue();
            DynamicObject finOrg = BusinessDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo");
            boolean isLeaf = finOrg.getBoolean("is_leaf");
            return isLeaf;
        }
        return super.getNodeIsLeaf(nodeRefModel);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        Object nodeId = e.getNodeId();
        this.getPageCache().put(KEY_CURRNODEID, nodeId.toString());
    }

    @Override
    public void expendTreeNode(TreeNodeEvent e) {
        super.expendTreeNode(e);
        Object nodeId = e.getNodeId();
        this.getPageCache().put(KEY_CURRNODEID, nodeId.toString());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String currNodeId = this.getPageCache().get(KEY_CURRNODEID);
        if (currNodeId != null) {
            this.getTreeModel().setCurrentNodeId((Object)currNodeId);
            TreeNodeModel model = this.getCurrentNodeModel();
            Object finTypeId = model.getParentRefEntityPkValue(NODE_FINTYPE);
            OperationStatus status = e.getParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                BillShowParameter sp = e.getParameter();
                sp.setCustomParam("finTypeId", finTypeId);
            }
        }
    }

    private List<TreeNodeRefModel> loadFinTreeNodeList(String idField, String nameField, String numberField, TreeNodeTypeModel nodeType, QFilter[] qFilters, DatasetIteratorCallback callback) {
        ArrayList<TreeNodeRefModel> modelList = new ArrayList<TreeNodeRefModel>();
        StringBuilder selectFieldStr = new StringBuilder(idField);
        ArrayList<String> groupByList = new ArrayList<String>(Collections.singletonList(idField));
        if (nameField != null) {
            selectFieldStr.append(',').append(nameField);
            groupByList.add(nameField);
        }
        if (numberField != null) {
            selectFieldStr.append(',').append(numberField);
            groupByList.add(numberField);
        }
        GroupbyDataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_finorginfo", (String)selectFieldStr.toString(), (QFilter[])qFilters, (String)idField).groupBy(groupByList.toArray(new String[0]));
        DataSet result = ds.finish();
        for (Row row : result) {
            TreeNodeRefModel refModel = new TreeNodeRefModel();
            refModel.setNodeName(row.getString(nameField == null ? idField : nameField));
            refModel.setNodeType(nodeType);
            refModel.setRefEntityPkValue((Object)row.getString(idField));
            modelList.add(refModel);
            if (callback == null) continue;
            callback.handleRowData(row);
        }
        return modelList;
    }

    private List<TreeNodeRefModel> loadBankCateNodeList(TreeNodeModel model) {
        return this.loadFinTreeNodeList("bank_cate", "bank_cate.name", "bank_cate.number", NODE_BANKCATE, new QFilter[]{this.getFinTypeFilter(model)}, null);
    }

    private List<TreeNodeRefModel> loadFinTypeNodeList() {
        Object finTypeId = this.getView().getFormShowParameter().getCustomParam("finType");
        QFilter finTypeFilter = null;
        if (finTypeId != null) {
            finTypeFilter = this.getFinTypeIdFilter(finTypeId);
        }
        return this.loadFinTreeNodeList("finorgtype", "finorgtype.name", "finorgtype.number", NODE_FINTYPE, new QFilter[]{finTypeFilter}, null);
    }

    private List<TreeNodeRefModel> loadBankCountryData() {
        List<TreeNodeRefModel> list = this.loadFinTreeNodeList("country", "country.name", "country.number", NODE_COUNTRY, new QFilter[0], row -> {
            String countryNumber = row.getString("country.number");
            this.getPageCache().put(KEY_COUNTRYNUM + row.getString("country"), countryNumber);
        });
        return list;
    }

    private List<TreeNodeRefModel> loadBankAdminDivisionData(TreeNodeModel model) {
        String countryNumber;
        boolean isChinaMainland;
        TreeNodeTypeModel nodeType = model.getNodeType();
        Object refId = model.getRefEntityPkValue();
        List<TreeNodeRefModel> nodeList = NODE_COUNTRY.equals((Object)nodeType) ? ((isChinaMainland = CountryHelper.isChina((String)(countryNumber = this.getPageCache().get(KEY_COUNTRYNUM + model.getRefEntityPkValue())))) ? this.loadFinTreeNodeList("province", "province.name", "province.number", NODE_PROVINCE, new QFilter[]{this.getCountryFiler(refId)}, null) : this.loadFinTreeNodeList("city", "city.name", "city.number", NODE_CITY, new QFilter[]{this.getCountryFiler(refId)}, null)) : (NODE_PROVINCE.equals((Object)nodeType) ? this.loadFinTreeNodeList("city", "city.name", "city.number", NODE_CITY, new QFilter[]{this.getProvinceFilter(refId)}, null) : new ArrayList<TreeNodeRefModel>());
        return nodeList;
    }

    private List<TreeNodeRefModel> loadFinOrgList(TreeNodeModel model) {
        Object refId = model.getRefEntityPkValue();
        Long longRefId = refId instanceof String ? Long.valueOf((String)refId) : (Long)refId;
        QFilter directChildFilter = new QFilter("parent", "=", (Object)longRefId);
        List<TreeNodeRefModel> list = this.loadFinTreeNodeList("id", "name", "number", NODE_FINORG, new QFilter[]{directChildFilter}, null);
        return list;
    }

    private List<TreeNodeRefModel> loadFirstLevelFinOrgList(TreeNodeModel model) {
        QFilter levelOneFilter = new QFilter("level", "=", (Object)1);
        List<TreeNodeRefModel> list = this.loadFinTreeNodeList("id", "name", "number", NODE_FINORG, new QFilter[]{this.getFinTypeFilter(model), levelOneFilter}, null);
        return list;
    }

    private QFilter getFinTypeIdFilter(Object finTypeId) {
        return new QFilter("finorgtype", "=", (Object)(finTypeId instanceof String ? Long.valueOf((String)finTypeId) : (Long)finTypeId));
    }

    private QFilter getBankCateFilter(Object cateId) {
        return new QFilter("bank_cate", "=", (Object)(cateId instanceof String ? Long.valueOf((String)cateId) : (Long)cateId));
    }

    private QFilter getCountryFiler(Object countryId) {
        return new QFilter("country", "=", (Object)(countryId instanceof String ? Long.valueOf((String)countryId) : (Long)countryId));
    }

    private QFilter getProvinceFilter(Object provinceId) {
        return new QFilter("province", "=", (Object)(provinceId instanceof String ? Long.valueOf((String)provinceId) : (Long)provinceId));
    }

    private QFilter getCityFilter(Object cityId) {
        return new QFilter("city", "=", (Object)(cityId instanceof String ? Long.valueOf((String)cityId) : (Long)cityId));
    }

    private QFilter getFinTypeFilter(TreeNodeModel model) {
        if (model.isRoot()) {
            return null;
        }
        QFilter finTypeFilter = null;
        Object finTypeId = model.getParentRefEntityPkValue(NODE_FINTYPE);
        if (finTypeId != null) {
            finTypeFilter = this.getFinTypeIdFilter(finTypeId);
        }
        return finTypeFilter;
    }

    private QFilter getFinOrgFilter(Object parentLongNumber) {
        return new QFilter("longnumber", "like", (Object)(parentLongNumber + "%"));
    }

    @FunctionalInterface
    private static interface DatasetIteratorCallback {
        public void handleRowData(Row var1);
    }
}

