/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.util.ListUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.BooleanColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProjectF7ListPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(ProjectF7ListPlugin.class);
    private static final String ISREMOVEPROCESSED = "isremoveprocessed";
    public static final String INCLUDE_OTHER_CLOUDS = "includeotherclouds";
    public static final String SHOWUPDATE = "showupdate";
    public static final String NEWPROJECTIDS = "newprojectids";
    private static final String OPEN_PROJECT_F7_INCLUDE_OTHER_CLOUD_PARAM_IDS = "open_project_f7_include_other_cloud_param_ids";
    private static final String OPEN_PROJECT_F7_PARAM_IDS = "open_project_f7_param_ids";

    public void afterCreateNewData(EventObject e) {
        String parentView;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isRemoveProcessed = (String)formShowParameter.getCustomParam(ISREMOVEPROCESSED);
        if (isRemoveProcessed != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ISREMOVEPROCESSED});
            this.getModel().setValue(ISREMOVEPROCESSED, (Object)Boolean.TRUE);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISREMOVEPROCESSED});
        }
        if (formShowParameter.getCustomParam(INCLUDE_OTHER_CLOUDS) != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INCLUDE_OTHER_CLOUDS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCLUDE_OTHER_CLOUDS});
        }
        boolean isVisible = Boolean.FALSE;
        Object customParam = formShowParameter.getCustomParam("parentview");
        if (customParam != null && StringUtils.equals((CharSequence)(parentView = customParam.toString()), (CharSequence)"pmbs_dataupgrade")) {
            isVisible = Boolean.TRUE;
            Set<Long> allNewProjectIds = this.getAllNewProjectIds();
            if (!allNewProjectIds.isEmpty()) {
                this.getPageCache().put(NEWPROJECTIDS, SerializationUtils.toJsonString(allNewProjectIds));
            }
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{SHOWUPDATE});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"isupdate"});
    }

    public void setFilter(SetFilterEvent e) {
        String showUpdate;
        List projectIds;
        e.getQFilters().forEach(filter -> LOG.info("setFilter#index:{},filter:{}", (Object)e.getQFilters().indexOf(filter), e.getQFilters().get(e.getQFilters().indexOf(filter))));
        String isRemoveProcessed = this.getPageCache().get(ISREMOVEPROCESSED);
        this.getPageCache().remove(ISREMOVEPROCESSED);
        List qFilterList = e.getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam(INCLUDE_OTHER_CLOUDS) != null && formShowParameter.getCustomParam(INCLUDE_OTHER_CLOUDS) instanceof Boolean && ((Boolean)formShowParameter.getCustomParam(INCLUDE_OTHER_CLOUDS)).booleanValue()) {
            QFilter projectIdFilter = (Boolean)this.getModel().getValue(INCLUDE_OTHER_CLOUDS) != false ? new QFilter("id", "in", this.getProjectIdListBySystemProperty(formShowParameter.getCustomParam(OPEN_PROJECT_F7_INCLUDE_OTHER_CLOUD_PARAM_IDS), e.getQFilters())) : new QFilter("id", "in", this.getProjectIdListBySystemProperty(formShowParameter.getCustomParam(OPEN_PROJECT_F7_PARAM_IDS), e.getQFilters()));
            qFilterList.add(projectIdFilter);
        }
        if ((projectIds = (List)formShowParameter.getCustomParam("projectId")) != null) {
            if (isRemoveProcessed != null && isRemoveProcessed.equals("true")) {
                QFilter projectFilter = new QFilter("id", "not in", (Object)projectIds.toArray());
                qFilterList.add(projectFilter);
            } else {
                boolean flag = (Boolean)this.getModel().getValue(ISREMOVEPROCESSED);
                if (flag) {
                    QFilter projectFilter = new QFilter("id", "not in", (Object)projectIds.toArray());
                    qFilterList.add(projectFilter);
                }
            }
        }
        Set allNewProjectIds = new HashSet();
        String newProjectIdStr = this.getPageCache().get(NEWPROJECTIDS);
        if (StringUtils.isNotEmpty((CharSequence)newProjectIdStr)) {
            allNewProjectIds = (Set)SerializationUtils.fromJsonString((String)newProjectIdStr, Set.class);
        }
        if (StringUtils.equals((CharSequence)(showUpdate = this.getPageCache().get(SHOWUPDATE)), (CharSequence)"update")) {
            if (!allNewProjectIds.isEmpty()) {
                qFilterList.add(new QFilter("id", "in", allNewProjectIds));
            } else {
                qFilterList.add(new QFilter("id", "=", (Object)0L));
            }
        } else if (StringUtils.equals((CharSequence)showUpdate, (CharSequence)"unupdate") && !allNewProjectIds.isEmpty()) {
            qFilterList.add(new QFilter("id", "not in", allNewProjectIds));
        }
        super.setFilter(e);
    }

    public void packageData(PackageDataEvent e) {
        BooleanColumnDesc columnDesc;
        Object source;
        super.packageData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("parentview");
        if (customParam == null) {
            return;
        }
        String showUpdate = this.getPageCache().get(SHOWUPDATE);
        DynamicObject rowData = e.getRowData();
        if (rowData == null) {
            return;
        }
        boolean isUpdate = false;
        String newProjectIdStr = this.getPageCache().get(NEWPROJECTIDS);
        if (StringUtils.isNotEmpty((CharSequence)newProjectIdStr)) {
            Set allNewProjectIds = (Set)SerializationUtils.fromJsonString((String)newProjectIdStr, Set.class);
            if (StringUtils.isEmpty((CharSequence)showUpdate) || StringUtils.equals((CharSequence)showUpdate, (CharSequence)"all")) {
                long pk = Long.parseLong(rowData.getPkValue().toString());
                if (allNewProjectIds.contains(pk)) {
                    isUpdate = true;
                }
            } else {
                isUpdate = StringUtils.equals((CharSequence)"update", (CharSequence)showUpdate);
            }
        }
        if ((source = e.getSource()) instanceof BooleanColumnDesc && StringUtils.equals((CharSequence)(columnDesc = (BooleanColumnDesc)source).getKey(), (CharSequence)"isupdate")) {
            e.setFormatValue((Object)isUpdate);
        }
    }

    private Set<Long> getAllNewProjectIds() {
        Set proIds;
        Set proIds2;
        HashSet<Long> projectIds = new HashSet<Long>();
        QFilter qFilter = new QFilter("tproject", "!=", (Object)0L);
        DynamicObject[] totalBudgetCtrl = BusinessDataServiceHelper.load((String)"pmas_totalbudgetctrl", (String)"tproject", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrl.length > 0 && !(proIds2 = Arrays.stream(totalBudgetCtrl).filter(o -> o.getDynamicObject("tproject") != null).map(o -> Long.parseLong(o.getDynamicObject("tproject").getPkValue().toString())).collect(Collectors.toSet())).isEmpty()) {
            projectIds.addAll(proIds2);
        }
        qFilter = new QFilter("yproject", "!=", (Object)0L);
        DynamicObject[] yearBudgetCtrl = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrl", (String)"yproject", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrl.length > 0 && !(proIds = Arrays.stream(yearBudgetCtrl).filter(o -> o.getDynamicObject("yproject") != null).map(o -> Long.parseLong(o.getDynamicObject("yproject").getPkValue().toString())).collect(Collectors.toSet())).isEmpty()) {
            projectIds.addAll(proIds);
        }
        return projectIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (ISREMOVEPROCESSED.equals(name)) {
            if (((Boolean)newValue).booleanValue()) {
                this.getPageCache().put(ISREMOVEPROCESSED, "true");
            } else {
                this.getPageCache().put(ISREMOVEPROCESSED, "false");
            }
            this.getView().updateView("billlistap");
        } else if (StringUtils.equals((CharSequence)INCLUDE_OTHER_CLOUDS, (CharSequence)name)) {
            this.getView().updateView("billlistap");
        } else if (StringUtils.equals((CharSequence)SHOWUPDATE, (CharSequence)name)) {
            this.getPageCache().put(SHOWUPDATE, newValue.toString());
            this.getView().updateView("billlistap");
        }
    }

    private List<Object> getProjectIdListBySystemProperty(Object projectIdsCustomParam, List<QFilter> publicFilterList) {
        ArrayList<Object> projectIdsBySystemProperty = new ArrayList<Object>(10);
        ArrayList projectIds = new ArrayList((JSONArray)projectIdsCustomParam);
        String maxsize = System.getProperty("orm.opt.in.maxsize");
        int length = 10000;
        if (!StringUtils.isEmpty((CharSequence)maxsize)) {
            length = Integer.parseInt(maxsize);
        }
        List partitionProjectIds = ListUtil.divideList(projectIds, (int)length);
        for (List subProjectIds : partitionProjectIds) {
            ArrayList<QFilter> subFilterList = new ArrayList<QFilter>(10);
            subFilterList.add(new QFilter("id", "in", (Object)subProjectIds));
            subFilterList.addAll(publicFilterList);
            projectIdsBySystemProperty.addAll(QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])subFilterList.toArray(new QFilter[0])).stream().map(pro -> pro.get("id")).collect(Collectors.toList()));
        }
        int maxreturndataSize = ParameterReader.getBillParameter((String)"bd_project").getInt("maxreturndata");
        if (maxreturndataSize < projectIdsBySystemProperty.size()) {
            projectIdsBySystemProperty.subList(0, maxreturndataSize);
        }
        LOG.info("projectIdsBySystemProperty,size:{},ids:{},", (Object)projectIdsBySystemProperty.size(), projectIdsBySystemProperty);
        return projectIdsBySystemProperty;
    }
}

