/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProjectKindListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_PROJECTKINDNUMBER = "projectkindnumber";
    public static final String FIELD_PROJECTKINDNUMBERID = "projectkindnumber_id";
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_ID = "id";
    public static final String FIELD_ISLEAF = "isleaf";
    public static final String KEY_TREEENTRYENTITY = "projectkindentity";
    public static final String SELECTED_FIELDS = "id,number,name,isleaf,enable,parent,level";
    public static final String METADATA_PROJECTKIND = "bd_projectkind";
    private static final String OPERATE_DELETE = "dodelete";
    private static final String OPERATE_ENABLE = "doenable";
    private static final String OPERATE_DISABLE = "dodisable";
    private static final String OPERATE_RETURNDATA = "doreturndata";
    private static final String OPERATE_NEW = "new";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String OPERATE_CLOSE = "close";
    private static final int MAXLEVEL = 99;
    private static final String CALLBACKKEY_ADDNEW = "projectkind_addnew";
    private static final String CALLBACKKEY_DISABLE = "projectkind_disable";
    private static final String CALLBACKKEY_DELETE = "projectkind_delete";
    private Log log = LogFactory.getLog(ProjectKindListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.initList(e.getQFilters());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        args.getListSelectedData();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (int rowIndex : selectRows) {
            pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
        }
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        switch (operateKey) {
            case "new": {
                if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u4e2d\u591a\u884c\u65b0\u589e", (String)"ProjectKindListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectRows.length != 1) break;
                DynamicObject row = (DynamicObject)gridRows.get(selectRows[0]);
                DynamicObject projectKind = row.getDynamicObject(FIELD_PROJECTKINDNUMBER);
                String isEnable = projectKind.getString(FIELD_ENABLE);
                if ("0".equals(isEnable)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"ProjectKindListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean isRefrence = this.isRefrenced(projectKind.getPkValue());
                if (isRefrence) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"ProjectKindListPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                int level = projectKind.getInt(FIELD_LEVEL);
                if (level < 99) break;
                String formatText = String.format(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u7ea7\u6b21\u4e3a\u6700\u5927\u7ea7\u6b21[%s\u7ea7]\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"ProjectKindListPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), 99);
                this.getView().showTipNotification(formatText);
                args.setCancel(true);
                break;
            }
            case "doenable": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ProjectKindListPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doEnable(projectKinds);
                break;
            }
            case "dodisable": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ProjectKindListPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doDisable(projectKinds);
                break;
            }
            case "dodelete": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ProjectKindListPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doDelete(projectKinds);
                break;
            }
            case "doreturndata": {
                if (selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"ProjectKindListPlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doReturnData(projectKinds);
                break;
            }
        }
    }

    private boolean isRefrenced(Object pkValue) {
        boolean isRefrenced = false;
        try {
            QFilter projectApprovalFilter = new QFilter("kind", "=", pkValue);
            isRefrenced = isRefrenced || QueryServiceHelper.exists((String)"pmas_pro_approval", (QFilter[])new QFilter[]{projectApprovalFilter});
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        QFilter projectFilter = new QFilter("group", "=", pkValue);
        isRefrenced = isRefrenced || QueryServiceHelper.exists((String)"bd_project", (QFilter[])new QFilter[]{projectFilter});
        return isRefrenced;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (int rowIndex : selectRows) {
            pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
        }
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        if (CALLBACKKEY_DISABLE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.confirmDisable(projectKinds);
        } else if (CALLBACKKEY_DELETE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.confirmDelete(projectKinds);
        }
    }

    private void confirmDelete(DynamicObject[] projectKinds) {
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        HashSet<Object> deleteIds = new HashSet<Object>();
        LinkedList<Object> parentIdList = new LinkedList<Object>();
        for (DynamicObject projectKind : projectKinds) {
            String isEnable = projectKind.getString(FIELD_ENABLE);
            if ("1".equals(isEnable)) {
                String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProjectKindListPlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                failMessage.append(formatText);
                ++failCount;
                continue;
            }
            if (this.isRefrenced(projectKind.getPkValue())) {
                String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u3002", (String)"ProjectKindListPlugin_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                failMessage.append(formatText);
                ++failCount;
                continue;
            }
            boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
            if (!isLeaf) {
                DynamicObject leaf;
                HashSet<DynamicObject> leafSons = new HashSet<DynamicObject>();
                ArrayList<Object> queryParentList = new ArrayList<Object>();
                queryParentList.add(projectKind.getPkValue());
                this.getAllLeafSons(leafSons, queryParentList);
                boolean isRefrenced = false;
                Iterator<DynamicObject> iterator = leafSons.iterator();
                while (iterator.hasNext() && !(isRefrenced = this.isRefrenced((leaf = iterator.next()).getPkValue()))) {
                }
                if (isRefrenced) {
                    String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u5176\u4e0b\u6e38\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u3002", (String)"ProjectKindListPlugin_8", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                    failMessage.append(formatText);
                    ++failCount;
                    continue;
                }
            }
            deleteIds.add(projectKind.getPkValue());
            DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
            if (parent == null) continue;
            parentIdList.add(parent.getPkValue());
        }
        parentIdList.removeAll(deleteIds);
        QFilter qFilter = new QFilter(FIELD_ID, "in", parentIdList);
        DynamicObject[] parents = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
        this.deleteProjectKind(deleteIds, parents);
        if (failCount > 0) {
            if (projectKinds.length == 1) {
                this.getView().showTipNotification(failMessage.toString());
            } else {
                String formatText = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u5220\u9664%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ProjectKindListPlugin_9", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKinds.length, deleteIds.size(), failCount);
                this.getView().showConfirm(formatText, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ProjectKindListPlugin_10", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation(OPERATE_REFRESH);
    }

    private void confirmDisable(DynamicObject[] projectKinds) {
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        HashSet<DynamicObject> updateList = new HashSet<DynamicObject>();
        ArrayList<Object> parentIds = new ArrayList<Object>();
        for (DynamicObject projectKind : projectKinds) {
            String isEnable = projectKind.getString(FIELD_ENABLE);
            if ("0".equals(isEnable)) {
                String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjectKindListPlugin_11", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                failMessage.append(formatText);
                ++failCount;
                continue;
            }
            boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
            if (!isLeaf) {
                parentIds.add(projectKind.getPkValue());
            }
            projectKind.set(FIELD_ENABLE, (Object)"0");
            updateList.add(projectKind);
        }
        this.addAllEnableSons(updateList, parentIds);
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        if (failCount > 0) {
            if (projectKinds.length == 1) {
                this.getView().showTipNotification(failMessage.toString());
            } else {
                String formatText = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ProjectKindListPlugin_12", (String)"bd-assistant-formplugin", (Object[])new Object[0]), updateList.size() + failCount, updateList.size(), failCount);
                this.getView().showConfirm(formatText, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"ProjectKindListPlugin_13", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation(OPERATE_REFRESH);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW && selectRows != null && selectRows.length == 1) {
            HashMap<String, Object> parentInfo = new HashMap<String, Object>();
            parentInfo.put("key", FIELD_PARENT);
            parentInfo.put("value", ((DynamicObject)gridRows.get(selectRows[0])).getDynamicObject(FIELD_PROJECTKINDNUMBER).getPkValue());
            e.getParameter().setCustomParam("tree_parent_id", parentInfo);
            e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKKEY_ADDNEW));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "projectkind_addnew": {
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        int rowIndex = arg0.getRowIndex();
        if (FIELD_PROJECTKINDNUMBER.equals(fieldName)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
            showParameter.setFormId(METADATA_PROJECTKIND);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void initList(List<QFilter> filters) {
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])filters.toArray(new QFilter[0]));
        Arrays.sort(projectKinds, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString(ProjectKindListPlugin.FIELD_NAME).getLocaleValue() != null ? o1.getLocaleString(ProjectKindListPlugin.FIELD_NAME).getLocaleValue() : "";
                String target = o2.getLocaleString(ProjectKindListPlugin.FIELD_NAME).getLocaleValue() != null ? o2.getLocaleString(ProjectKindListPlugin.FIELD_NAME).getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        if (projectKinds != null && projectKinds.length > 0) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
            DynamicObjectType dt = entries.getDynamicObjectType();
            for (DynamicObject item : projectKinds) {
                DynamicObject newItem = new DynamicObject(dt);
                newItem.set(FIELD_ID, item.getPkValue());
                newItem.set("pid", item.getDynamicObject(FIELD_PARENT) == null ? Integer.valueOf(0) : item.getDynamicObject(FIELD_PARENT).getPkValue());
                newItem.set(FIELD_PROJECTKINDNUMBER, (Object)BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)METADATA_PROJECTKIND));
                entries.add((Object)newItem);
            }
            this.getModel().updateEntryCache(entries);
            this.getModel().updateCache();
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    private void addAllEnableSons(Set<DynamicObject> enableSonList, List<Object> parentIds) {
        if (parentIds != null && !parentIds.isEmpty()) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            qFilter.and(new QFilter(FIELD_ENABLE, "=", (Object)"1"));
            DynamicObject[] enableSons = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (enableSons != null && enableSons.length > 0) {
                for (DynamicObject son : enableSons) {
                    son.set(FIELD_ENABLE, (Object)"0");
                    enableSonList.add(son);
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(enableSonList, parentPkList);
        }
    }

    private void getAllLeafSons(Set<DynamicObject> leafSons, List<Object> parentIds) {
        if (parentIds != null && !parentIds.isEmpty()) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            DynamicObject[] sons = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (sons != null && sons.length > 0) {
                for (DynamicObject son : sons) {
                    if (son.getBoolean(FIELD_ISLEAF)) {
                        leafSons.add(son);
                        continue;
                    }
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(leafSons, parentPkList);
        }
    }

    private void deleteProjectKind(HashSet<Object> deleteIds, DynamicObject[] parents) {
        if (deleteIds != null && !deleteIds.isEmpty()) {
            this.addAllSons(deleteIds, deleteIds);
            QFilter controlSettingFilter = new QFilter("projectkind", "in", deleteIds);
            try {
                DeleteServiceHelper.delete((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{controlSettingFilter});
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
            QFilter majorTypeFilter = new QFilter("group", "in", deleteIds);
            try {
                DeleteServiceHelper.delete((String)"pmpm_majortype", (QFilter[])new QFilter[]{majorTypeFilter});
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)METADATA_PROJECTKIND), (Object[])deleteIds.toArray(new Object[deleteIds.size()]));
            LinkedList<DynamicObject> updateList = new LinkedList<DynamicObject>();
            for (DynamicObject parent : parents) {
                QFilter qFilter = new QFilter(FIELD_PARENT, "=", parent.getPkValue());
                DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)FIELD_ID, (QFilter[])new QFilter[]{qFilter});
                if (projectKinds != null && projectKinds.length != 0) continue;
                parent.set(FIELD_ISLEAF, (Object)Boolean.TRUE);
                updateList.add(parent);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
    }

    private void addAllSons(HashSet<Object> ids, HashSet<Object> parentIds) {
        DynamicObject[] sons = BusinessDataServiceHelper.load((String)METADATA_PROJECTKIND, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_PARENT, "in", parentIds)});
        HashSet<Object> parentPkList = new HashSet<Object>();
        if (sons != null && sons.length > 0) {
            for (DynamicObject son : sons) {
                if (!son.getBoolean(FIELD_ISLEAF)) {
                    parentPkList.add(son.getPkValue());
                }
                ids.add(son.getPkValue());
            }
            this.addAllSons(ids, parentPkList);
        }
    }

    private void doReturnData(DynamicObject[] projectKinds) {
        ListSelectedRowCollection returnData = new ListSelectedRowCollection();
        ListSelectedRow returnProjectKind = new ListSelectedRow(projectKinds[0].getPkValue(), Boolean.TRUE);
        returnData.add((Object)returnProjectKind);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().invokeOperation(OPERATE_CLOSE);
    }

    private void doDelete(DynamicObject[] projectKinds) {
        boolean hasChild = false;
        for (DynamicObject projectKind : projectKinds) {
            boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
            if (isLeaf) continue;
            hasChild = true;
            break;
        }
        if (hasChild) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u6b21\u5220\u9664\u5c06\u540c\u65f6\u5220\u9664\u6240\u6709\u4e0b\u7ea7\u9879\u76ee\u5206\u7c7b\u3001\u6240\u6709\u76f8\u5173\u57fa\u7840\u8bbe\u7f6e\u548c\u57fa\u7840\u8d44\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectKindListPlugin_14", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u6b21\u5220\u9664\u5c06\u540c\u65f6\u5220\u9664\u6240\u6709\u76f8\u5173\u57fa\u7840\u8bbe\u7f6e\u548c\u57fa\u7840\u8d44\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectKindListPlugin_15", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
        }
    }

    private void doDisable(DynamicObject[] projectKinds) {
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        boolean showConfirm = false;
        for (DynamicObject projectKind : projectKinds) {
            boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
            if (isLeaf) continue;
            showConfirm = true;
            break;
        }
        if (showConfirm) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"ProjectKindListPlugin_16", (String)"bd-assistant-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u4e2d\u9879\u76ee\u5206\u7c7b\u6709\u4e0b\u7ea7\u9879\u76ee\u5206\u7c7b\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u5176\u6240\u6709\u4e0b\u7ea7\u9879\u76ee\u5206\u7c7b\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectKindListPlugin_17", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKKEY_DISABLE, (IFormPlugin)this));
        } else {
            for (DynamicObject projectKind : projectKinds) {
                String isEnable = projectKind.getString(FIELD_ENABLE);
                if ("0".equals(isEnable)) {
                    String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjectKindListPlugin_11", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                    failMessage.append(formatText);
                    ++failCount;
                    continue;
                }
                projectKind.set(FIELD_ENABLE, (Object)"0");
                updateList.add(projectKind);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
            if (failCount > 0) {
                if (projectKinds.length == 1) {
                    this.getView().showTipNotification(failMessage.toString());
                } else {
                    String formatText = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ProjectKindListPlugin_12", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKinds.length, updateList.size(), failCount);
                    this.getView().showConfirm(formatText, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"ProjectKindListPlugin_13", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation(OPERATE_REFRESH);
        }
    }

    private void doEnable(DynamicObject[] projectKinds) {
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        for (DynamicObject projectKind : projectKinds) {
            String isEnable = projectKind.getString(FIELD_ENABLE);
            if ("1".equals(isEnable)) {
                String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"ProjectKindListPlugin_18", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                failMessage.append(formatText);
                ++failCount;
                continue;
            }
            DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
            if (parent != null && "0".equals(parent.getString(FIELD_ENABLE))) {
                String formatText = String.format(ResManager.loadKDString((String)"%s\uff1a\u7236\u8282\u70b9\u672a\u542f\u7528\u3002", (String)"ProjectKindListPlugin_19", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER));
                failMessage.append(formatText);
                ++failCount;
                continue;
            }
            projectKind.set(FIELD_ENABLE, (Object)"1");
            updateList.add(projectKind);
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        if (failCount > 0) {
            if (projectKinds.length == 1) {
                this.getView().showTipNotification(failMessage.toString());
            } else {
                String formatText = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u542f\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ProjectKindListPlugin_20", (String)"bd-assistant-formplugin", (Object[])new Object[0]), projectKinds.length, updateList.size(), failCount);
                this.getView().showConfirm(formatText, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"ProjectKindListPlugin_21", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation(OPERATE_REFRESH);
    }
}

