/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.enums.PaymentChannelEnum;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SettlementTypeFormPlugin
extends AbstractFormPlugin {
    public static final String OP_SAVE = "save";
    public static final String PROP_ISDEFAULT = "isdefault";

    public void afterDoOperation(AfterDoOperationEventArgs adoe) {
        super.afterDoOperation(adoe);
        String objectId = adoe.getObjectId();
        if (objectId.equals(OP_SAVE)) {
            Boolean isDefault;
            List successPkIds = adoe.getOperationResult().getSuccessPkIds();
            Long successPkId = 0L;
            if (successPkIds != null && successPkIds.size() != 0) {
                successPkId = Long.parseLong(String.valueOf(successPkIds.get(0)));
            }
            if ((isDefault = (Boolean)this.getModel().getValue(PROP_ISDEFAULT)).booleanValue()) {
                this.setDefault(successPkId);
            }
        }
    }

    private void setDefault(Long pkId) {
        String sql = "update T_BD_SettlementType set FIsDefault = 0 where fid <> ?";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{pkId});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String settlementType = (String)this.getModel().getValue("settlementtype");
        this.setComboItemsBySettlementType(settlementType);
    }

    private void setComboItemsBySettlementType(String settlementType) {
        if (Objects.equals(settlementType, "0") || Objects.equals(settlementType, "14")) {
            this.setComboItems(Collections.singletonList("counter"));
        } else {
            this.setComboItems(Arrays.asList("bei", "onlinebank", "counter"));
        }
    }

    private void setComboItems(List<String> paymentChannels) {
        List<ComboItem> comboItems = this.fillComboItems(paymentChannels);
        ComboEdit paymentChannelEdit = (ComboEdit)this.getView().getControl("paymentchannel");
        if (paymentChannelEdit != null) {
            paymentChannelEdit.setComboItems(comboItems);
            String paymentChannel = (String)this.getModel().getValue("paymentchannel");
            if (StringUtils.isNotEmpty((CharSequence)paymentChannel)) {
                List<String> currentPaymentChannels = Arrays.stream(paymentChannel.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                this.updateDefaultPaymentChannelComboItems(currentPaymentChannels);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ComboEdit paymentChannelEdit;
        String name = e.getProperty().getName();
        if (Objects.equals(name, "paymentchannel")) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                String defaultPaymentChannel;
                List<String> paymentChannels = Arrays.stream(newValue.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                if (!paymentChannels.contains(defaultPaymentChannel = (String)this.getModel().getValue("defaultpaymentchannel"))) {
                    this.getModel().setValue("defaultpaymentchannel", null);
                }
                this.updateDefaultPaymentChannelComboItems(paymentChannels);
            } else {
                this.updateDefaultPaymentChannelComboItems(new ArrayList<String>());
                this.getModel().setValue("defaultpaymentchannel", null);
            }
        } else if (Objects.equals(name, "settlementtype") && (paymentChannelEdit = (ComboEdit)this.getView().getControl("paymentchannel")) != null) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            HashSet<String> settlementTypeList = new HashSet<String>();
            settlementTypeList.add("0");
            settlementTypeList.add("14");
            if (settlementTypeList.contains(newValue) && !settlementTypeList.contains(oldValue) || !settlementTypeList.contains(newValue) && settlementTypeList.contains(oldValue)) {
                this.getModel().setValue("paymentchannel", null);
            }
            this.setComboItemsBySettlementType(newValue);
        }
    }

    private void updateDefaultPaymentChannelComboItems(List<String> paymentChannels) {
        List<ComboItem> comboItems = this.fillComboItems(paymentChannels);
        ComboEdit defaultPaymentChannelEdit = (ComboEdit)this.getView().getControl("defaultpaymentchannel");
        defaultPaymentChannelEdit.setComboItems(comboItems);
    }

    private List<ComboItem> fillComboItems(List<String> paymentChannels) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(paymentChannels.size());
        for (String paymentChannel : paymentChannels) {
            ComboItem item = new ComboItem();
            item.setValue(paymentChannel);
            String name = PaymentChannelEnum.getName((String)paymentChannel);
            item.setCaption(new LocaleString(name));
            comboItems.add(item);
        }
        return comboItems;
    }
}

