/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.StringUtils;
import org.apache.log4j.Logger;

public class StaffBankCardFormPlugin
extends AbstractFormPlugin {
    private static Logger logger = Logger.getLogger(StaffBankCardFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String pName = e.getProperty().getName();
        ChangeData[] changes = e.getChangeSet();
        Object valueObj = changes[0].getNewValue();
        switch (pName) {
            case "fuserfield": {
                this.fillOrgpostions(valueObj);
                this.fillLines(valueObj);
                break;
            }
            case "fisdefault": {
                if (valueObj == null || !((Boolean)valueObj).booleanValue()) break;
                this.doIsDefault(changes[0].getDataEntity(), changes[0].getRowIndex());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillOrgpostions(this.getModel().getValue("fuserfield"));
    }

    private void doIsDefault(DynamicObject currentLine, int rowIndex) {
        DynamicObjectCollection lines = this.getModel().getEntryEntity("bankaccounts");
        int index = 0;
        for (DynamicObject o : lines) {
            if (index != rowIndex) {
                o.set("fisdefault", (Object)Boolean.FALSE);
            } else {
                o.set("fisdefault", (Object)Boolean.TRUE);
            }
            ++index;
        }
        this.getView().updateView("bankaccounts");
    }

    private void fillOrgpostions(Object valueObject) {
        if (valueObject == null) {
            return;
        }
        DynamicObject value = (DynamicObject)valueObject;
        DynamicObjectCollection dpts = value.getDynamicObjectCollection("entryentity");
        if (dpts == null || dpts.isEmpty() || dpts.get(0) == null) {
            this.getModel().setValue("dptname", (Object)" | ");
            return;
        }
        DynamicObject dpt = (DynamicObject)((DynamicObject)dpts.get(0)).get("dpt");
        if (dpt == null) {
            this.getModel().setValue("dptname", (Object)" | ");
            return;
        }
        String dptName = dpt.getString("name");
        String position = ((DynamicObject)dpts.get(0)).getLocaleString("position").getLocaleValue();
        position = position == null ? "" : position;
        this.getModel().setValue("dptname", (Object)dptName);
        this.getModel().setValue("position", (Object)position);
    }

    private void fillLines(Object valueObject) {
        this.getModel().deleteEntryData("bankaccounts");
        if (valueObject == null) {
            return;
        }
        Long userId = ((DynamicObject)this.getModel().getValue("fuserfield")).getLong("masterid");
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"staffbankcard", (String)"id,bankaccounts.id,bankaccounts.faccno,bankaccounts.faccusername,bankaccounts.ffinorginfoid,bankaccounts.fisdefault,bankaccounts.fcurrencyid,bankaccounts.fremark", (QFilter[])new QFilter[]{new QFilter("fuserfield", "=", (Object)userId)});
        if (accounts == null || accounts.isEmpty()) {
            this.getModel().setValue("id", null);
            return;
        }
        this.getModel().setValue("id", (Object)((DynamicObject)accounts.get(0)).getLong("id"));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]).addField("faccno", new Object[0]).addField("faccusername", new Object[0]).addField("ffinorginfoid", new Object[0]).addField("fcurrencyid", new Object[0]).addField("fisdefault", new Object[0]).addField("fremark", new Object[0]);
        for (DynamicObject account : accounts) {
            vs.addRow(new Object[]{account.getString("bankaccounts.id"), account.getString("bankaccounts.faccno"), account.getString("bankaccounts.faccusername"), account.getString("bankaccounts.ffinorginfoid"), account.getLong("bankaccounts.fcurrencyid"), account.getBoolean("bankaccounts.fisdefault"), account.getString("bankaccounts.fremark")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.getDataEntity().getDataEntityState().setFromDatabase(true);
        model.batchCreateNewEntryRow("bankaccounts", vs);
        this.getView().updateView("bankaccounts");
    }

    private String getCreditLevelByTask(String appilerStr) {
        String creditLeveInfo = "";
        DynamicObject userArchive = StaffBankCardFormPlugin.getCreditInfoByTask(appilerStr);
        if (userArchive != null) {
            String curLevName = userArchive.getString("creditlevel.name");
            BigDecimal curLevScoreBG = userArchive.getBigDecimal("creditvalue").setScale(1, 5);
            creditLeveInfo = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5206", (String)"StaffBankCardFormPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]), curLevName, curLevScoreBG);
        }
        return creditLeveInfo;
    }

    private static DynamicObject getCreditInfoByTask(String appilerStr) {
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("userid", appilerStr);
        String msg = "";
        DynamicObject creditInfo = null;
        try {
            msg = (String)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"getCreditInfoByUserId", (Object[])new Object[]{userMap});
            Map creditMap = (Map)JSONObject.parse((String)msg);
            String credit = String.valueOf(creditMap.get("creditinfo"));
            if (!StringUtils.isEmpty((String)credit)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_creditfiles");
                Object[] userArchives = DynamicObjectSerializeUtil.deserialize((String)credit, (DynamicObjectType)type);
                if (userArchives == null || userArchives.length == 0) {
                    return creditInfo;
                }
                creditInfo = (DynamicObject)userArchives[0];
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCreditLevelByTask_msg:", (Throwable)e);
        }
        return creditInfo;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (this.getModel().getValue("fuserfield") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u3002", (String)"StaffBankCardFormPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
        if (e.getRowDataEntities()[0].getDataEntity().getLong("id") == 0L) {
            this.getModel().setValue("faccusername", (Object)((DynamicObject)this.getModel().getValue("fuserfield")).getLocaleString("name").getLocaleValue(), e.getRowDataEntities()[0].getRowIndex());
        }
    }
}

