/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.HashMap;
import java.util.Map;
import kd.bd.assistant.bom.VersionRuleBusiness;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BOMVersionRuleListPlugin
extends AbstractListPlugin {
    public static final String KEY_OP_SETDEFAULT = "setdefault";
    public static final String KEY_OP_ENABLE = "enable";
    public static final String KEY_OP_SUBMIT = "submit";
    private static final String KEY_AFTERCONFIRM = "afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (KEY_OP_SETDEFAULT.equals(operateKey)) {
            ListSelectedRowCollection listSelecrRow = this.getSelectedRows();
            if (listSelecrRow.size() > 1) {
                String errorMsg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u8bbe\u7f6e\u53ea\u652f\u6301\u5bf9\u5355\u6761\u6570\u636e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"BOMVersionRuleListPlugin_01", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errorMsg);
                e.setCancel(true);
                return;
            }
            Object[] pkIds = listSelecrRow.getPrimaryKeyValues();
            DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)pkIds[0], (String)"bd_bomversionrule_new", (String)"number,enable,status");
            if (!"1".equals(versionRule.getString(KEY_OP_ENABLE)) || !"C".equals(versionRule.getString("status"))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5904\u4e8e\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"BOMVersionRuleListPlugin_02", (String)"bd-assistant-formplugin", (Object[])new Object[0]), versionRule.getString("number"));
                this.getView().showTipNotification(errorMsg);
                e.setCancel(true);
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bd_versionrule_defset");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("ruleid", pkIds[0]);
            params.put("rulenumber", versionRule.getString("number"));
            fsp.setCustomParams(params);
            this.getView().showForm(fsp);
        } else if (KEY_OP_ENABLE.equals(operateKey) || KEY_OP_SUBMIT.equals(operateKey)) {
            FormOperate source;
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue(KEY_AFTERCONFIRM, afterConfirm)) {
                return;
            }
            ListSelectedRowCollection listSelecrRow = this.getSelectedRows();
            Object[] pkIds = listSelecrRow.getPrimaryKeyValues();
            StringBuilder msg = new StringBuilder();
            for (Object pk : pkIds) {
                String checkMsg = new VersionRuleBusiness().checkHasOtherDefault((Long)pk);
                if (StringUtils.isEmpty((String)checkMsg)) continue;
                msg.append(checkMsg).append("\r\n");
            }
            if (!StringUtils.isEmpty((String)msg.toString()) && !(source = (FormOperate)e.getSource()).getOption().tryGetVariableValue(KEY_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                this.getView().showConfirm(msg.toString(), MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((KEY_OP_ENABLE.equals(callBackId) || KEY_OP_SUBMIT.equals(callBackId)) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_AFTERCONFIRM, "true");
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (KEY_OP_SETDEFAULT.equals(actionId) && (data = (Map)event.getReturnData()) != null && data.get("isupdate") != null && "true".equals(data.get("isupdate").toString())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }
}

