/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ExpenseItemFilterTreeView
extends AbstractTreeListPlugin {
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            List list = (List)currentCommonFilter.get("Value");
            String filterOrgId = (String)list.get(0);
            this.getPageCache().put("orgid", filterOrgId);
            IListView view = (IListView)this.getView();
            ITreeListView treeListView2 = view.getTreeListView();
            treeListView2.focusRootNode();
            TreeListModel treeModel3 = (TreeListModel)view.getTreeListView().getTreeModel();
            List filter = treeModel3.getTreeFilter();
            treeModel3.setTreeFilter(filter);
            treeModel3.refreshNode(treeModel3.getCurrentNodeId());
            view.getTreeListView().refreshTreeNode(treeModel3.getCurrentNodeId().toString(), false);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns == null || commonFilterColumns.isEmpty()) {
            return;
        }
        if (this.getPageCache().get("orgid") == null) {
            String filterOrgId = null;
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                String fieldName = commonFilterColumn.getFieldName();
                if (!"useorg.id".equalsIgnoreCase(fieldName)) continue;
                List defaultValues = commonFilterColumn.getDefaultValues();
                filterOrgId = (String)defaultValues.get(0);
                this.getPageCache().put("orgid", filterOrgId);
            }
            IListView view = (IListView)this.getView();
            ITreeListView treeListView2 = view.getTreeListView();
            treeListView2.focusRootNode();
            TreeListModel treeModel3 = (TreeListModel)view.getTreeListView().getTreeModel();
            List filter = treeModel3.getTreeFilter();
            treeModel3.setTreeFilter(filter);
            treeModel3.refreshNode(treeModel3.getCurrentNodeId());
            view.getTreeListView().refreshTreeNode(treeModel3.getCurrentNodeId().toString(), false);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String currNodeId;
        TreeNode currNode;
        TreeNode root = this.getTreeModel().getRoot();
        String orgid = this.getPageCache().get("orgid");
        Object useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId");
        if (useOrgId != null && orgid == null) {
            orgid = String.valueOf(useOrgId);
        }
        if ((currNode = root.getTreeNode(currNodeId = (String)e.getNodeId(), 10)).getChildren() != null && !currNode.getChildren().isEmpty()) {
            if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
                e.setChildNodes(this.loadAppNodes(orgid));
                this.getTreeListView().refreshTreeNode(currNodeId);
            } else {
                e.setChildNodes(currNode.getChildren());
            }
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            e.setChildNodes(this.loadAppNodes(orgid));
        } else {
            e.setChildNodes(null);
        }
    }

    private List<TreeNode> loadAppNodes(String orgid) {
        List<TreeNode> ParentNode = this.getParentData(orgid);
        List<TreeNode> ChildNode = this.getChildData(orgid);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(ParentNode.size() + ChildNode.size());
        for (TreeNode node : ParentNode) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : ChildNode) {
            allNodes.put(node.getId(), node);
        }
        List<TreeNode> NonPromitNode = this.getNonPronitData();
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return ParentNode;
    }

    private List<TreeNode> getNonPronitData() {
        ArrayList<TreeNode> NonPronitNode = new ArrayList<TreeNode>();
        return NonPronitNode;
    }

    private List<TreeNode> getParentData(String orgid) {
        DynamicObject[] allExpense0;
        ArrayList<TreeNode> ParentNode = new ArrayList<TreeNode>(8);
        QFilter[] filters = new QFilter[]{new QFilter("level", "=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"5")};
        for (DynamicObject expense : allExpense0 = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters)) {
            TreeNode node = new TreeNode();
            String nodeID = expense.getString("id");
            String longnumber = expense.getString("longnumber");
            node.setId(nodeID);
            node.setParentid("0");
            node.setText(expense.getString("name"));
            node.setLongNumber(longnumber);
            ParentNode.add(node);
        }
        if (orgid != null) {
            DynamicObject[] allExpense;
            QFilter[] filters1 = new QFilter[]{new QFilter("level", "=", (Object)"1"), new QFilter("ctrlstrategy", "!=", (Object)"5"), new QFilter("createorg", "=", (Object)orgid)};
            for (DynamicObject expense : allExpense = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters1)) {
                TreeNode node = new TreeNode();
                DynamicObject[] nodeID = expense.getString("id");
                String longnumber = expense.getString("longnumber");
                node.setId((String)nodeID);
                node.setParentid("0");
                node.setText(expense.getString("name"));
                node.setLongNumber(longnumber);
                ParentNode.add(node);
            }
            QFilter[] filters12 = new QFilter[]{new QFilter("level", "=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"2"), new QFilter("createorg", "!=", (Object)orgid)};
            QFilter[] filters13 = new QFilter[]{new QFilter("level", "=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"1"), new QFilter("createorg", "!=", (Object)orgid)};
            DynamicObject[] allExpenseForOne = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters12);
            DynamicObject[] allExpenseForTwo = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters13);
            ArrayList<String> items = new ArrayList<String>();
            if (allExpenseForOne != null) {
                for (DynamicObject expense : allExpenseForOne) {
                    items.add(expense.getString("id"));
                }
            }
            if (allExpenseForTwo != null) {
                for (DynamicObject expense : allExpenseForTwo) {
                    items.add(expense.getString("id"));
                }
            }
            String sqlfmt = "select t1.fuseorgid fuserorgid,t3.fname name,t2.fparentid parent , t2.fid itemid, t2.flongnumber longnumber from t_er_expenseitemusereg t1 left join t_er_expenseitem t2 on t1.fdataid = t2.fid left join t_er_expenseitem_l t3 on t1.fdataid = t3.fid where t3.flocaleid = 'zh_CN' and t1.fdataid in ('%s')";
            String sql = String.format(sqlfmt, this.join(items, "','"));
            try (DataSet ds = DB.queryDataSet((String)"kd.bd.assistant.plugin.er.web.ExpenseItemFilterTreeView", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
                for (Row row : ds) {
                    String userorgid = row.getString("fuserorgid");
                    if (!orgid.equals(userorgid)) continue;
                    TreeNode node = new TreeNode();
                    String nodeID = row.getString("itemid");
                    String longnumber = row.getString("longnumber");
                    node.setId(nodeID);
                    node.setParentid("0");
                    node.setText(row.getString("name"));
                    node.setLongNumber(longnumber);
                    ParentNode.add(node);
                }
            }
        }
        return ParentNode;
    }

    private Object join(List<String> items, String string) {
        return items.stream().collect(Collectors.joining(string));
    }

    private List<TreeNode> getChildData(String orgid) {
        ArrayList<TreeNode> ChildNode = new ArrayList<TreeNode>();
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("level", "!=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"5")};
        try (DataSet ds = orm.queryDataSet("er_expenseitemedit", "er_expenseitemedit", "id,number, name, parent.id, parent.number,longnumber", filters, "level");){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String parentId = row.getString("parent.id");
                String nodeID = row.getString("id");
                String longnumber = row.getString("longnumber");
                node.setId(nodeID);
                node.setParentid(parentId);
                node.setLongNumber(longnumber);
                node.setText(row.getString("name"));
                ChildNode.add(node);
            }
        }
        if (orgid != null) {
            DynamicObject[] allExpense;
            QFilter[] filters1 = new QFilter[]{new QFilter("level", "!=", (Object)"1"), new QFilter("ctrlstrategy", "!=", (Object)"5"), new QFilter("createorg", "=", (Object)orgid)};
            for (DynamicObject expense : allExpense = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters1)) {
                TreeNode node = new TreeNode();
                DynamicObject[] parentId = expense.getString("parent.id");
                String nodeID = expense.getString("id");
                String longnumber = expense.getString("longnumber");
                node.setId(nodeID);
                node.setParentid((String)parentId);
                node.setText(expense.getString("name"));
                node.setLongNumber(longnumber);
                ChildNode.add(node);
            }
            QFilter[] filters12 = new QFilter[]{new QFilter("level", "!=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"2"), new QFilter("createorg", "!=", (Object)orgid)};
            QFilter[] filters13 = new QFilter[]{new QFilter("level", "!=", (Object)"1"), new QFilter("ctrlstrategy", "=", (Object)"1"), new QFilter("createorg", "!=", (Object)orgid)};
            DynamicObject[] allExpenseForOne = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters12);
            DynamicObject[] allExpenseForTwo = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number, name, parent.id, parent.number,longnumber", (QFilter[])filters13);
            ArrayList<String> items = new ArrayList<String>();
            if (allExpenseForOne != null) {
                for (DynamicObject expense : allExpenseForOne) {
                    items.add(expense.getString("id"));
                }
            }
            if (allExpenseForTwo != null) {
                for (DynamicObject expense : allExpenseForTwo) {
                    items.add(expense.getString("id"));
                }
            }
            String sqlfmt = "select t1.fuseorgid fuserorgid,t3.fname name,t2.fparentid parent , t2.fid itemid, t2.flongnumber longnumber from t_er_expenseitemusereg t1 left join t_er_expenseitem t2 on t1.fdataid = t2.fid left join t_er_expenseitem_l t3 on t1.fdataid = t3.fid where t3.flocaleid = 'zh_CN' and t1.fdataid in ('%s')";
            String sql = String.format(sqlfmt, this.join(items, "','"));
            try (DataSet ds = DB.queryDataSet((String)"kd.bd.assistant.plugin.er.web.ExpenseItemFilterTreeView", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
                for (Row row : ds) {
                    String userorgid = row.getString("fuserorgid");
                    if (!orgid.equals(userorgid)) continue;
                    TreeNode node = new TreeNode();
                    String nodeID = row.getString("itemid");
                    String longnumber = row.getString("longnumber");
                    String parentid = row.getString("parent");
                    node.setId(nodeID);
                    node.setParentid(parentid);
                    node.setText(row.getString("name"));
                    node.setLongNumber(longnumber);
                    ChildNode.add(node);
                }
            }
        }
        return ChildNode;
    }
}

