/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.schedule;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.StringUtils;

public class ScheduleConfigPlugin
extends AbstractBasePlugIn {
    private static final String FILTERGRID = "filtergrid";
    private static final String BILL_NUMBER = "number";
    private static final String SELBILL = "selbill";
    private static final String EXETYPE = "exetype";
    private static final String INTERFACE = "interface";
    private static final String SCH_SCHEDULE = "schschedule";
    public static final String SELBILLFILTER = "selbillfilter";
    public static final String SELBILLFILTER_TAG = "selbillfilter_tag";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        if (newValue == null) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "selbill": {
                this.billEntityOnChanged();
                break;
            }
            case "schschedule": {
                this.schJobOnChanged();
                break;
            }
            case "exetype": {
                this.exeTypeOnChanged((String)newValue);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        this.loadFilterGrid(this.getView(), (String)model.getValue(SELBILLFILTER_TAG));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "save": {
                this.beforeDoSave(args);
                break;
            }
        }
    }

    private void beforeDoSave(BeforeDoOperationEventArgs args) {
        String exeType;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject schedule = dataEntity.getDynamicObject(SCH_SCHEDULE);
        model.setValue(BILL_NUMBER, (Object)schedule.getString(BILL_NUMBER));
        model.setValue("name", (Object)schedule.getString("name"));
        model.setValue("status", (Object)"A");
        model.setValue(SELBILLFILTER_TAG, null);
        model.setValue(SELBILLFILTER, (Object)"");
        DynamicObject selEntity = dataEntity.getDynamicObject(SELBILL);
        switch (exeType = dataEntity.getString(EXETYPE)) {
            case "bill": {
                if (selEntity == null) {
                    args.setCancel(true);
                    return;
                }
                model.setValue(INTERFACE, (Object)"");
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
                FilterGrid.FilterGridState filterState = filterGrid.getFilterGridState();
                if (filterState == null || filterState.getFilterCondition() == null) break;
                model.setValue(SELBILLFILTER_TAG, (Object)SerializationUtils.toJsonString((Object)filterState.getFilterCondition()));
                String entityName = selEntity.getString(BILL_NUMBER);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterState.getFilterCondition(), true);
                fb.buildFilter(true);
                if (fb.getQFilter() == null) break;
                model.setValue(SELBILLFILTER, (Object)fb.getQFilter().toString());
                break;
            }
            case "interface": {
                String inteface = dataEntity.getString(INTERFACE);
                if (StringUtils.isEmpty((String)inteface)) {
                    args.setCancel(true);
                    return;
                }
                if (inteface.split("\\.").length != 4) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u683c\u5f0f\u9519\u8bef", (String)"ScheduleConfigPlugin_01", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                dataEntity.set(SELBILL, null);
                break;
            }
            default: {
                args.setCancel(true);
            }
        }
    }

    private void initBillFilterGrid() {
        DynamicObject billEntity = (DynamicObject)this.getModel().getValue(SELBILL);
        this.initFilterGrid(this.getView(), billEntity != null ? billEntity.getString(BILL_NUMBER) : null);
    }

    private void billEntityOnChanged() {
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        model.setValue(SELBILLFILTER, (Object)"");
        model.setValue(SELBILLFILTER_TAG, null);
        model.setValue(INTERFACE, (Object)"");
        this.getView().updateView();
    }

    private void schJobOnChanged() {
        IDataModel model = this.getModel();
        model.setValue(SELBILL, null);
        model.setValue(SELBILLFILTER, (Object)"");
        model.setValue(SELBILLFILTER_TAG, null);
        this.getView().updateView();
    }

    private void exeTypeOnChanged(String exeType) {
        IDataModel model = this.getModel();
        switch (exeType) {
            case "bill": {
                model.setValue(INTERFACE, null);
                this.setMustInput(SELBILL, Boolean.TRUE);
                this.setMustInput(INTERFACE, Boolean.FALSE);
                break;
            }
            case "interface": {
                model.setValue(SELBILL, null);
                model.setValue(SELBILLFILTER, (Object)"");
                model.setValue(SELBILLFILTER_TAG, null);
                this.setMustInput(SELBILL, Boolean.FALSE);
                this.setMustInput(INTERFACE, Boolean.TRUE);
                break;
            }
        }
        this.getView().updateView();
    }

    private void setMustInput(String propName, boolean mustInput) {
        FieldEdit selBill = (FieldEdit)this.getView().getControl(propName);
        selBill.setMustInput(mustInput);
    }

    private void initFilterGrid(IFormView formView, String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(FILTERGRID);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(new FilterCondition());
        formView.updateView(FILTERGRID);
    }

    private void loadFilterGrid(IFormView formView, String filterTag) {
        if (StringUtils.isEmpty((String)filterTag)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(FILTERGRID);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }
}

