/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.util;

import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.time.DateUtils;

public class BOMVersionUtil {
    private static final Log logger = LogFactory.getLog(BOMVersionUtil.class);
    static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};
    private static final String KEY_VERSION = "version";
    private static final String KEY_ENTITY_RULE = "bd_bomversionrule_new";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_MATERIALGROUP = "materialgroup";
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String KEY_BOMVERSIONRULE = "bomversionrule";
    private static final String KEY_ENTITY_VERSION = "bd_bomversion_new";

    public static String getAutoVersion(Object orgId, Object materId, Object ruleId, String type) {
        QFilter qFilter = new QFilter("id", "=", ruleId);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)KEY_ENTITY_RULE, (String)"entryentity.version version", (QFilter[])new QFilter[]{qFilter});
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        Set<String> versionSet = rules.stream().map(p -> p.getString(KEY_VERSION)).collect(Collectors.toSet());
        Set<String> existsSet = BOMVersionUtil.checkIsQuoteVersion(orgId, materId, versionSet, type);
        for (int i = 0; i < rules.size(); ++i) {
            String version = ((DynamicObject)rules.get(i)).getString(KEY_VERSION);
            if (existsSet.contains(materId + "_" + version)) continue;
            return version;
        }
        return null;
    }

    public static Boolean isQuoteVersion(Object orgId, Object materId, String version, String type) {
        if (orgId != null && materId != null && StringUtils.isNotBlank((CharSequence)version)) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "=", (Object)version);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)type);
            return QueryServiceHelper.exists((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter4});
        }
        return true;
    }

    public static Set<String> checkIsQuoteVersion(Object orgId, Object materId, Set<String> versions, String type) {
        HashSet<String> isExistsSet = new HashSet<String>(16);
        if (orgId != null && materId != null && versions != null && !versions.isEmpty()) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "in", versions);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)type);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)KEY_ENTITY_VERSION, (String)"material,createorg,name", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter4});
            for (DynamicObject version : coll) {
                isExistsSet.add(version.getLong(KEY_MATERIAL) + "_" + version.getString(KEY_NAME));
            }
        }
        return isExistsSet;
    }

    public static Boolean isQuoteVersion(Object materId, Object materialgroupId, String version, long rulePkId, String type) {
        if (materId != null && StringUtils.isNotBlank((CharSequence)version)) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter1 = new QFilter(KEY_MATERIALGROUP, "=", materialgroupId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "=", (Object)version);
            QFilter qFilter3 = new QFilter(KEY_BOMVERSIONRULE, "=", (Object)rulePkId);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)type);
            return QueryServiceHelper.exists((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4});
        }
        return true;
    }

    public static void autoCreateBOMVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate) {
        if (createorg == null) {
            ErrorCode ec = new ErrorCode("createorg", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\uff01", (String)"BOMVersionUtil_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        if (material == null) {
            ErrorCode ec = new ErrorCode(KEY_MATERIAL, ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\uff01", (String)"BOMVersionUtil_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        if (rule == null) {
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\uff01", (String)"BOMVersionUtil_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        if (validdate == null) {
            validdate = new Date();
        }
        if (invaliddate == null) {
            try {
                invaliddate = BOMVersionUtil.parseDate("2999-12-31");
            }
            catch (ParseException e) {
                logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a" + e.toString());
            }
        }
        DynamicObject bomversion = ORM.create().newDynamicObject(KEY_ENTITY_VERSION);
        String number = BOMVersionUtil.getAutoNumber(bomversion, createorg.getPkValue().toString(), KEY_ENTITY_VERSION);
        bomversion.set("number", (Object)number);
        String version = BOMVersionUtil.getAutoVersion(createorg.getPkValue(), material.getPkValue(), rule.getPkValue(), "A");
        if (version == null) {
            ErrorCode ec = new ErrorCode(KEY_VERSION, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7248\u672c\u53f7\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\uff01", (String)"BOMVersionUtil_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        bomversion.set(KEY_NAME, (Object)version);
        bomversion.set(KEY_BOMVERSIONRULE, (Object)rule);
        bomversion.set(KEY_MATERIAL, (Object)material);
        bomversion.set("createorg", (Object)createorg);
        bomversion.set(KEY_TYPE, (Object)"A");
        bomversion.set("effectdate", (Object)validdate);
        bomversion.set("invaliddate", (Object)invaliddate);
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)KEY_ENTITY_VERSION, (DynamicObject[])new DynamicObject[]{bomversion}, (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public static Date parseDate(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return DateUtils.parseDate((String)string, (String[])parsePatterns);
    }

    public static String getAutoNumber(DynamicObject entityObj, String orgID, String entityName) {
        return "Item-" + System.currentTimeMillis();
    }

    public static int getMaxSeq(Long materId, Long materialGroupId, long rulePkId, String type) {
        QFilter matQ = new QFilter(KEY_MATERIAL, "=", (Object)materId);
        QFilter matGroupQ = new QFilter(KEY_MATERIALGROUP, "=", (Object)materialGroupId);
        QFilter ruleQ = new QFilter(KEY_BOMVERSIONRULE, "=", (Object)rulePkId);
        QFilter typeQ = new QFilter(KEY_TYPE, "=", (Object)type);
        DynamicObjectCollection verRuleCol = QueryServiceHelper.query((String)KEY_ENTITY_VERSION, (String)"versionname.entrySeq seq", (QFilter[])new QFilter[]{matQ, matGroupQ, ruleQ, typeQ}, (String)"versionname.entrySeq desc");
        return verRuleCol.isEmpty() ? 0 : ((DynamicObject)verRuleCol.get(0)).getInt("seq");
    }
}

