/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bd.master.webapi.service.MasterWebApiService;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CustomerSaveApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(CustomerSaveApiService.class);
    private MasterWebApiService apiService = new MasterWebApiService();

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult apiResult = null;
        try {
            apiResult = this.executeCustomerInfo(params);
        }
        catch (Throwable e) {
            apiResult = ApiResult.fail((String)e.toString());
            logger.error("customerSaveApiService errorinfo:" + e);
        }
        return apiResult;
    }

    private ApiResult executeCustomerInfo(Map<String, Object> params) throws Throwable {
        ApiResult relut = null;
        String datas = JSON.toJSONString((Object)params.get("data"));
        if (!StringUtils.isEmpty((String)datas)) {
            JSONArray customers = JSON.parseArray((String)datas);
            if (customers != null && customers.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(customers.size());
                HashMap<Long, JSONObject> jsonDatas = new HashMap<Long, JSONObject>(customers.size());
                for (Object customer : customers) {
                    JSONObject cus = JSON.parseObject((String)customer.toString());
                    Long id = cus.getLong("id");
                    if (id != null && id != 0L) {
                        ids.add(id);
                        jsonDatas.put(id, cus);
                        continue;
                    }
                    this.apiService.createMasterData(cus, "bd_customer");
                }
                if (ids.size() > 0) {
                    this.apiService.updateMasterData(ids, jsonDatas, "bd_customer");
                }
                relut = ApiResult.success((Object)"operate successfully.");
            }
        } else {
            relut = ApiResult.fail((String)"The incoming JSON data is empty.");
        }
        return relut;
    }
}

