/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.util.ErrorInfoConverUtil;
import kd.bd.master.vo.OpResultVo;
import kd.bd.master.vo.OperationApiVo;
import kd.bd.master.webapi.service.MaterialWebpiService;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class GenerateMaterialAndBizInfoApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(GenerateMaterialAndBizInfoApiService.class);
    private MaterialWebpiService apiService = new MaterialWebpiService();

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = null;
        boolean resultSuccess = true;
        try {
            Object dataParam = params.get("data");
            if (dataParam == null) {
                return ApiResult.fail((String)"The 'data' parameter is empty.");
            }
            String dataStr = JSON.toJSONString((Object)dataParam);
            JSONArray materials = JSON.parseArray((String)dataStr);
            if (materials == null || materials.isEmpty()) {
                return ApiResult.fail((String)"The incoming JSON data is empty.");
            }
            logger.info("materials record size:" + materials.size());
            OpResultVo materialResult = this.generateMaterial(materials);
            Map materialResultMap = materialResult.getMap();
            OpResultVo bizInfoResult = this.generateMaterialBizInfo(materialResultMap);
            Map bizInfoResultMap = bizInfoResult.getMap();
            LinkedList apiResult = new LinkedList();
            HashMap<String, Object> apiDataMap = null;
            for (Map.Entry mapEntry : materialResultMap.entrySet()) {
                apiDataMap = new HashMap<String, Object>(16);
                String materialId = (String)mapEntry.getKey();
                OperationApiVo materialApiVo = (OperationApiVo)mapEntry.getValue();
                String materialNumber = materialApiVo.getNumber();
                String invKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialinventoryinfo");
                OperationApiVo invInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(invKey)).orElseGet(OperationApiVo::successEmpty);
                String purKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialpurchaseinfo");
                OperationApiVo purInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(purKey)).orElseGet(OperationApiVo::successEmpty);
                String saleKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialsalinfo");
                OperationApiVo saleInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(saleKey)).orElseGet(OperationApiVo::successEmpty);
                String mftKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialmftinfo");
                OperationApiVo mftInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(mftKey)).orElseGet(OperationApiVo::successEmpty);
                String inspectCfgKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_inspect_cfg");
                OperationApiVo inspectCfgApiVo = Optional.ofNullable(bizInfoResultMap.get(inspectCfgKey)).orElseGet(OperationApiVo::successEmpty);
                boolean isSuccess = Boolean.parseBoolean(materialApiVo.getIsSuccesss()) && Boolean.parseBoolean(invInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(purInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(saleInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(mftInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(inspectCfgApiVo.getIsSuccesss());
                StringJoiner msgJoiner = new StringJoiner(" ");
                msgJoiner.add(((OperationApiVo)mapEntry.getValue()).getMessage()).add(invInfoApiVo.getMessage()).add(purInfoApiVo.getMessage()).add(saleInfoApiVo.getMessage()).add(mftInfoApiVo.getMessage()).add(inspectCfgApiVo.getMessage());
                apiDataMap.put("materialid", materialId);
                apiDataMap.put("materialnumber", materialNumber);
                apiDataMap.put("materialinventoryinfoid", invInfoApiVo.getId());
                apiDataMap.put("materialpurchaseinfoid", purInfoApiVo.getId());
                apiDataMap.put("materialsaleinfoid", saleInfoApiVo.getId());
                apiDataMap.put("materialmftinfoid", mftInfoApiVo.getId());
                apiDataMap.put("materialinspectcfgid", inspectCfgApiVo.getId());
                apiDataMap.put("success", isSuccess);
                apiDataMap.put("message", msgJoiner.toString().trim());
                apiResult.add(apiDataMap);
                if (isSuccess) continue;
                resultSuccess = false;
            }
            if (resultSuccess) {
                result = ApiResult.success(apiResult);
            } else {
                result = ApiResult.fail((String)"operate fail.");
                result.setData(apiResult);
            }
        }
        catch (Throwable e) {
            result = ApiResult.ex((Throwable)e, (boolean)true);
            logger.error("MaterialAndBizInfoGenerateApiService exception", e);
        }
        return result;
    }

    private OpResultVo generateMaterial(JSONArray materials) throws Throwable {
        HashMap<Long, JSONObject> needUpdateDatas = new HashMap<Long, JSONObject>(materials.size());
        ArrayList<Long> needUpdateDataIds = new ArrayList<Long>(materials.size());
        ArrayList<JSONObject> newDatas = new ArrayList<JSONObject>(materials.size());
        for (Object material : materials) {
            JSONObject mst = JSON.parseObject((String)material.toString());
            Long id = mst.getLong("id");
            if (id != null && id != 0L) {
                this.apiService.forceSetStatusAndEnable(mst);
                needUpdateDataIds.add(id);
                needUpdateDatas.put(id, mst);
                continue;
            }
            this.apiService.forceSetStatusAndEnable(mst);
            newDatas.add(mst);
        }
        OpResultVo opResultVo = new OpResultVo();
        OpResultVo createOpResultVo = new OpResultVo();
        OpResultVo updateOpResultVo = new OpResultVo();
        logger.info("before save material, newDatas size:" + newDatas.size() + ",needUpdateDatas size:" + needUpdateDatas.size());
        if (!newDatas.isEmpty() && !needUpdateDataIds.isEmpty()) {
            createOpResultVo = this.apiService.createMasterData(newDatas, "bd_material");
            updateOpResultVo = this.apiService.updateMasterData(needUpdateDataIds, needUpdateDatas, "bd_material");
            opResultVo.setResult(createOpResultVo.isResult() && updateOpResultVo.isResult());
            opResultVo.getMap().putAll(createOpResultVo.getMap());
            opResultVo.getMap().putAll(updateOpResultVo.getMap());
        } else if (!newDatas.isEmpty()) {
            opResultVo = createOpResultVo = this.apiService.createMasterData(newDatas, "bd_material");
        } else if (!needUpdateDataIds.isEmpty()) {
            opResultVo = updateOpResultVo = this.apiService.updateMasterData(needUpdateDataIds, needUpdateDatas, "bd_material");
        }
        Map resultMap = opResultVo.getMap();
        List saveSuccessPkIds = resultMap.values().stream().filter(m -> "true".equals(m.getIsSuccesss())).map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        logger.info("before submit material, size:" + saveSuccessPkIds.size());
        if (saveSuccessPkIds.isEmpty()) {
            return opResultVo;
        }
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"bd_material", (Object[])saveSuccessPkIds.toArray(), (OperateOption)OperateOption.create());
        if (!submitResult.isSuccess()) {
            ErrorInfoConverUtil.billPKErrorMapping((Map)resultMap, (OperationResult)submitResult);
        }
        List submitSuccessPkIds = submitResult.getSuccessPkIds();
        logger.info("before audit material, size:" + submitSuccessPkIds.size());
        if (submitSuccessPkIds.isEmpty()) {
            return opResultVo;
        }
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"bd_material", (Object[])submitSuccessPkIds.toArray(), (OperateOption)OperateOption.create());
        if (!auditResult.isSuccess()) {
            ErrorInfoConverUtil.billPKErrorMapping((Map)resultMap, (OperationResult)auditResult);
        }
        return opResultVo;
    }

    private OpResultVo generateMaterialBizInfo(Map<String, OperationApiVo> materialInfoMap) {
        OpResultVo result = new OpResultVo(true, new HashMap(1));
        List allMaterialIds = materialInfoMap.values().stream().filter(m -> StringUtils.isNotEmpty((String)m.getId())).map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        logger.info("generateMaterialBizInfo, allMaterialIds size:" + allMaterialIds.size());
        if (allMaterialIds.isEmpty()) {
            return result;
        }
        QFilter condition1 = new QFilter("id", "in", allMaterialIds);
        QFilter condition2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getCode());
        QFilter[] conditions = new QFilter[]{condition1, condition2};
        DynamicObject[] materialArr = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,createorg,baseunit,enablepur,enablesale,enableinv,enableproduct,enableinspect,configproperties", (QFilter[])conditions);
        logger.info("generateMaterialBizInfo query material, result size:" + materialArr.length);
        if (materialArr.length == 0) {
            return result;
        }
        ArrayList<DynamicObject> enablePurMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableSaleMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableInvMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableProductMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableInspectMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        for (DynamicObject material : materialArr) {
            if (material.getBoolean("enablepur")) {
                enablePurMaterialList.add(material);
            }
            if (material.getBoolean("enablesale")) {
                enableSaleMaterialList.add(material);
            }
            if (material.getBoolean("enableinv")) {
                enableInvMaterialList.add(material);
            }
            if (material.getBoolean("enableproduct")) {
                enableProductMaterialList.add(material);
            }
            if (!material.getBoolean("enableinspect")) continue;
            enableInspectMaterialList.add(material);
        }
        OpResultVo materialInvInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableInvMaterialList.isEmpty()) {
            materialInvInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableInvMaterialList, "bd_materialinventoryinfo");
        }
        OpResultVo materialPurInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enablePurMaterialList.isEmpty()) {
            materialPurInfoResult = this.apiService.initMaterialBizInfoByMaterial(enablePurMaterialList, "bd_materialpurchaseinfo");
        }
        OpResultVo materialSaleInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableSaleMaterialList.isEmpty()) {
            materialSaleInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableSaleMaterialList, "bd_materialsalinfo");
        }
        OpResultVo materialProductInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableProductMaterialList.isEmpty()) {
            materialProductInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableProductMaterialList, "bd_materialmftinfo");
        }
        OpResultVo materialInspectResult = new OpResultVo(true, new HashMap(1));
        if (!enableInspectMaterialList.isEmpty()) {
            materialInspectResult = this.apiService.initMaterialBizInfoByMaterial(enableInspectMaterialList, "bd_inspect_cfg");
        }
        boolean isSuccess = materialInvInfoResult.isResult() && materialPurInfoResult.isResult() && materialSaleInfoResult.isResult() && materialProductInfoResult.isResult() && materialInspectResult.isResult();
        HashMap resultMap = new HashMap(materialArr.length);
        resultMap.putAll(materialInvInfoResult.getMap());
        resultMap.putAll(materialPurInfoResult.getMap());
        resultMap.putAll(materialSaleInfoResult.getMap());
        resultMap.putAll(materialProductInfoResult.getMap());
        resultMap.putAll(materialInspectResult.getMap());
        result.setResult(isSuccess);
        result.setMap(resultMap);
        return result;
    }
}

