/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class GetMaterialApiPlugin
extends AbstractBillWebApiPlugin {
    private static final String MATERIAL = "bd_material";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";

    public void doAICommand(AICommandEvent e) {
        try (TraceSpan span = Tracer.create((String)"GetMaterialApiPlugin", (String)"doAICommand");){
            Map<String, String> material = this.getMaterialInfo();
            ApiResult ret = new ApiResult();
            ArrayList items = new ArrayList(material.size());
            material.forEach((k, v) -> {
                SelectsModel.SelectItem item = new SelectsModel.SelectItem(v, k);
                items.add(item);
            });
            SelectsModel selects = new SelectsModel(ResManager.loadKDString((String)"\u7269\u6599", (String)"GetMaterialApiPlugin_0", (String)"bd-master-webapi", (Object[])new Object[0]), items);
            ResponseModel response = ResponseModel.createSelectsResponse((SelectsModel)selects);
            ret.setData((Object)response);
            e.setResult(ret);
        }
    }

    private Map<String, String> getMaterialInfo() {
        String selectFields = "id,name,number";
        QFilter qFilter = new QFilter(STATUS, "=", (Object)"C");
        qFilter.and(ENABLE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection materialInfos = QueryServiceHelper.query((String)MATERIAL, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> materialInfoMap = new HashMap<String, String>(materialInfos.size());
        for (DynamicObject materialInfo : materialInfos) {
            if (materialInfo.get(ID) == null || materialInfo.get(NAME) == null || materialInfo.get(NUMBER) == null) continue;
            materialInfoMap.put(materialInfo.getString(NUMBER), materialInfo.getString(ID));
            materialInfoMap.put(materialInfo.getString(NAME), materialInfo.getString(ID));
        }
        return materialInfoMap;
    }
}

