/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class UpgradeReimburseLevel
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String querySql = "SELECT FID,FREIMBURSELEVELID FROM T_SEC_USER_E WHERE FREIMBURSELEVELID != 0";
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        ArrayList<Object[]> params = new ArrayList<Object[]>(32);
        Map<Long, Long> companyByUser = this.getCompanyByUser(dbRoute);
        try (DataSet ds = DB.queryDataSet((String)"upgrade.reimburselevel", (DBRoute)dbRoute, (String)querySql);){
            int size = ds.copy().count("fid", true);
            long[] genGlobalLongIds = DB.genGlobalLongIds((int)size);
            int i = 0;
            while (ds.hasNext()) {
                Row next = ds.next();
                Object[] param = new Object[4];
                Object userId = next.get("FID");
                param[0] = genGlobalLongIds[i++];
                param[1] = userId;
                param[2] = next.get("FREIMBURSELEVELID");
                param[3] = companyByUser.get(userId);
                if (param[1] == null || param[2] == null || param[3] == null) continue;
                params.add(param);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)"INSERT INTO t_er_reimbursesetting_rel (FID,FUSER,FREIMBURSELEVEL,FCOMPANY) VALUES (?,?,?,?)", params);
        }
        result.setLog("insert t_er_reimbursesetting_rel success");
        return result;
    }

    private Map<Long, Long> getCompanyByUser(DBRoute dbRoute) {
        String querySql = "SELECT FID FROM T_SEC_USER_E WHERE FREIMBURSELEVELID != 0";
        ArrayList<Long> userIds = new ArrayList<Long>(32);
        try (DataSet ds = DB.queryDataSet((String)"upgrade.reimburselevel", (DBRoute)dbRoute, (String)querySql);){
            while (ds.hasNext()) {
                userIds.add(ds.next().getLong("FID"));
            }
        }
        HashMap<Long, Long> companyByUser = new HashMap<Long, Long>(32);
        List userMainOrgId = UserServiceHelper.getUserMainOrgId(userIds);
        userMainOrgId.forEach(v -> {
            Map.Entry entry = v.entrySet().iterator().next();
            companyByUser.put((Long)entry.getKey(), this.getCompanyByOrg((Long)entry.getValue()));
        });
        return companyByUser;
    }

    private Long getCompanyByOrg(Long org) {
        Map companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)org);
        return companyByOrg.getOrDefault("id", 0L);
    }
}

