/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.pbd.plugin.GoodsIssysPresetUtil;
import kd.bd.pbd.plugin.GoodsUpgradeUtil;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class GoodsList
extends StandardTreeListPlugin
implements ItemClickListener {
    private static final String CMBSTANDARDLST = "cmbstandardlst";
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String BDGOODSCLASSSTANDARD = "bd_goodsclassstandard";
    private static final String MDRGOODSCLASS = "mdr_goodsclass";
    private static final String PBDGOODSCATEGORY = "pbd_goodscategory";
    private static final String PBDQUERYCLASS = "pbd_queryclass";
    private static final String ZJ = "944841720602823680";

    public void afterCreateNewData(EventObject e) {
        String cmbStandardLst = (String)this.getView().getFormShowParameter().getCustomParam(CMBSTANDARDLST);
        String showGoodsF7 = (String)this.getView().getFormShowParameter().getCustomParam("showGoodsF7");
        IPageCache redisBdCache = this.getPageCache();
        if (StringUtils.isNotBlank((CharSequence)showGoodsF7)) {
            redisBdCache.put("showGoodsF7", showGoodsF7);
        }
        if (StringUtils.isNotBlank((CharSequence)cmbStandardLst)) {
            this.getModel().setValue(CMBSTANDARDLST, (Object)cmbStandardLst);
        } else {
            this.getModel().setValue(CMBSTANDARDLST, (Object)ZJ);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setComboEdit();
        String standard = String.valueOf(this.getModel().getValue(CMBSTANDARDLST));
        DynamicObject categories = QueryServiceHelper.queryOne((String)BDGOODSCLASSSTANDARD, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(standard))});
        if (categories != null) {
            if (!ZJ.equals(categories.getString("id"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tblquery"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tblnew"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"tblquery"});
            }
        }
        if (!this.getMalDefaultVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblviewcommenttemp"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblshow"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblshow"});
        }
    }

    private boolean getMalDefaultVersion() {
        Object val;
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("UUPIH+47DAK");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Map sysParaMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        String paramVal = "";
        if (null != sysParaMap && null != (val = sysParaMap.get("latestversion"))) {
            paramVal = val.toString();
        }
        return Boolean.parseBoolean(paramVal);
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        DynamicObjectCollection ecadmitQuery = QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
        return ecadmitQuery;
    }

    private LocaleString getStandardName(DynamicObject dyo) {
        return new LocaleString(dyo.getString("standard.name") + "(" + dyo.getString("standard.number") + ")");
    }

    private void setComboEdit() {
        ComboEdit combo = (ComboEdit)this.getView().getControl(CMBSTANDARDLST);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
        IPageCache redisBdCache = this.getPageCache();
        String showGoodsF = redisBdCache.get("showGoodsF7");
        DynamicObjectCollection comboEdit = this.getStandardDyos();
        if (null == showGoodsF) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5546\u57ce\u5546\u54c1\u5206\u7c7b\u6807\u51c6(00000801)", (String)"GoodsList_0", (String)"bd-pbd-formplugin", (Object[])new Object[0])), ZJ));
            if (!CollectionUtils.isEmpty((Collection)comboEdit)) {
                for (DynamicObject dyo : comboEdit) {
                    data.add(new ComboItem(this.getStandardName(dyo), dyo.getString("standard.id")));
                }
            }
        } else if ("self".equals(showGoodsF)) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5546\u57ce\u5546\u54c1\u5206\u7c7b\u6807\u51c6(00000801)", (String)"GoodsList_0", (String)"bd-pbd-formplugin", (Object[])new Object[0])), ZJ));
        } else if ("mal".equals(showGoodsF) && !CollectionUtils.isEmpty((Collection)comboEdit)) {
            for (DynamicObject dyo : comboEdit) {
                data.add(new ComboItem(this.getStandardName(dyo), dyo.getString("standard.id")));
            }
        }
        combo.setComboItems(data);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IPageCache redisBdCache = this.getPageCache();
        String showf = redisBdCache.get("showF7");
        if (null == showf && CMBSTANDARDLST.equals(e.getProperty().getName())) {
            String standard = String.valueOf(this.getModel().getValue(CMBSTANDARDLST));
            String showGoodsF7 = (String)this.getView().getFormShowParameter().getCustomParam("showGoodsF7");
            if (!ZJ.equals(standard) && null == showGoodsF7) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id", (QFilter[])new QFilter[]{new QFilter("standard", "=", (Object)Long.parseLong(standard)).and(new QFilter("level", "=", (Object)Integer.parseInt("3")))});
                String source = this.querysource(standard);
                DynamicObjectCollection dyn = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"id", (QFilter[])new QFilter[]{new QFilter("source", "=", (Object)source)});
                int index = query.size() - dyn.size();
                if (index > 0) {
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d3\u7ea7\u5206\u7c7b\u5171\u6709{0}\u6761\u6570\u636e\u5f85\u4e0e\u81ea\u5efa\u5206\u7c7b\u5efa\u7acb\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u77e5\u6089\u3002", (String)"GoodsList_6", (String)"bd-pbd-formplugin", (Object[])new Object[0]), index));
                }
            }
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_open"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object standardId = this.getModel().getValue(CMBSTANDARDLST);
        IPageCache redisBdCache = this.getPageCache();
        String showGoodsF = redisBdCache.get("showGoodsF7");
        if ("mal".equals(showGoodsF) && ZJ.equals(standardId)) {
            standardId = 0;
        }
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.parseLong(String.valueOf(standardId)));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter("parent", "=", (Object)Long.parseLong(nodeId));
        QFilter qFilter3 = new QFilter("level", "!=", (Object)Integer.parseInt("3"));
        DynamicObjectCollection loads = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3});
        for (DynamicObject group : loads) {
            String parentid = group.getString("parent");
            if ("0".equals(parentid)) {
                parentid = ROOTNODEID;
            }
            TreeNode node = new TreeNode(parentid, group.getString("id"), group.getString("name"), !group.getBoolean("isleaf"), (Object)group);
            treeNodes.add(node);
        }
        return treeNodes;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblitemclassstand": {
                GoodsIssysPresetUtil.issysPreset();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5546\u54c1\u6807\u51c6\u5206\u7c7b\u6210\u529f\uff01", (String)"GoodsList_7", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "tblupgoods": {
                DynamicObjectCollection query = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id", (QFilter[])new QFilter[]{new QFilter("standard", "=", (Object)Long.parseLong(ZJ))});
                if (query.size() > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b8c\u6210\u5347\u7ea7", (String)"GoodsList_8", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                GoodsUpgradeUtil.issysPreset();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b8c\u6210\u5347\u7ea7", (String)"GoodsList_8", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private List<String> updateClass() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        DynamicObjectCollection ecadmitQuery = QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> list = new ArrayList<String>(ecadmitQuery.size());
        if (ecadmitQuery.size() > 0) {
            for (DynamicObject dynamic : ecadmitQuery) {
                String source = dynamic.getString("platform");
                list.add(source);
            }
        }
        return list;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("viewcommenttemp".equals(operateKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
            if (objects == null || objects.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u64cd\u4f5c\u3002", (String)"GoodsList_28", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject goodsClass = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"id,level", (QFilter[])new QFilter[]{new QFilter("id", "=", objects[0])});
            if (goodsClass.getInt("level") != 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u6709\u4e09\u7ea7\u5206\u7c7b\u5b58\u5728\u5bf9\u5e94\u6a21\u677f\u3002", (String)"GoodsList_29", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        String key = args.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        FormShowParameter fsp = new FormShowParameter();
        switch (key) {
            case "disable": {
                this.disableShow();
                break;
            }
            case "show": {
                String show = this.setMainShow(true);
                if (!"true".equals(show)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9996\u9875\u5c55\u793a\u6210\u529f", (String)"GoodsList_9", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "unshow": {
                String unshow = this.setMainShow(false);
                if (!"true".equals(unshow)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9996\u9875\u5c55\u793a\u6210\u529f", (String)"GoodsList_10", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mallclass": {
                ListSelectedRow row;
                String id;
                QFilter idfilter;
                DynamicObject category;
                if (selectCol.size() > 1) {
                    listview.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6765\u8bbe\u7f6e\u5206\u7c7b\u5bf9\u5e94", (String)"GoodsList_11", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectCol.size() <= 0 || null == (category = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"id,level", (QFilter[])new QFilter[]{idfilter = new QFilter("id", "=", (Object)Long.parseLong(id = (row = selectCol.get(0)).getPrimaryKeyValue().toString()))}))) break;
                String level = category.get("level").toString();
                if (!"3".equals(level)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9[\u7ea7\u6b21]=3\u7684\u884c\u8bbe\u7f6e\u5206\u7c7b\u5bf9\u5e94", (String)"GoodsList_12", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("id", id);
                String standid = String.valueOf(this.getModel().getValue(CMBSTANDARDLST));
                IPageCache redisBdCache = this.getPageCache();
                redisBdCache.put("showF7", "unshowF7");
                if (!ZJ.equals(standid)) {
                    this.showGoodsF7(false);
                    redisBdCache.put("showGoodsF7", "self");
                    break;
                }
                this.showGoodsF7(true);
                redisBdCache.put("showGoodsF7", "mal");
                break;
            }
            case "query": {
                ArrayList<Object> list = new ArrayList<Object>();
                HashMap<String, ArrayList<Object>> malmap = new HashMap<String, ArrayList<Object>>(16);
                HashSet<Long> idSet = new HashSet<Long>(16);
                for (ListSelectedRow row : selectCol) {
                    String id = row.getPrimaryKeyValue().toString();
                    idSet.add(Long.parseLong(id));
                }
                QFilter idfilter = new QFilter("id", "in", idSet);
                DynamicObjectCollection categories = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id,level", (QFilter[])new QFilter[]{idfilter});
                for (DynamicObject category : categories) {
                    String level = category.get("level").toString();
                    if (!"3".equals(level)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9[\u7ea7\u6b21]=3\u7684\u884c\u67e5\u770b\u5bf9\u5e94\u660e\u7ec6", (String)"GoodsList_13", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    list.add(category.get("id"));
                    malmap.put("ids", list);
                }
                CloseCallBack closeCallBack = new CloseCallBack();
                fsp.setFormId(PBDQUERYCLASS);
                fsp.setCustomParams(malmap);
                fsp.setCloseCallBack(closeCallBack);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "updateclass": {
                List<String> malList = this.updateClass();
                HashMap<String, List<String>> map = new HashMap<String, List<String>>(malList.size());
                if (malList.size() > 0) {
                    map.put("source", malList);
                    fsp.setFormId("pbd_updateclass");
                    fsp.setCustomParams(map);
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "update"));
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(fsp);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6388\u6743\uff0c\u4e0d\u80fd\u66f4\u65b0\u7535\u5546\u5206\u7c7b\uff01", (String)"GoodsList_14", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "importdata2": {
                List<String> importList = this.updateClass();
                HashMap<String, List<String>> importMap = new HashMap<String, List<String>>(importList.size());
                if (importList.size() > 0) {
                    importMap.put("source", importList);
                    fsp.setFormId("pbd_syncclass");
                    fsp.setCustomParams(importMap);
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(fsp);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6388\u6743\uff0c\u4e0d\u80fd\u4ece\u7535\u5546\u5e73\u53f0\u5f15\u5165\uff01", (String)"GoodsList_15", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "viewcommenttemp": {
                this.showCommentTemplate(args);
            }
        }
    }

    private void showCommentTemplate(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            QFilter tempQFilter = new QFilter("commtplclassentry.class.id", "=", successPkIds.get(0));
            tempQFilter.and("enable", "=", (Object)"1");
            tempQFilter.and("alluse", "=", (Object)"0");
            DynamicObject commentTemplate = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_commenttemplate", (String)"id", (QFilter[])tempQFilter.toArray());
            if (commentTemplate == null) {
                QFilter allUseQFilter = new QFilter("alluse", "=", (Object)"1");
                allUseQFilter.and("enable", "=", (Object)"1");
                commentTemplate = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_commenttemplate", (String)"id", (QFilter[])allUseQFilter.toArray());
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pmm_commenttemplate");
            showParameter.setPkId((Object)commentTemplate.getLong("id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showGoodsF7(boolean isboolean) {
        String pageid = this.getPageCache().get("id");
        Object[] seleteds = null;
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)MDRGOODSCLASS, (boolean)isboolean);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5206\u7c7b\u5bf9\u5e94\t", (String)"GoodsList_16", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
        if (isboolean) {
            QFilter qFilter = new QFilter("selfcatogryid", "=", (Object)Long.parseLong(pageid));
            DynamicObjectCollection categories = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"eccatogryid", (QFilter[])new QFilter[]{qFilter});
            if (categories.size() > 0) {
                seleteds = new String[categories.size()];
                for (int i = 0; i < categories.size(); ++i) {
                    DynamicObject object = (DynamicObject)categories.get(i);
                    seleteds[i] = object.getString("eccatogryid");
                }
            }
            QFilter selfqFilter = new QFilter("id", "=", (Object)Long.parseLong(pageid));
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"number,name", (QFilter[])new QFilter[]{selfqFilter});
            String number = queryOne.getString("number");
            String name = queryOne.getString("name");
            if (number.length() > 10) {
                number = number.substring(0, 10);
                stringBuilder.append(ResManager.loadKDString((String)"(\u81ea\u5efa\u5206\u7c7b\u7f16\u7801\uff1a", (String)"GoodsList_17", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(number).append("...").append(' ');
            } else {
                stringBuilder.append(ResManager.loadKDString((String)"(\u81ea\u5efa\u5206\u7c7b\u7f16\u7801\uff1a", (String)"GoodsList_17", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(number).append(' ');
            }
            if (name.length() > 10) {
                name = name.substring(0, 10);
                stringBuilder.append(ResManager.loadKDString((String)"\u81ea\u5efa\u5206\u7c7b\u540d\u79f0\uff1a", (String)"GoodsList_18", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(name).append("...").append(')');
            } else {
                stringBuilder.append(ResManager.loadKDString((String)"\u81ea\u5efa\u5206\u7c7b\u540d\u79f0\uff1a", (String)"GoodsList_18", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(name).append(')');
            }
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addentry"));
            DynamicObjectCollection dyos = this.getStandardDyos();
            ArrayList<Long> stdList = new ArrayList<Long>();
            for (DynamicObject dyo : dyos) {
                stdList.add(dyo.getLong("standard.id"));
            }
            QFilter enableFilter = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("standard", "in", stdList));
            lsp.getListFilterParameter().getQFilters().add(enableFilter);
        } else {
            QFilter qFilter = new QFilter("eccatogryid", "=", (Object)Long.parseLong(pageid));
            DynamicObject categories = QueryServiceHelper.queryOne((String)PBDGOODSCATEGORY, (String)"selfcatogryid", (QFilter[])new QFilter[]{qFilter});
            if (categories != null) {
                seleteds = new String[]{categories.getString("selfcatogryid")};
            }
            QFilter selfqFilter = new QFilter("id", "=", (Object)Long.parseLong(pageid));
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"number,name", (QFilter[])new QFilter[]{selfqFilter});
            String number = queryOne.getString("number");
            String name = queryOne.getString("name");
            if (number.length() > 10) {
                number = number.substring(0, 10);
                stringBuilder.append(ResManager.loadKDString((String)"(\u7535\u5546\u5206\u7c7b\u7f16\u7801\uff1a", (String)"GoodsList_19", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(number).append("...").append(' ');
            } else {
                stringBuilder.append(ResManager.loadKDString((String)"(\u7535\u5546\u5206\u7c7b\u7f16\u7801\uff1a", (String)"GoodsList_19", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(number).append(' ');
            }
            if (name.length() > 10) {
                name = name.substring(0, 10);
                stringBuilder.append(ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u540d\u79f0\uff1a", (String)"GoodsList_20", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(name).append("...").append(')');
            } else {
                stringBuilder.append(ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u540d\u79f0\uff1a", (String)"GoodsList_20", (String)"bd-pbd-formplugin", (Object[])new Object[0])).append(name).append(')');
            }
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leftentry"));
            QFilter enableFilter = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("standard", "=", (Object)Long.parseLong(ZJ)));
            lsp.getListFilterParameter().getQFilters().add(enableFilter);
        }
        if (seleteds != null) {
            lsp.setSelectedRows(seleteds);
        }
        lsp.setCaption(stringBuilder.toString());
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        super.closedCallBack(arg0);
        String actionId = arg0.getActionId();
        List returnData = (List)arg0.getReturnData();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"addentry") || StringUtils.equals((CharSequence)actionId, (CharSequence)"leftentry")) {
            IPageCache redisBdCache = this.getPageCache();
            redisBdCache.put("showF7", null);
            redisBdCache.put("showGoodsF7", null);
            if (returnData == null) {
                return;
            }
            ArrayList<String> returnDataList = new ArrayList<String>(returnData.size());
            for (ListSelectedRow str : returnData) {
                returnDataList.add(String.valueOf(str));
            }
            this.getPageCache().put("returnData", String.join((CharSequence)",", returnDataList));
            this.fillBackOrgF7SelectedData(actionId, returnData);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"add")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"update")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void fillBackOrgF7SelectedData(String actionId, Object returnData) {
        String pageid = this.getPageCache().get("id");
        String selfcatogryid = null;
        String source = null;
        if (returnData == null) {
            return;
        }
        ArrayList<String> selectedOrgList = new ArrayList<String>();
        if (StringUtils.isNotBlank((Object)returnData) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            for (Object row : rows) {
                selectedOrgList.add(row.getPrimaryKeyValue().toString());
            }
        }
        if (selectedOrgList.isEmpty()) {
            return;
        }
        DynamicObjectCollection classColl = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"eccatogryid", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        ArrayList<String> eccatogryList = new ArrayList<String>();
        if (classColl.size() > 0) {
            for (DynamicObject dynamic : classColl) {
                String eccatogryid = dynamic.getString("eccatogryid");
                eccatogryList.add(eccatogryid);
            }
        }
        ArrayList<Long> orglist = new ArrayList<Long>();
        for (String s : selectedOrgList) {
            if (!eccatogryList.contains(s)) continue;
            orglist.add(Long.parseLong(s));
        }
        StringBuilder nameBuilder = new StringBuilder();
        String ifName = null;
        QFilter qf = new QFilter("eccatogryid", "in", orglist);
        DynamicObjectCollection goods = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"selfcatogryid.name,eccatogryid.name", (QFilter[])new QFilter[]{qf});
        for (Object object : goods) {
            nameBuilder.append(object.getString("eccatogryid.name")).append(',');
            ifName = object.getString("selfcatogryid.name");
        }
        if (orglist.size() > 0) {
            ArrayList<String> goodsList = new ArrayList<String>(orglist.size());
            for (Long str : orglist) {
                goodsList.add(String.valueOf(str));
            }
            this.getPageCache().put("goodsid", String.join((CharSequence)",", goodsList));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u66f4\u65b0\u539f\u6709\u5bf9\u5e94\u5173\u7cfb\uff1f", (String)"GoodsList_21", (String)"bd-pbd-formplugin", (Object[])new Object[0]), MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u7535\u5546\u5546\u54c1\u5206\u7c7b{0}\u5df2\u4e0e\u5176\u4ed6\u81ea\u5efa\u5546\u54c1\u5206\u7c7b{1}\u5b58\u5728\u5bf9\u5e94\u5173\u7cfb\uff0c\u662f\u5426\u66f4\u65b0\u539f\u6709\u5bf9\u5e94\u5173\u7cfb\uff1f", (String)"GoodsList_22", (String)"bd-pbd-formplugin", (Object[])new Object[0]), nameBuilder, ifName), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("confirm"));
            return;
        }
        if ("addentry".equals(actionId)) {
            this.saveMdrg(selectedOrgList);
        }
        if ("leftentry".equals(actionId)) {
            ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(selectedOrgList.size());
            for (String s : selectedOrgList) {
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)PBDGOODSCATEGORY);
                selfcatogryid = s;
                source = this.standaredate(pageid);
                dyo.set("source", (Object)source);
                dyo.set("selfcatogryid", (Object)selfcatogryid);
                dyo.set("eccatogryid", (Object)Long.parseLong(pageid));
                dyo.set("status", (Object)"C");
                dyo.set("enable", (Object)"1");
                Date date = new Date();
                dyo.set("creator", (Object)RequestContext.get().getUserId());
                dyo.set("createtime", (Object)date);
                dyo.set("modifier", (Object)RequestContext.get().getUserId());
                dyo.set("modifytime", (Object)date);
                dyoList.add(dyo);
            }
            QFilter qfilter = new QFilter("eccatogryid", "=", (Object)Long.parseLong(pageid)).and(new QFilter("source", "=", (Object)source));
            DynamicObject collection = QueryServiceHelper.queryOne((String)PBDGOODSCATEGORY, (String)"selfcatogryid", (QFilter[])new QFilter[]{qfilter});
            if (collection != null) {
                String selfcatid = collection.getString("selfcatogryid");
                DeleteServiceHelper.delete((String)PBDGOODSCATEGORY, (QFilter[])new QFilter[]{qfilter});
                DynamicObjectCollection query = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"selfcatogryid.name", (QFilter[])new QFilter[]{new QFilter("selfcatogryid", "=", (Object)Long.parseLong(selfcatid))});
                if (query.size() == 0) {
                    DynamicObject dys = BusinessDataServiceHelper.loadSingle((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(selfcatid))});
                    dys.set("selfclassification", null);
                    SaveServiceHelper.save((IDataEntityType)dys.getDataEntityType(), (Object[])new DynamicObject[]{dys});
                }
            }
            this.updateCommerce(selfcatogryid, pageid);
            SaveServiceHelper.save((DynamicObject[])dyoList.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5173\u7cfb\u4fdd\u5b58\u6210\u529f", (String)"GoodsList_24", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        String callBackId = arg0.getCallBackId();
        if ("confirm".equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            String returnData = this.getPageCache().get("returnData");
            String[] split = returnData.split(",");
            ArrayList<String> selectedList = new ArrayList<String>(split.length);
            selectedList.addAll(Arrays.asList(split));
            String goodsid = this.getPageCache().get("goodsid");
            String[] goodsidsplit = goodsid.split(",");
            ArrayList<String> goodsidList = new ArrayList<String>(goodsidsplit.length);
            goodsidList.addAll(Arrays.asList(goodsidsplit));
            ArrayList<Long> goodsList = new ArrayList<Long>(goodsidsplit.length);
            for (String str : goodsidList) {
                goodsList.add(Long.parseLong(str));
            }
            QFilter qfilter = new QFilter("eccatogryid", "in", goodsList);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"selfcatogryid", (QFilter[])new QFilter[]{qfilter});
            HashSet<Long> collSet = new HashSet<Long>();
            if (collection.size() > 0) {
                DynamicObject[] dynArr;
                DynamicObject[] deleteArr;
                QFilter filterid;
                for (DynamicObject dyn : collection) {
                    collSet.add(dyn.getLong("selfcatogryid"));
                }
                DeleteServiceHelper.delete((String)PBDGOODSCATEGORY, (QFilter[])new QFilter[]{qfilter});
                QFilter filter = new QFilter("selfcatogryid", "in", collSet);
                DynamicObjectCollection dyntion = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"selfcatogryid,selfcatogryid.name", (QFilter[])new QFilter[]{filter});
                if (dyntion.size() == 0) {
                    filterid = new QFilter("id", "in", collSet);
                } else {
                    ArrayList<Long> selfList = new ArrayList<Long>();
                    for (Object dyn : dyntion) {
                        selfList.add(dyn.getLong("selfcatogryid"));
                    }
                    DynamicObject[] updateList = new ArrayList();
                    for (Long s : selfList) {
                        if (collSet.contains(s)) continue;
                        updateList.add(s);
                    }
                    filterid = new QFilter("id", "in", (Object)updateList);
                }
                for (DynamicObject dyn : deleteArr = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{filterid})) {
                    dyn.set("selfclassification", null);
                }
                SaveServiceHelper.save((DynamicObject[])deleteArr);
                QFilter qfiltery = new QFilter("id", "in", goodsList);
                for (DynamicObject dyn : dynArr = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{qfiltery})) {
                    dyn.set("selfclassification", null);
                }
                SaveServiceHelper.save((DynamicObject[])dynArr);
            }
            this.saveMdrg(selectedList);
            this.getView().invokeOperation("refresh");
        }
    }

    private void saveMdrg(List<String> selectedOrgList) {
        DynamicObject[] dynArr;
        String pageid = this.getPageCache().get("id");
        ArrayList<Long> selectedList = new ArrayList<Long>(selectedOrgList.size());
        ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(selectedOrgList.size());
        for (String eccatogryid : selectedOrgList) {
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)PBDGOODSCATEGORY);
            selectedList.add(Long.parseLong(eccatogryid));
            dyo.set("source", (Object)this.standaredate(eccatogryid));
            dyo.set("selfcatogryid", (Object)pageid);
            dyo.set("eccatogryid", (Object)eccatogryid);
            dyo.set("status", (Object)"C");
            dyo.set("enable", (Object)"1");
            Date date = new Date();
            dyo.set("creator", (Object)RequestContext.get().getUserId());
            dyo.set("createtime", (Object)date);
            dyo.set("modifier", (Object)RequestContext.get().getUserId());
            dyo.set("modifytime", (Object)date);
            dyoList.add(dyo);
        }
        QFilter qfilter = new QFilter("selfcatogryid", "=", (Object)Long.parseLong(pageid));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)PBDGOODSCATEGORY, (String)"eccatogryid", (QFilter[])new QFilter[]{qfilter});
        ArrayList<DynamicObject[]> classList = new ArrayList<DynamicObject[]>();
        if (collection.size() > 0) {
            DynamicObject[] dysArr;
            for (DynamicObject dynamicObject : collection) {
                DynamicObject[] eccatogryid = Long.valueOf(dynamicObject.getLong("eccatogryid"));
                classList.add(eccatogryid);
            }
            DeleteServiceHelper.delete((String)PBDGOODSCATEGORY, (QFilter[])new QFilter[]{qfilter});
            QFilter updatefilter = new QFilter("id", "in", classList).and(new QFilter("level", "=", (Object)Integer.parseInt("3")));
            for (DynamicObject dys : dysArr = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{updatefilter})) {
                dys.set("selfclassification", null);
            }
            SaveServiceHelper.save((DynamicObject[])dysArr);
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(pageid)).and(new QFilter("level", "=", (Object)Integer.parseInt("3")));
        DynamicObject dys = BusinessDataServiceHelper.loadSingle((String)MDRGOODSCLASS, (String)"id,name,selfclassification", (QFilter[])new QFilter[]{filter});
        String msg = ResManager.loadKDString((String)"\u5df2\u5bf9\u5e94", (String)"GoodsList_25", (String)"bd-pbd-formplugin", (Object[])new Object[0]);
        dys.set("selfclassification", (Object)msg);
        SaveServiceHelper.save((IDataEntityType)dys.getDataEntityType(), (Object[])new DynamicObject[]{dys});
        QFilter classfilter = new QFilter("id", "in", selectedList).and(new QFilter("level", "=", (Object)Integer.parseInt("3")));
        for (DynamicObject dyn : dynArr = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{classfilter})) {
            dyn.set("selfclassification", (Object)dys.getString("name"));
        }
        SaveServiceHelper.save((DynamicObject[])dynArr);
        SaveServiceHelper.save((DynamicObject[])dyoList.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5173\u7cfb\u4fdd\u5b58\u6210\u529f", (String)"GoodsList_24", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
    }

    private void updateCommerce(String selfcatogryid, String pageid) {
        QFilter filters = new QFilter("id", "=", (Object)Long.parseLong(selfcatogryid)).and(new QFilter("level", "=", (Object)Integer.parseInt("3")));
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)MDRGOODSCLASS, (String)"id,name,selfclassification", (QFilter[])new QFilter[]{filters});
        String msg = ResManager.loadKDString((String)"\u5df2\u5bf9\u5e94", (String)"GoodsList_25", (String)"bd-pbd-formplugin", (Object[])new Object[0]);
        dyn.set("selfclassification", (Object)msg);
        SaveServiceHelper.save((IDataEntityType)dyn.getDataEntityType(), (Object[])new DynamicObject[]{dyn});
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(pageid)).and(new QFilter("level", "=", (Object)Integer.parseInt("3")));
        DynamicObject dys = BusinessDataServiceHelper.loadSingle((String)MDRGOODSCLASS, (String)"id,selfclassification", (QFilter[])new QFilter[]{filter});
        dys.set("selfclassification", (Object)dyn.getString("name"));
        SaveServiceHelper.save((IDataEntityType)dys.getDataEntityType(), (Object[])new DynamicObject[]{dys});
    }

    private String standaredate(Object id) {
        String source = null;
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(id)));
        DynamicObjectCollection categories = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id,name,standard.id", (QFilter[])new QFilter[]{filter});
        if (categories.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)categories.get(0);
            String standard = dynamicObject.getString("standard.id");
            source = this.querysource(standard);
        }
        return source;
    }

    private String querysource(String standard) {
        QFilter filter = new QFilter("standard", "=", (Object)Long.parseLong(standard));
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
        return null != dyo ? dyo.getString("platform") : "1";
    }

    private String setMainShow(boolean isShow) {
        DynamicObject[] categories;
        String soure = null;
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.size() == 0) {
            listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"GoodsList_26", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
            soure = "false";
            return soure;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectCol) {
            Long id = Long.parseLong(row.getPrimaryKeyValue().toString());
            ids.add(id);
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        for (DynamicObject category : categories = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,isonhomepage,enable", (QFilter[])new QFilter[]{idfilter})) {
            if (isShow) {
                String enable = category.getString("enable");
                if ("0".equals(enable)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u7684\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u9996\u9875\u5c55\u793a\uff01", (String)"GoodsList_27", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                    soure = "false";
                    return soure;
                }
                category.set("isonhomepage", (Object)1);
            } else {
                category.set("isonhomepage", (Object)0);
            }
            soure = "true";
        }
        SaveServiceHelper.save((DynamicObject[])categories);
        this.getView().invokeOperation("refresh");
        return soure;
    }

    private void disableShow() {
        DynamicObject[] categories;
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectCol) {
            Long id = Long.parseLong(row.getPrimaryKeyValue().toString());
            ids.add(id);
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        for (DynamicObject category : categories = BusinessDataServiceHelper.load((String)MDRGOODSCLASS, (String)"id,isonhomepage", (QFilter[])new QFilter[]{idfilter})) {
            category.set("isonhomepage", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])categories);
        this.getView().invokeOperation("refresh");
    }
}

